/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.topology;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="HRUSetSubbasin", author="Sven Kralisch", description="Assign HRUs their respective subbasin (independent of parameter file)", date="2025-07-01", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class HRUSetSubbasin
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hrus")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of reaches")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of sub-basin attribute in HRUs", defaultValue="subbasin")
    public Attribute.String subbasinAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of sub-basin entity collection in reaches", defaultValue="subbasinhrus")
    public Attribute.String subbasinEntitiesAttributeName;

    public void init() {
        for (Attribute.Entity reach : this.reaches.getEntities()) {
            Attribute.EntityCollection hrus = (Attribute.EntityCollection)reach.getObject(this.subbasinEntitiesAttributeName.getValue());
            for (Attribute.Entity hru : hrus.getEntities()) {
                hru.setDouble(this.subbasinAttributeName.getValue(), (double)reach.getId());
            }
        }
    }
}

