/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.statistics;

import jams.JAMS;
import jams.data.ArrayPool;
import java.io.Serializable;
import java.util.Arrays;

public class IDW
implements Serializable {
    ArrayPool<double[]> memPool = new ArrayPool(Double.TYPE);
    double[] dist = null;
    double[] weights = null;
    int[] wArray = null;
    int n = 0;
    double[] statX;
    double[] statY;
    double[] statElevation;
    double pidw;
    Projection proj;

    public void init(double[] statX, double[] statY, double[] statElevation, double pidw, Projection proj) {
        this.n = statX.length;
        if (this.dist == null || this.dist.length != this.n) {
            this.dist = new double[this.n];
        }
        if (this.weights == null || this.weights.length != this.n) {
            this.weights = new double[this.n];
        }
        if (this.wArray == null || this.wArray.length != this.n) {
            this.wArray = new int[this.n];
        }
        this.proj = proj;
        this.statX = statX;
        this.statY = statY;
        this.pidw = pidw;
        this.statElevation = statElevation;
    }

    public double getElevationCorrectedIDW(double x, double y, double elevation, double w, double[] data, int p) {
        int i;
        if (this.proj == Projection.ANY) {
            this.calcDistances(x, y, this.statX, this.statY, this.pidw);
        } else {
            this.calcLatLongDistances(x, y, this.statX, this.statY, this.pidw);
        }
        if (data == null) {
            this.calcWeights();
        } else {
            this.calcWeights(data);
        }
        this.computeWeightArray();
        if (data == null) {
            return 0.0;
        }
        double[] idw_data = (double[])this.memPool.alloc(p);
        double[] idw_weights = (double[])this.memPool.alloc(p);
        double[] idw_elev = (double[])this.memPool.alloc(p);
        int counter = 0;
        for (int element = 0; counter < p && element < this.wArray.length; ++element) {
            int t = this.wArray[element];
            if (data[t] == JAMS.getMissingDataValue()) continue;
            idw_data[counter] = data[t];
            idw_weights[counter] = this.weights[t];
            if (this.statElevation != null) {
                idw_elev[counter] = this.statElevation[t];
            }
            ++counter;
        }
        double weightsum = 0.0;
        for (i = 0; i < counter; ++i) {
            weightsum += idw_weights[i];
        }
        for (i = 0; i < counter; ++i) {
            idw_weights[i] = idw_weights[i] / weightsum;
        }
        double result = 0.0;
        for (int t = 0; t < counter; ++t) {
            double deltaElev = elevation - idw_elev[t];
            result += (deltaElev * w + idw_data[t]) * idw_weights[t];
        }
        return result;
    }

    public double getIDW(double x, double y, double[] data, int p) {
        return this.getElevationCorrectedIDW(x, y, 0.0, 0.0, data, p);
    }

    public double[] getWeights() {
        return this.weights;
    }

    public int[] getWeightOrder() {
        return this.wArray;
    }

    public void calcDistances(double entityX, double entityY, double[] statX, double[] statY, double pidw) {
        for (int s = 0; s < statX.length; ++s) {
            double x = entityX - statX[s];
            double y = entityY - statY[s];
            this.dist[s] = x * x + y * y;
            if (pidw == 2.0) continue;
            this.dist[s] = Math.pow(this.dist[s], pidw / 2.0);
        }
    }

    private double[] calcLatLongDistances(double entityX, double entityY, double[] statX, double[] statY, double pidw) {
        double R = 6378137.0;
        for (int s = 0; s < statX.length; ++s) {
            this.dist[s] = 6378137.0 * Math.acos(Math.sin(IDW.rad(entityY)) * Math.sin(IDW.rad(statY[s])) + Math.cos(IDW.rad(entityY)) * Math.cos(IDW.rad(statY[s])) * Math.cos(IDW.rad(statX[s]) - IDW.rad(entityX)));
            this.dist[s] = Math.abs(Math.pow(this.dist[s], pidw));
        }
        return this.dist;
    }

    private double[] calcWeights() {
        int i;
        double[] temp = (double[])this.memPool.alloc(this.n);
        double distsum = 0.0;
        double tempsum = 0.0;
        for (i = 0; i < this.n; ++i) {
            distsum += this.dist[i];
        }
        for (i = 0; i < this.n; ++i) {
            temp[i] = distsum / this.dist[i];
            tempsum += temp[i];
        }
        for (int s = 0; s < this.n; ++s) {
            if (this.dist[s] == 0.0) {
                Arrays.fill(this.weights, 0.0);
                this.weights[s] = 1.0;
                return this.weights;
            }
            this.weights[s] = temp[s] / tempsum;
        }
        this.memPool.free((Object)temp);
        return this.weights;
    }

    private double[] calcWeights(double[] data) {
        int i;
        double distsum = 0.0;
        double tempsum = 0.0;
        for (i = 0; i < this.n; ++i) {
            distsum += this.dist[i];
        }
        for (i = 0; i < this.n; ++i) {
            if (!(this.dist[i] > 0.0)) continue;
            tempsum += distsum / this.dist[i];
        }
        for (int s = 0; s < this.n; ++s) {
            if (this.dist[s] == 0.0 && data[s] != JAMS.getMissingDataValue()) {
                Arrays.fill(this.weights, 0.0);
                this.weights[s] = 1.0;
                return this.weights;
            }
            this.weights[s] = this.dist[s] == 0.0 && data[s] == JAMS.getMissingDataValue() ? 0.0 : distsum / this.dist[s] / tempsum;
        }
        return this.weights;
    }

    private int[] computeWeightArray() {
        int pos = 0;
        double[] tempWeight = (double[])this.memPool.alloc(this.n);
        System.arraycopy(this.weights, 0, tempWeight, 0, this.n);
        for (int j = 0; j < this.n; ++j) {
            double maxWeight = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.n; ++i) {
                if (!(tempWeight[i] > maxWeight)) continue;
                maxWeight = this.weights[i];
                pos = i;
            }
            tempWeight[pos] = Double.NEGATIVE_INFINITY;
            this.wArray[j] = pos;
        }
        tempWeight = (double[])this.memPool.free((Object)tempWeight);
        return this.wArray;
    }

    private static double rad(double decDeg) {
        return decDeg * Math.PI / 180.0;
    }

    public static enum Projection {
        LATLON,
        ANY;

    }
}

