/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="PRMSProcessSnow", author="Peter Krause, and the guys form the USGS", description="Adaptation of the PRMS module for snow calculation")
public class PRMSProcessSnowR
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity cover density in winter")
    public Attribute.Double covDensWin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity cover density in summer")
    public Attribute.Double covDensSum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="cover type of entity 0 = bareSoil, 1 = grass, 2 = shrubs, 3 = trees")
    public Attribute.Double covType;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="type of entity 1 = land, 2 = water")
    public Attribute.Double entityType;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="variable snowCrv [PRMS: Scrv]")
    public Attribute.Double snowCurve;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="variable snowCovAreaSave [PRMS: Snowcov_areasv]")
    public Attribute.Double snowCovAreaSave;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="variable albedoSave [PRMS: Salb]")
    public Attribute.Double packAlbedoSave;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="variable lstSave [PRMS: Slst]")
    public Attribute.Double lstSave;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="variable intAlbedo [PRMS: Int_alb]")
    public Attribute.Integer intAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow surface albedo [PRMS: Albedo]")
    public Attribute.Double packAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="precipitation added to snowpack [PRMS: Pk_precip]")
    public Attribute.Double packPrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="temperature of the snowpack [PRMS: Pk_temp]")
    public Attribute.Double packTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="density of the snowpack [PRMS: Pk_den]")
    public Attribute.Double packDensity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="net snowpack energy balance [PRMS: Tcal]")
    public Attribute.Double packEnergyBal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="evaporation and sublimation from snowpack [PRMS: Snow_evap]")
    public Attribute.Double snowET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="snowmelt from snowpack [PRMS: Snowmelt]")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snowpack water equivalent [PRMS: Pkwater_equiv]")
    public Attribute.Double snowWaterEquivalent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow-covered area (decimal percent) [PRMS: Snowcov_area]")
    public Attribute.Double snowCovArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="indicator that a rain-snow mix event has occured withno snowpack present [PRMS: Pptmix_nopack]")
    public Attribute.Boolean pptMixNoSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var iasw/flag [PRMS: Iasw]")
    public Attribute.Boolean iasw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var iso/flag [PRMS: Iso]")
    public Attribute.Integer iso;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var/flag mso [PRMS: Mso]")
    public Attribute.Integer mso;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var/flag lso [PRMS: Lso]")
    public Attribute.Integer lso;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var/flag lst [PRMS: Lst]")
    public Attribute.Boolean lst;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="heat deficit in the lower snowpack [PRMS: Pk_def]")
    public Attribute.Double packDef;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="frozen part of the pack's swe [PRMS: Pk_ice]")
    public Attribute.Double packIce;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="liquid part of the pack's swe [PRMS: freeh2o]")
    public Attribute.Double packFreeWater;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="depth of the snowpack [PRMS: Pk_depth]")
    public Attribute.Double packDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var pss [PRMS: Pss]")
    public Attribute.Double pss;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var pst [PRMS: Pst]")
    public Attribute.Double pst;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="captures the old swe of the time step before [PRMS: Pksv]")
    public Attribute.Double packSWEtm1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="captures the old snow of the time step before [PRMS: Snsv]")
    public Attribute.Double snowSave;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="density of new snow [PRMS: Den_init]")
    public Attribute.Double initDens;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Snowpack settlement time constant [PRMS: Settle_const]")
    public Attribute.Double settleConst;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Average maximum snowpack density [PRMS: Den_max]")
    public Attribute.Double maxDens;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Julian date to start looking for spring snowmelt, Julian date to start looking for spring snowmelt stage. Varies with region depending on length of time that permanent snowpack exists [PRMS: Melt_look]")
    public Attribute.Integer meltLook;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Julian date to force snowpack to spring snowmelt stage.Varies with region depending on length of time thatpermanent snowpack exists' [PRMS: Melt_force]")
    public Attribute.Integer meltForce;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Transmission coefficient for short-wave radiation throughthe winter vegetation canopy in decimal percent [PRMS: Rad_trncf]")
    public Attribute.Double radTransCoef;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Maximum threshold water equivalent for snow depletion.The maximum threshold snowpack water equivalent belowwhich the snow-covered-area curve is applied. Varies with elevation (not here!). [PRMS: Snarea_thresh]")
    public Attribute.Double snowAreaThresh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Albedo reset - rain,  melt stage,Proportion of rain (decimal percent) in a rain-snow precipitation eventabove which the snow albedo is not reset. Applied duringthe snowpack melt stage [PRMS: Albset_rnm]")
    public Attribute.Double albedoResetRainMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Albedo reset - rain, accumulation stage,Proportion of rain (decimal percent) in a rain-snow precipitation eventabove which the snow albedo is not reset. Applied duringthe snowpack accumulation stage [PRMS: Albset_rna]")
    public Attribute.Double albedoResetRainAccu;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Albedo reset - snow, melt stage,Minimum snowfall, in water equivalent, needed to resetsnow albedo during the snowpack melt stage[PRMS: Albset_snm]")
    public Attribute.Double albedoResetSnowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Albedo reset - snow, accumulation stageMinimum snowfall, in water equivalent, needed to resetsnow albedo during the snowpack accumulation stage[PRMS: Albset_sna]")
    public Attribute.Double albedoResetSnowAccu;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Emissivity of air on days without precipitationAverage emissivity of air on days without precipitation[PRMS: Emis_noppt]")
    public Attribute.Double emisNoPrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Proportion (decimal percent) of potential ET that is sublimated from thesnow surface [PRMS: Potet_sublim]")
    public Attribute.Double petSublimProp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Free-water holding capacity (decimal percent) of snowpack expressed as decimal fraction of total snowpack water equivalent [PRMS: Freeh2o_cap]")
    public Attribute.Double packFreeWaterCapacity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Precip all snow if hru max temperature below this value.If HRU maximum temperature is less than or equal to thisvalue, precipitation is assumed to be snow [PRMS: Tmax_allsnow]")
    public Attribute.Double tmaxAllSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Multiplier for the cecn values [PRMS: n/a]")
    public Attribute.Double cecnFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="minum temperature")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="mean temperature")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="max temperature")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="observed or calculated solar radiation")
    public Attribute.Double solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="observed or calculated shortwave radiation")
    public Attribute.Double swRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="total precipitation (rain and snow)")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain amount of precipitation, will be changed during snow modelling")
    public Attribute.Double inRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow amount of precipitation, will be changed during snow modelling")
    public Attribute.Double inSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="save rain for output")
    public Attribute.Double svRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="save snow for output")
    public Attribute.Double svSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actual evapotranspiration so far")
    public Attribute.Double aET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="potential evapotranspiration")
    public Attribute.Double pET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="module active")
    public Attribute.Boolean active;
    double[] snowAreaCurve = new double[]{0.05, 0.24, 0.47, 0.43, 0.56, 0.75, 0.82, 0.88, 0.93, 0.99, 1.0};
    double[] cecnCoef = new double[]{8.51, 8.51, 8.95, 8.95, 8.95, 8.95, 8.95, 8.95, 8.95, 8.95, 8.51, 8.51};
    int[] tStorm = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0};
    double[] aCum = new double[]{0.8, 0.77, 0.75, 0.72, 0.7, 0.69, 0.68, 0.67, 0.66, 0.65, 0.64, 0.63, 0.62, 0.61, 0.6};
    double[] aMlt = new double[]{0.72, 0.65, 0.6, 0.58, 0.56, 0.54, 0.52, 0.5, 0.48, 0.46, 0.44, 0.43, 0.42, 0.41, 0.4};
    int MAXALB = this.aMlt.length - 1;
    double runSwRad = 0.0;
    double denInv;
    double setDen;
    double set1;
    boolean pptMix = false;
    boolean newSnow = false;
    double rainPart = 0.0;
    double runPackSwe;
    double runPackPrecip;
    double runRain;
    double runSnow;
    double runPackDef;
    double runPackTemp;
    double runPackIce;
    double runPackFreeWater;
    double runSnowCovArea;
    double runSnowMelt;
    double runPackDensity;
    double runPackDepth;
    double runSnowCovAreaSave;
    double runPst;
    double runPackSWEtm1;
    double runSnowCurve;
    double runLstSave;
    double runPackAlbedoSave;
    double runPss;
    double runTmin;
    double runTmean;
    double runTmax;
    double runPackEnergyBal;
    double runAet;
    double runPet;
    double runSolRad;
    double runPrecip;
    double runTavgC;
    double runSnowSave;
    double runPackAlbedo;
    double runSnowET;
    boolean runLst;
    boolean runTranspOn;
    final double MJ2LY = 28.88458966;
    final double MM2IN = 0.039370078;
    final double IN2MM = 25.4;
    final double IN2CM = 2.54;
    final double NEARZERO = 1.0E-5;

    double c_2_f(double tempC) {
        return 1.8 * tempC + 32.0;
    }

    public double f_2_c(double tempF) {
        return (tempF - 32.0) * 0.5555555555555556;
    }

    public void init() {
        if (this.active == null || this.active.getValue()) {
            this.aET.setValue(0.0);
            this.runSnowET = 0.0;
            this.snowCurve.setValue(0.0);
            this.snowCovAreaSave.setValue(0.0);
            this.packAlbedoSave.setValue(0.0);
            this.lstSave.setValue(0.0);
            this.packTemp.setValue(0.0);
            this.packDensity.setValue(0.0);
            this.packEnergyBal.setValue(0.0);
            this.snowMelt.setValue(0.0);
            this.snowWaterEquivalent.setValue(0.0);
            this.snowCovArea.setValue(0.0);
            this.lst.setValue(false);
            this.packDef.setValue(0.0);
            this.packIce.setValue(0.0);
            this.packFreeWater.setValue(0.0);
            this.packDepth.setValue(0.0);
            this.pss.setValue(0.0);
            this.pst.setValue(0.0);
            this.packSWEtm1.setValue(0.0);
            this.packPrecip.setValue(0.0);
            this.snowSave.setValue(0.0);
        }
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        if (this.active == null || this.active.getValue()) {
            this.run_prms();
        }
    }

    private void mapVarsBack(double balIn, double balStorStart) {
        this.runAet += this.runSnowET;
        this.snowET.setValue(this.runSnowET);
        this.aET.setValue(this.runAet * this.area.getValue());
        this.snowCurve.setValue(this.runSnowCurve);
        this.snowCovAreaSave.setValue(this.runSnowCovAreaSave);
        this.packAlbedoSave.setValue(this.runPackAlbedoSave);
        this.lstSave.setValue(this.runLstSave);
        this.packTemp.setValue(this.runPackTemp);
        this.packDensity.setValue(this.runPackDensity);
        this.packEnergyBal.setValue(this.runPackEnergyBal);
        this.snowMelt.setValue(this.runSnowMelt * this.area.getValue());
        this.snowWaterEquivalent.setValue(this.runPackSwe * this.area.getValue());
        this.snowCovArea.setValue(this.runSnowCovArea);
        this.lst.setValue(this.runLst);
        this.packDef.setValue(this.runPackDef);
        this.packIce.setValue(this.runPackIce);
        this.packFreeWater.setValue(this.runPackFreeWater);
        this.packDepth.setValue(this.runPackDepth);
        this.pss.setValue(this.runPss);
        this.pst.setValue(this.runPst);
        this.packSWEtm1.setValue(this.runPackSWEtm1 * this.area.getValue());
        this.packPrecip.setValue(this.runPackPrecip * this.area.getValue());
        this.snowSave.setValue(this.runSnowSave * this.area.getValue());
        this.packAlbedo.setValue(this.runPackAlbedo);
        this.inSnow.setValue(0.0);
        double balStorEnd = this.runPackSwe;
        double balOut = this.runSnowMelt + this.runRain + this.runSnowET;
        double balance = balIn + (balStorStart - balStorEnd) - balOut;
        if (Math.abs(balance) > 1.0E-4) {
            this.getModel().getRuntime().println(this.time.toString() + " balance error in snow module: " + balance);
            this.getModel().getRuntime().println("balIn: " + balIn);
            this.getModel().getRuntime().println("balStorStart: " + balStorStart);
            this.getModel().getRuntime().println("balStorEnd: " + balStorEnd);
            this.getModel().getRuntime().println("balOut: " + balOut);
            this.getModel().getRuntime().println("shit!");
        }
        this.snowWaterEquivalent.setValue(this.runPackSwe * this.area.getValue() * 25.4);
        this.snowMelt.setValue(this.runSnowMelt * this.area.getValue() * 25.4);
        this.aET.setValue(this.runAet * this.area.getValue() * 25.4);
        this.inRain.setValue(this.runRain * this.IN2MM * this.area.getValue());
    }

    public void ppt_to_pack() {
        double tsnow;
        double train;
        this.runPackPrecip = 0.0;
        double tmas = this.c_2_f(this.tmaxAllSnow.getValue());
        if (this.pptMix) {
            train = this.f_2_c((this.runTmax + tmas) * 0.5);
            tsnow = this.runPackSwe > 0.0 ? this.f_2_c((this.runTmin + tmas) * 0.5) : this.runTavgC;
        } else {
            train = this.runTavgC;
            if (train < 1.0E-5) {
                train = this.f_2_c((this.runTmax + tmas) * 0.5);
            }
            tsnow = this.runTavgC;
        }
        if (train < 1.0E-5) {
            train = 0.0;
        }
        if (tsnow > -1.0E-5) {
            tsnow = 0.0;
        }
        if (this.runPackSwe > 0.0) {
            if (this.runRain > 0.0) {
                this.runPackSwe += this.runRain;
                this.runPackPrecip += this.runRain;
                if (this.runPackDef > 0.0) {
                    double caln = (80.0 + train) * this.IN2CM;
                    double pndz = this.runPackDef / caln;
                    if (Math.abs(this.runRain - pndz) < 1.0E-5) {
                        this.runPackDef = 0.0;
                        this.runPackTemp = 0.0;
                        this.runPackIce += this.runRain;
                        this.runRain = 0.0;
                    } else if (this.runRain < pndz) {
                        this.runPackDef -= caln * this.runRain;
                        this.runPackTemp = -this.runPackDef / (this.runPackSwe * 1.27);
                        this.runPackIce += this.runRain;
                        this.runRain = 0.0;
                    } else {
                        this.runPackDef = 0.0;
                        this.runPackTemp = 0.0;
                        this.runPackIce += pndz;
                        this.runPackFreeWater = this.runRain - pndz;
                        double calpr = train * (this.runRain - pndz) * 2.54;
                        this.calin(calpr);
                    }
                } else {
                    this.runPackFreeWater += this.runRain;
                    double calpr = train * this.runRain * 2.54;
                    this.calin(calpr);
                }
            }
            this.runRain = 0.0;
        } else if (this.runRain > 0.0) {
            this.pptMixNoSnow.setValue(true);
        }
        if (this.runSnow > 0.0) {
            this.runPackSwe += this.runSnow;
            this.runPackPrecip += this.runSnow;
            this.runPackIce += this.runSnow;
            if (tsnow >= 0.0) {
                this.runPackTemp = -this.runPackDef / (this.runPackSwe * 1.27);
            } else {
                double calps = tsnow * this.runSnow * 1.27;
                if (this.runPackFreeWater > 0.0) {
                    this.caloss(calps);
                } else {
                    this.runPackDef -= calps;
                    this.runPackTemp = -this.runPackDef / (this.runPackSwe * 1.27);
                }
            }
        }
    }

    private void calin(double Cal) {
        double dif = Cal - this.runPackDef;
        if (dif < -1.0E-5) {
            this.runPackDef -= Cal;
            this.runPackTemp = -this.runPackDef / (this.runPackSwe * 1.27);
        } else if (dif < 1.0E-5) {
            this.runPackTemp = 0.0;
            this.runPackDef = 0.0;
        } else {
            double pmlt = dif / 203.2;
            double apmlt = pmlt * this.runSnowCovArea;
            this.runPackDef = 0.0;
            this.runPackTemp = 0.0;
            double apk_ice = this.runPackIce / this.runSnowCovArea;
            if (pmlt > apk_ice) {
                this.runSnowMelt += this.runPackSwe;
                this.runPackSwe = 0.0;
                this.iasw.setValue(false);
                this.runSnowCovArea = 0.0;
                this.runPackDef = 0.0;
                this.runPackTemp = 0.0;
                this.runPackIce = 0.0;
                this.runPackFreeWater = 0.0;
                this.runPackDepth = 0.0;
                this.runPss = 0.0;
                this.runPst = 0.0;
                this.runPackDensity = 0.0;
                this.runPackEnergyBal = 0.0;
            } else {
                this.runPackIce -= apmlt;
                this.runPackFreeWater += apmlt;
                double pwcap = this.packFreeWaterCapacity.getValue() * this.runPackIce;
                dif = this.runPackFreeWater - pwcap;
                if (dif > 0.0) {
                    this.runSnowMelt += dif;
                    this.runPackFreeWater = pwcap;
                    this.runPackSwe -= dif;
                    this.runPackDepth = this.runPackSwe / this.runPackDensity;
                    this.runPss = this.runPackSwe;
                }
            }
        }
    }

    private void caloss(double Cal) {
        if (this.runPackFreeWater < 1.0E-5) {
            this.runPackDef -= Cal;
        } else {
            double calnd = this.runPackFreeWater * 203.2;
            double dif = Cal + calnd;
            if (dif < 1.0E-5) {
                if (dif < 0.0) {
                    this.runPackDef = -dif;
                }
                this.runPackIce += this.runPackFreeWater;
                this.runPackFreeWater = 0.0;
            } else {
                this.runPackIce += -Cal / 203.2;
                this.runPackFreeWater -= -Cal / 203.2;
                return;
            }
        }
        if (this.runPackSwe > 0.0) {
            this.runPackTemp = -this.runPackDef / (this.runPackSwe * 1.27);
        }
    }

    public void snowcov(int K) {
        double ai;
        this.runSnowCovArea = this.snowAreaCurve[10];
        if (this.runPackSwe > this.runPst) {
            this.runPst = this.runPackSwe;
        }
        if ((ai = this.runPst) >= this.snowAreaThresh.getValue()) {
            ai = this.snowAreaThresh.getValue();
        }
        if (this.runPackSwe >= ai) {
            this.iasw.setValue(false);
        } else {
            if (!this.newSnow) {
                if (this.iasw.getValue()) {
                    if (this.runPackSwe > this.runSnowCurve) {
                        return;
                    }
                    if (this.runPackSwe >= this.runPackSWEtm1) {
                        double difx = this.runSnowCovArea - this.runSnowCovAreaSave;
                        double dify = this.runSnowCurve - this.runPackSWEtm1;
                        double pcty = 0.0;
                        if (dify > 1.0E-7) {
                            pcty = (this.runPackSwe - this.runPackSWEtm1) / dify;
                        }
                        this.runSnowCovArea = this.runSnowCovAreaSave + pcty * difx;
                        return;
                    }
                    this.iasw.setValue(false);
                }
            } else {
                if (this.iasw.getValue()) {
                    this.runSnowCurve = this.runPackSwe - 0.25 * this.runSnow;
                } else {
                    this.iasw.setValue(true);
                    this.runSnowCovAreaSave = this.runSnowCovArea;
                    this.runPackSWEtm1 = this.runPackSwe - this.runSnow;
                    this.runSnowCurve = this.runPackSwe - 0.25 * this.runSnow;
                }
                return;
            }
            double frac = this.runPackSwe / ai;
            int idx = (int)(10.0 * (frac + 0.2));
            int jdx = idx - 1;
            double af = jdx - 1;
            double dify = frac * 10.0 - af;
            double difx = this.snowAreaCurve[idx - 1] - this.snowAreaCurve[jdx - 1];
            this.runSnowCovArea = this.snowAreaCurve[jdx - 1] + dify * difx;
        }
    }

    private void snalbedo() {
        if (!this.newSnow) {
            if (this.runLst) {
                this.runLstSave = this.runPackAlbedoSave - 3.0;
                if (this.runLstSave - 1.0 < 1.0E-5) {
                    this.runLstSave = 1.0;
                }
                if (this.iso.getValue() != 2 && this.runLstSave - 5.0 > -1.0E-5) {
                    this.runLstSave = 5.0;
                }
                this.runLst = false;
                this.runSnowSave = 0.0;
            }
        } else if (this.mso.getValue() == 2) {
            if (this.rainPart < this.albedoResetRainMelt.getValue()) {
                if (this.runSnow > this.albedoResetSnowMelt.getValue()) {
                    this.runLstSave = 0.0;
                    this.runLst = false;
                    this.runSnowSave = 0.0;
                } else {
                    this.runSnowSave += this.runSnow;
                    if (this.runSnowSave > this.albedoResetSnowMelt.getValue()) {
                        this.runLstSave = 0.0;
                        this.runLst = false;
                        this.runSnowSave = 0.0;
                    } else {
                        if (!this.runLst) {
                            this.runPackAlbedoSave = this.runLstSave;
                        }
                        this.runLstSave = 0.0;
                        this.runLst = true;
                    }
                }
            }
        } else {
            if (!this.pptMix) {
                this.runLstSave = 0.0;
                this.runLst = false;
            } else if (this.rainPart - this.albedoResetRainAccu.getValue() > -1.0E-5) {
                this.runLst = false;
            } else if (this.runSnow - this.albedoResetSnowAccu.getValue() > -1.0E-5) {
                this.runLstSave = 0.0;
                this.runLst = false;
            } else {
                this.runLstSave -= 3.0;
                if (this.runLstSave < 1.0E-5) {
                    this.runLstSave = 0.0;
                }
                if (this.runLstSave - 5.0 > -1.0E-5) {
                    this.runLstSave = 5.0;
                }
                this.runLst = false;
            }
            this.runSnowSave = 0.0;
        }
        int l = (int)(this.runLstSave + 0.5);
        this.runLstSave += 1.0;
        if (l > 0) {
            if (this.intAlbedo.getValue() != 2) {
                if (l <= this.MAXALB) {
                    this.runPackAlbedo = this.aCum[0];
                } else {
                    if ((l -= 12) > this.MAXALB) {
                        l = this.MAXALB;
                    }
                    this.runPackAlbedo = this.aMlt[0];
                }
            } else {
                if (l > this.MAXALB) {
                    l = this.MAXALB;
                }
                this.runPackAlbedo = this.aMlt[0];
            }
        } else if (this.mso.getValue() == 2) {
            this.runPackAlbedo = 0.81;
            this.intAlbedo.setValue(2);
        } else {
            this.runPackAlbedo = 0.91;
            this.intAlbedo.setValue(1);
        }
    }

    private double snowbal(double Esv, double Temp, double Niteda, double Tstorm_mo, double Trd, double Cec, double Cst, double Sw) {
        double sno;
        double ts;
        double air = 5.85E-8 * Math.pow(Temp + 273.16, 4.0);
        double emis = Esv;
        if (Temp < 0.0) {
            ts = Temp;
            sno = air;
        } else {
            ts = 0.0;
            sno = 325.7;
        }
        if (this.runPrecip > 0.0 && Tstorm_mo == 1.0) {
            if (Niteda == 1.0) {
                emis = 0.85;
                if (Trd > 0.33) {
                    emis = this.emisNoPrecip.getValue();
                }
            } else {
                if (Trd > 0.33) {
                    emis = 1.29 - 0.882 * Trd;
                }
                if (Trd >= 0.5) {
                    emis = 0.95 - 0.2 * Trd;
                }
            }
        }
        double sky = (1.0 - this.covDensWin.getValue()) * (emis * air - sno);
        double can = this.covDensWin.getValue() * (air - sno);
        double cecsub = 0.0;
        if (Temp > 0.0 && this.runPrecip > 0.0) {
            cecsub = Cec * Temp;
        }
        double Cal = sky + can + cecsub + Sw;
        if (ts >= 0.0 && Cal > 0.0) {
            this.calin(Cal);
            return Cal;
        }
        double qcond = Cst * (ts - this.runPackTemp);
        if (qcond < -1.0E-5) {
            if (this.runPackTemp < 0.0) {
                this.runPackDef -= qcond;
                this.runPackTemp = -this.runPackDef / (this.runPackSwe * 1.27);
            } else {
                this.caloss(qcond);
            }
        } else if (qcond < 1.0E-5) {
            if (this.runPackTemp >= 0.0 && Cal > 0.0) {
                this.calin(Cal);
            }
        } else if (ts >= 0.0) {
            double pk_defsub = this.runPackDef - qcond;
            if (pk_defsub < 0.0) {
                this.runPackDef = 0.0;
                this.runPackTemp = 0.0;
            } else {
                this.runPackDef = pk_defsub;
                this.runPackTemp = -pk_defsub / (this.runPackSwe * 1.27);
            }
        } else {
            double pkt = -ts * this.runPackSwe * 1.27;
            double pks = this.runPackDef - pkt;
            double pk_defsub = pks - qcond;
            if (pk_defsub < 0.0) {
                this.runPackDef = pkt;
                this.runPackTemp = ts;
            } else {
                this.runPackDef = pk_defsub + pkt;
                this.runPackTemp = -this.runPackDef / (this.runPackSwe * 1.27);
            }
        }
        return Cal;
    }

    private void snowevap() {
        double ez;
        if (this.covType.getValue() > 1.0) {
            double cov = this.covDensWin.getValue();
            if (this.runTranspOn) {
                cov = this.covDensSum.getValue();
            }
            ez = this.petSublimProp.getValue() * this.runPet * this.runSnowCovArea - this.runAet * cov;
        } else {
            ez = this.petSublimProp.getValue() * this.runPet * this.runSnowCovArea;
        }
        if (ez < 1.0E-5) {
            this.runSnowET = 0.0;
        } else if (ez >= this.runPackSwe) {
            this.runSnowET = this.runPackSwe;
            this.runPackSwe = 0.0;
            this.runPackIce = 0.0;
            this.runPackDef = 0.0;
            this.runPackFreeWater = 0.0;
            this.runPackTemp = 0.0;
            this.runPackEnergyBal = 0.0;
        } else {
            this.runPackIce -= ez;
            double cal = this.runPackTemp * ez * 1.27;
            this.runPackDef += cal;
            this.runPackSwe -= ez;
            this.runSnowET = ez;
        }
    }

    public void cleanup() {
    }

    public void run_prms() {
        boolean Ndepl = false;
        this.denInv = 1.0 / this.initDens.getValue();
        this.setDen = this.settleConst.getValue() / this.maxDens.getValue();
        this.set1 = 1.0 / (1.0 + this.settleConst.getValue());
        this.runPackSwe = this.snowWaterEquivalent.getValue() * 0.039370078 / this.area.getValue();
        this.runPackSWEtm1 = this.packSWEtm1.getValue() / this.area.getValue();
        this.runPackPrecip = 0.0;
        this.runSnowSave = this.snowSave.getValue() / this.area.getValue();
        this.runPackDef = this.packDef.getValue();
        this.runPackTemp = this.packTemp.getValue();
        this.runPackIce = this.packIce.getValue();
        this.runPackFreeWater = this.packFreeWater.getValue();
        this.runSnowCovArea = this.snowCovArea.getValue();
        this.runSnowCovAreaSave = this.snowCovAreaSave.getValue();
        this.runSnowMelt = 0.0;
        this.snowMelt.setValue(0.0);
        this.runPackDensity = this.packDensity.getValue();
        this.runPackDepth = this.packDepth.getValue();
        this.runPst = this.pst.getValue();
        this.runSnowCurve = this.snowCurve.getValue();
        this.runPackAlbedo = this.packAlbedo.getValue();
        this.runPackAlbedoSave = this.packAlbedoSave.getValue();
        this.runLst = this.lst.getValue();
        this.runLstSave = this.lstSave.getValue();
        this.runPss = this.pss.getValue();
        this.runPackEnergyBal = this.packEnergyBal.getValue();
        this.runSolRad = this.solRad.getValue() * this.MJ2LY;
        this.runSwRad = this.swRad.getValue() * this.MJ2LY;
        this.runPrecip = this.precip.getValue() * this.MM2IN;
        this.runSnow = this.inSnow.getValue() / this.area.getValue() * 0.039370078;
        this.runRain = this.inRain.getValue() / this.area.getValue() * 0.039370078;
        this.runAet = this.aET.getValue() / this.area.getValue() * 0.039370078;
        this.pptMix = this.runRain > 0.0 && this.runSnow > 0.0;
        this.newSnow = this.runSnow > 0.0;
        this.runPrecip = this.runPrecip;
        this.rainPart = this.runRain / this.runPrecip;
        this.runTmax = this.c_2_f(this.tmax.getValue());
        this.runTmin = this.c_2_f(this.tmin.getValue());
        this.runTavgC = this.tmean.getValue();
        int julDay = this.time.get(6);
        int month = this.time.get(2);
        this.runTranspOn = julDay > 85 && julDay < 305;
        this.runPet = this.pET.getValue() / this.area.getValue() * 0.039370078;
        double balIn = this.runSnow + this.runRain;
        double balStorStart = this.runPackSwe;
        int year = this.time.get(1);
        if (julDay == 305) {
            this.runPss = 0.0;
            this.iso.setValue(1);
            this.mso.setValue(1);
            this.lso.setValue(0);
        }
        double trd = this.runSolRad / this.runSwRad;
        this.runPackPrecip = 0.0;
        this.runPackSWEtm1 = this.runPackSwe;
        this.pptMixNoSnow.setValue(false);
        this.runSnowMelt = 0.0;
        this.runSnowET = 0.0;
        if (this.entityType.getValue() == 2.0) {
            return;
        }
        if (julDay == this.meltForce.getValue()) {
            this.iso.setValue(2);
        }
        if (julDay == this.meltLook.getValue()) {
            this.mso.setValue(2);
        }
        if (this.runPackSWEtm1 < 1.0E-5 && !this.newSnow) {
            return;
        }
        if (this.newSnow && this.runPackSWEtm1 < 1.0E-5) {
            this.runSnowCovArea = 1.0;
        }
        if (this.runPackSWEtm1 > 0.0 && this.runRain > 0.0 || this.runSnow > 0.0) {
            this.ppt_to_pack();
        }
        if (this.runPackSwe > 0.0) {
            double cals;
            double dpt1;
            this.snowcov(0);
            this.snalbedo();
            double tminc = this.f_2_c(this.runTmin);
            double tmaxc = this.f_2_c(this.runTmax);
            double emis = this.emisNoPrecip.getValue();
            if (this.runPrecip > 0.0) {
                emis = 1.0;
            }
            double esv = emis;
            double swn = this.runSwRad * (1.0 - this.runPackAlbedo) * this.radTransCoef.getValue();
            double cec = this.cecnCoef[month] * this.cecnFactor.getValue() * 0.5;
            if (this.covType.getValue() == 3.0) {
                cec *= 0.5;
            }
            this.runPss += this.runSnow;
            this.runPackDepth = dpt1 = (this.runSnow * this.denInv + this.setDen * this.runPss + this.runPackDepth) * this.set1;
            this.runPackDensity = this.runPackSwe / dpt1;
            double effk = 0.0154 * this.runPackDensity;
            double cst = this.runPackDensity * Math.sqrt(effk * 13751.0);
            if (this.iso.getValue() == 1 && this.mso.getValue() == 2) {
                if (this.runPackTemp >= 0.0) {
                    this.lso.setValue(this.lso.getValue() + 1);
                    if (this.lso.getValue() > 4) {
                        this.iso.setValue(2);
                        this.lso.setValue(0);
                    }
                } else {
                    this.lso.setValue(0);
                }
            }
            int niteda = 1;
            double sw = 0.0;
            double temp = (tminc + this.runTavgC) * 0.5;
            this.runPackEnergyBal = cals = this.snowbal(esv, temp, niteda, this.tStorm[month], trd, cec, cst, sw);
            if (this.runPackSwe > 0.0) {
                niteda = 2;
                sw = swn;
                temp = (tmaxc + this.runTavgC) * 0.5;
                cals = this.snowbal(esv, temp, niteda, this.tStorm[month], trd, cec, cst, sw);
                this.runPackEnergyBal += cals;
            }
            if (this.runPackSwe > 0.0) {
                if (!this.runTranspOn || this.runTranspOn && this.covType.getValue() <= 1.0) {
                    this.snowevap();
                }
            } else {
                this.runSnowET = 0.0;
            }
            if (this.runPackSwe > 0.0) {
                this.runPackDepth = this.runPackSwe / this.runPackDensity;
                this.runPss = this.runPackSwe;
                if (this.lst.getValue()) {
                    this.runSnowSave -= this.runSnowMelt;
                    if (this.runSnowSave < 1.0E-5) {
                        this.runSnowSave = 0.0;
                    }
                }
            } else {
                this.runPackDepth = 0.0;
                this.runPss = 0.0;
                this.runSnowSave = 0.0;
                this.lst.setValue(false);
                this.runPst = 0.0;
                this.iasw.setValue(false);
                this.runPackAlbedo = 0.0;
                this.runPackDensity = 0.0;
                this.runSnowCovArea = 0.0;
                this.runPackDef = 0.0;
                this.runPackTemp = 0.0;
                this.runPackIce = 0.0;
                this.runPackFreeWater = 0.0;
                this.runPackEnergyBal = 0.0;
            }
        }
        this.mapVarsBack(balIn, balStorStart);
    }
}

