/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="PRMSProcessSnow", author="Peter Krause, and the guys form the USGS", description="Adaptation of the PRMS module for snow calculation")
public class PRMSProcessSnow
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity cover density in winter")
    public Attribute.Double covDensWin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity cover density in summer")
    public Attribute.Double covDensSum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="cover type of entity 0 = bareSoil, 1 = grass, 2 = shrubs, 3 = trees")
    public Attribute.Double covType;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="type of entity 1 = land, 2 = water")
    public Attribute.Double entityType;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="variable snowCrv [PRMS: Scrv]")
    public Attribute.Double snowCurve;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="variable snowCovAreaSave [PRMS: Snowcov_areasv]")
    public Attribute.Double snowCovAreaSave;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="variable albedoSave [PRMS: Salb]")
    public Attribute.Double packAlbedoSave;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="variable lstSave [PRMS: Slst]")
    public Attribute.Double lstSave;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="variable intAlbedo [PRMS: Int_alb]")
    public Attribute.Integer intAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow surface albedo [PRMS: Albedo]")
    public Attribute.Double packAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="precipitation added to snowpack [PRMS: Pk_precip]", unit="mm")
    public Attribute.Double packPrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="temperature of the snowpack [PRMS: Pk_temp]", unit="\u00b0C")
    public Attribute.Double packTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="density of the snowpack [PRMS: Pk_den]", unit="g/cm^3")
    public Attribute.Double packDensity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="net snowpack energy balance [PRMS: Tcal]")
    public Attribute.Double packEnergyBal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="evaporation and sublimation from snowpack [PRMS: Snow_evap]", unit="mm")
    public Attribute.Double snowET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="snowmelt from snowpack [PRMS: Snowmelt]", unit="mm")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snowpack water equivalent [PRMS: Pkwater_equiv]", unit="mm")
    public Attribute.Double snowWaterEquivalent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow-covered area (decimal percent) [PRMS: Snowcov_area]")
    public Attribute.Double snowCovArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="indicator that a rain-snow mix event has occured withno snowpack present [PRMS: Pptmix_nopack]")
    public Attribute.Boolean pptMixNoSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var iasw/flag [PRMS: Iasw]")
    public Attribute.Boolean iasw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var iso/flag [PRMS: Iso]")
    public Attribute.Integer iso;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var/flag mso [PRMS: Mso]")
    public Attribute.Integer mso;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var/flag lso [PRMS: Lso]")
    public Attribute.Integer lso;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var/flag lst [PRMS: Lst]")
    public Attribute.Boolean lst;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="heat deficit in the lower snowpack [PRMS: Pk_def]")
    public Attribute.Double packDef;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="frozen part of the pack's swe [PRMS: Pk_ice]")
    public Attribute.Double packIce;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="liquid part of the pack's swe [PRMS: freeh2o]")
    public Attribute.Double packFreeWater;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="depth of the snowpack [PRMS: Pk_depth]", unit="mm")
    public Attribute.Double packDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var pss [PRMS: Pss]")
    public Attribute.Double pss;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="var pst [PRMS: Pst]")
    public Attribute.Double pst;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="captures the old swe of the time step before [PRMS: Snsv]")
    public Attribute.Double packSWEtm1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="density of new snow [PRMS: Den_init]", unit="g/cm^3")
    public Attribute.Double initDens;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Snowpack settlement time constant [PRMS: Settle_const]")
    public Attribute.Double settleConst;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Average maximum snowpack density [PRMS: Den_max]", unit="g/cm^3")
    public Attribute.Double maxDens;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Julian date to start looking for spring snowmelt, Julian date to start looking for spring snowmelt stage. Varies with region depending on length of time that permanent snowpack exists [PRMS: Melt_look]", unit="julDay")
    public Attribute.Integer meltLook;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Julian date to force snowpack to spring snowmelt stage.Varies with region depending on length of time thatpermanent snowpack exists' [PRMS: Melt_force]", unit="julDay")
    public Attribute.Integer meltForce;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Transmission coefficient for short-wave radiation throughthe winter vegetation canopy in decimal percent [PRMS: Rad_trncf]")
    public Attribute.Double radTransCoef;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Maximum threshold water equivalent for snow depletion.The maximum threshold snowpack water equivalent belowwhich the snow-covered-area curve is applied. Varies with elevation (not here!). [PRMS: Snarea_thresh]")
    public Attribute.Double snowAreaThresh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Albedo reset - rain,  melt stage,Proportion of rain (decimal percent) in a rain-snow precipitation eventabove which the snow albedo is not reset. Applied duringthe snowpack melt stage [PRMS: Albset_rnm]")
    public Attribute.Double albedoResetRainMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Albedo reset - rain, accumulation stage,Proportion of rain (decimal percent) in a rain-snow precipitation eventabove which the snow albedo is not reset. Applied duringthe snowpack accumulation stage [PRMS: Albset_rna]")
    public Attribute.Double albedoResetRainAccu;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Albedo reset - snow, melt stage,Minimum snowfall, in water equivalent, needed to resetsnow albedo during the snowpack melt stage[PRMS: Albset_snm]", unit="mm")
    public Attribute.Double albedoResetSnowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Albedo reset - snow, accumulation stageMinimum snowfall, in water equivalent, needed to resetsnow albedo during the snowpack accumulation stage[PRMS: Albset_sna]", unit="mm")
    public Attribute.Double albedoResetSnowAccu;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Emissivity of air on days without precipitationAverage emissivity of air on days without precipitation[PRMS: Emis_noppt]")
    public Attribute.Double emisNoPrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Proportion (decimal percent) of potential ET that is sublimated from thesnow surface [PRMS: Potet_sublim]")
    public Attribute.Double petSublimProp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Free-water holding capacity (decimal percent) of snowpack expressed as decimal fraction of total snowpack water equivalent [PRMS: Freeh2o_cap]")
    public Attribute.Double packFreeWaterCapacity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Precip all snow if hru max temperature below this value.If HRU maximum temperature is less than or equal to thisvalue, precipitation is assumed to be snow [PRMS: Tmax_allsnow]", unit="\u00b0C")
    public Attribute.Double tmaxAllSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Multiplier for the cecn values [PRMS: n/a]")
    public Attribute.Double cecnFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="minum temperature", unit="\u00b0C")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="mean temperature", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="max temperature", unit="\u00b0C")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="observed or calculated solar radiation", unit="MJ")
    public Attribute.Double solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="observed or calculated shortwave radiation", unit="MJ")
    public Attribute.Double swRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="total precipitation (rain and snow)", unit="mm")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain amount of precipitation, will be changed during snow modelling", unit="mm")
    public Attribute.Double inRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow amount of precipitation, will be changed during snow modelling", unit="mm")
    public Attribute.Double inSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="save rain for output")
    public Attribute.Double svRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="save snow for output")
    public Attribute.Double svSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actual evapotranspiration so far", unit="mm")
    public Attribute.Double aET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="potential evapotranspiration", unit="mm")
    public Attribute.Double pET;
    double[] snowAreaCurve = new double[]{0.0, 0.01, 0.075, 0.12, 0.2, 0.28, 0.34, 0.45, 0.55, 0.7, 1.0};
    double[] cecnCoef = new double[]{8.51, 8.51, 8.95, 8.95, 8.95, 8.95, 8.95, 8.95, 8.95, 8.95, 8.51, 8.51};
    int[] tStorm = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    double[] aCum = new double[]{0.8, 0.77, 0.75, 0.72, 0.7, 0.69, 0.68, 0.67, 0.66, 0.65, 0.64, 0.63, 0.62, 0.61, 0.6};
    double[] aMlt = new double[]{0.72, 0.65, 0.6, 0.58, 0.56, 0.54, 0.52, 0.5, 0.48, 0.46, 0.44, 0.43, 0.42, 0.41, 0.4};
    int MAXALB = this.aMlt.length - 1;
    double runSwRad = 0.0;
    double denInv;
    double setDen;
    double set1;
    boolean pptMix = false;
    boolean newSnow = false;
    double rainPart = 0.0;
    double runPackSwe;
    double runPackPrecip;
    double runRain;
    double runSnow;
    double runPackDef;
    double runPackTemp;
    double runPackIce;
    double runPackFreeWater;
    double runSnowCovArea;
    double runSnowMelt;
    double runPackDensity;
    double runPackDepth;
    double runSnowCovAreaSave;
    double runPst;
    double runPackSWEtm1;
    double runSnowCurve;
    double runLstSave;
    double runPackAlbedoSave;
    double runPss;
    double runTmin;
    double runTmean;
    double runTmax;
    double runPackEnergyBal;
    double runAet;
    double runPet;
    double runSolRad;
    boolean runLst;
    boolean runTranspOn;

    public void init() {
        this.aET.setValue(0.0);
        this.snowCurve.setValue(0.0);
        this.snowCovAreaSave.setValue(0.0);
        this.packAlbedoSave.setValue(0.0);
        this.lstSave.setValue(0.0);
        this.packTemp.setValue(0.0);
        this.packDensity.setValue(0.0);
        this.packEnergyBal.setValue(0.0);
        this.snowMelt.setValue(0.0);
        this.snowWaterEquivalent.setValue(0.0);
        this.snowCovArea.setValue(0.0);
        this.lst.setValue(false);
        this.packDef.setValue(0.0);
        this.packIce.setValue(0.0);
        this.packFreeWater.setValue(0.0);
        this.packDepth.setValue(0.0);
        this.pss.setValue(0.0);
        this.pst.setValue(0.0);
        this.packSWEtm1.setValue(0.0);
        this.packPrecip.setValue(0.0);
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        this.denInv = 1.0 / this.initDens.getValue();
        this.setDen = this.settleConst.getValue() / this.maxDens.getValue();
        this.set1 = 1.0 / (1.0 + this.settleConst.getValue());
        this.runSwRad = this.swRad.getValue() * 238800.0;
        this.runSolRad = this.solRad.getValue() * 238800.0;
        this.pptMix = this.inRain.getValue() > 0.0 && this.inSnow.getValue() > 0.0;
        this.newSnow = this.inSnow.getValue() > 0.0;
        this.rainPart = this.precip.getValue() > 0.0 ? this.inRain.getValue() / this.precip.getValue() : 0.0;
        this.runPackSwe = this.snowWaterEquivalent.getValue() / this.area.getValue();
        this.runPackPrecip = 0.0;
        this.runRain = this.inRain.getValue() / this.area.getValue();
        this.runSnow = this.inSnow.getValue() / this.area.getValue();
        this.runAet = this.aET.getValue() / this.area.getValue();
        this.runPet = this.pET.getValue() / this.area.getValue();
        this.runPackSWEtm1 = this.packSWEtm1.getValue() / this.area.getValue();
        this.runPackDef = this.packDef.getValue();
        this.runPackTemp = this.packTemp.getValue();
        this.runPackIce = this.packIce.getValue();
        this.runPackFreeWater = this.packFreeWater.getValue();
        this.runSnowCovArea = this.snowCovArea.getValue();
        this.runSnowCovAreaSave = this.snowCovAreaSave.getValue();
        this.runSnowMelt = 0.0;
        this.runPackDensity = this.packDensity.getValue();
        this.runPackDepth = this.packDepth.getValue();
        this.runPst = this.pst.getValue();
        this.runSnowCurve = this.snowCurve.getValue();
        this.runPackAlbedoSave = this.packAlbedoSave.getValue();
        this.runLst = this.lst.getValue();
        this.runLstSave = this.lstSave.getValue();
        this.runPss = this.pss.getValue();
        this.runTmin = this.tmin.getValue();
        this.runTmean = this.tmean.getValue();
        this.runTmax = this.tmax.getValue();
        this.runPackEnergyBal = this.packEnergyBal.getValue();
        double balIn = this.inSnow.getValue() + this.inRain.getValue();
        double balStorStart = this.snowWaterEquivalent.getValue();
        int julDay = this.time.get(6);
        int month = this.time.get(2);
        this.runTranspOn = julDay > 85 && julDay < 305;
        if (julDay == 305) {
            this.runPss = 0.0;
            this.iso.setValue(1);
            this.mso.setValue(1);
            this.lso.setValue(0);
        }
        double trd = this.runSolRad / this.runSwRad;
        double prev_swe = this.runPackSwe;
        this.pptMixNoSnow.setValue(false);
        this.snowET.setValue(0.0);
        if (julDay == this.meltForce.getValue()) {
            this.iso.setValue(2);
        }
        if (julDay == this.meltLook.getValue()) {
            this.mso.setValue(2);
        }
        if (prev_swe == 0.0 && !this.newSnow) {
            this.mapVarsBack(balIn, balStorStart);
            return;
        }
        if (this.newSnow && prev_swe == 0.0) {
            this.runSnowCovArea = 1.0;
        }
        if (prev_swe > 0.0 && this.precip.getValue() > 0.0 || this.inSnow.getValue() > 0.0) {
            this.snowAccumulation();
        }
        if (this.runPackSwe > 0.0) {
            double calories;
            double dpt1;
            this.calcSnowCoveredArea();
            this.calcSnowAlbedo();
            double emis = this.emisNoPrecip.getValue();
            if (this.precip.getValue() > 0.0) {
                emis = 1.0;
            }
            double esv = emis;
            double swn = this.runSwRad * (1.0 - this.packAlbedo.getValue()) * this.radTransCoef.getValue();
            double cec = this.cecnCoef[month] * this.cecnFactor.getValue() * 0.5;
            if (this.covType.getValue() == 3.0) {
                cec *= 0.5;
            }
            this.runPss += this.runSnow;
            this.runPackDepth = dpt1 = (this.runSnow * this.denInv + this.setDen * this.runPss + this.runPackDepth) * this.set1;
            this.runPackDensity = this.runPackSwe / dpt1;
            double effk = 0.0154 * this.runPackDensity;
            double cst = this.runPackDensity * Math.sqrt(effk * 13751.0 * 2.0);
            if (this.iso.getValue() == 1 && this.mso.getValue() == 2) {
                if (this.runPackTemp >= 0.0) {
                    this.lso.setValue(this.lso.getValue() + 1);
                    if (this.lso.getValue() > 4) {
                        this.iso.setValue(2);
                        this.lso.setValue(0);
                    }
                } else {
                    this.lso.setValue(0);
                }
            }
            double niteda = 1.0;
            double sw = 0.0;
            double temp = (this.runTmin + this.runTmean) / 2.0;
            this.runPackEnergyBal = calories = this.calcSnowBalance(niteda, temp, esv, trd, cec, cst, sw, month);
            if (this.runPackSwe > 0.0) {
                niteda = 2.0;
                sw = swn;
                temp = (this.runTmax + this.runTmean) / 2.0;
                calories = this.calcSnowBalance(niteda, temp, esv, trd, cec, cst, sw, month);
                this.runPackEnergyBal += calories;
            }
            if (this.runPackSwe > 0.0) {
                if (!this.runTranspOn || this.runTranspOn && this.covType.getValue() <= 1.0) {
                    this.calcSnowEvaporation();
                }
            } else {
                this.snowET.setValue(0.0);
            }
            if (this.runPackSwe > 0.0) {
                this.runPackDepth = this.runPackSwe / this.runPackDensity;
                this.runPss = this.runPackSwe;
                if (this.runLst) {
                    this.runPackSWEtm1 -= this.runSnowMelt;
                    if (this.runPackSWEtm1 < 0.0) {
                        this.runPackSWEtm1 = 0.0;
                    }
                }
            } else {
                this.runPackDepth = 0.0;
                this.runPss = 0.0;
                this.runPackSWEtm1 = 0.0;
                this.runLst = false;
                this.runPst = 0.0;
                this.iasw.setValue(false);
                this.packAlbedo.setValue(0.0);
                this.runPackDensity = 0.0;
                this.runSnowCovArea = 0.0;
                this.runPackDef = 0.0;
                this.runPackIce = 0.0;
                this.runPackFreeWater = 0.0;
                this.runPackTemp = 0.0;
                this.runPackEnergyBal = 0.0;
            }
        }
        this.mapVarsBack(balIn, balStorStart);
    }

    private void mapVarsBack(double balIn, double balStorStart) {
        this.runAet += this.snowET.getValue();
        this.aET.setValue(this.runAet * this.area.getValue());
        this.snowCurve.setValue(this.runSnowCurve);
        this.snowCovAreaSave.setValue(this.runSnowCovAreaSave);
        this.packAlbedoSave.setValue(this.runPackAlbedoSave);
        this.lstSave.setValue(this.runLstSave);
        this.packTemp.setValue(this.runPackTemp);
        this.packDensity.setValue(this.runPackDensity);
        this.packEnergyBal.setValue(this.runPackEnergyBal);
        this.snowMelt.setValue(this.runSnowMelt * this.area.getValue());
        this.snowWaterEquivalent.setValue(this.runPackSwe * this.area.getValue());
        this.snowCovArea.setValue(this.runSnowCovArea);
        this.lst.setValue(this.runLst);
        this.packDef.setValue(this.runPackDef);
        this.packIce.setValue(this.runPackIce);
        this.packFreeWater.setValue(this.runPackFreeWater);
        this.packDepth.setValue(this.runPackDepth);
        this.pss.setValue(this.runPss);
        this.pst.setValue(this.runPst);
        this.packSWEtm1.setValue(this.runPackSWEtm1 * this.area.getValue());
        this.packPrecip.setValue(this.runPackPrecip * this.area.getValue());
        this.inRain.setValue(this.runRain * this.area.getValue());
        this.inSnow.setValue(0.0);
        double balStorEnd = this.snowWaterEquivalent.getValue();
        double balOut = this.snowMelt.getValue() + this.inRain.getValue() + this.inSnow.getValue() + this.aET.getValue();
        double balance = balIn + (balStorStart - balStorEnd) - balOut;
        if (Math.abs(balance) > 1.0E-4) {
            this.getModel().getRuntime().println(this.time.toString() + " balance error in snow module: " + balance);
            this.getModel().getRuntime().println("balIn: " + balIn);
            this.getModel().getRuntime().println("balStorStart: " + balStorStart);
            this.getModel().getRuntime().println("balStorEnd: " + balStorEnd);
            this.getModel().getRuntime().println("balOut: " + balOut);
            this.getModel().getRuntime().println("shit!");
        }
    }

    private void snowAccumulation() {
        double tsnow;
        double train;
        this.runPackPrecip = 0.0;
        if (this.pptMix) {
            train = (this.runTmax + this.tmaxAllSnow.getValue()) / 2.0;
            tsnow = this.runPackSwe > 0.0 ? (this.runTmin + this.tmaxAllSnow.getValue()) / 2.0 : this.runTmean;
        } else {
            train = this.runTmean;
            if (train < 0.0) {
                train = (this.runTmax + this.tmaxAllSnow.getValue()) / 2.0;
            }
            tsnow = this.runTmean;
        }
        if (train < 0.0) {
            train = 0.0;
        }
        if (tsnow > 0.0) {
            tsnow = 0.0;
        }
        if (this.runPackSwe > 0.0) {
            if (this.runRain > 0.0) {
                this.runPackSwe += this.runRain;
                this.runPackPrecip += this.runRain;
                if (this.runPackDef > 0.0) {
                    double caln = 1000.0 * train;
                    double pndz = this.runPackDef / caln;
                    if (Math.abs(this.runRain - pndz) < 0.0) {
                        this.runPackDef = 0.0;
                        this.runPackTemp = 0.0;
                        this.runPackIce += this.runRain;
                    } else if (this.runRain < pndz) {
                        this.runPackDef -= caln * this.runRain;
                        this.runPackTemp = -1.0 * this.runPackDef / (this.runPackSwe * 500.0);
                        this.runPackIce += this.runRain;
                    } else {
                        this.runPackDef = 0.0;
                        this.runPackTemp = 0.0;
                        this.runPackIce += pndz;
                        this.runPackFreeWater = this.runRain - pndz;
                        double calpr = train * (this.runRain - pndz) * 1000.0;
                        this.energyGained(calpr);
                    }
                } else {
                    this.runPackFreeWater += this.runRain;
                    double calpr = train * this.runRain * 1000.0;
                    this.energyGained(calpr);
                }
            }
            this.runRain = 0.0;
        } else if (this.runRain > 0.0) {
            this.pptMixNoSnow.setValue(true);
        }
        if (this.runSnow > 0.0) {
            this.runPackSwe += this.runSnow;
            this.runPackPrecip += this.runSnow;
            this.runPackIce += this.runSnow;
            if (tsnow >= 0.0) {
                this.runPackTemp = -1.0 * this.runPackDef / (this.runPackSwe * 500.0);
            } else {
                double calps = tsnow * this.runSnow * 500.0;
                if (this.runPackFreeWater > 0.0) {
                    this.energyLost(calps);
                } else {
                    this.runPackDef -= calps;
                    this.runPackTemp = -1.0 * this.runPackDef / (this.runPackSwe * 500.0);
                }
            }
        }
    }

    private void energyGained(double calories) {
        double dif = calories - this.runPackDef;
        if (dif < 0.0) {
            this.runPackDef -= calories;
            this.runPackTemp = -1.0 * this.runPackDef / (this.runPackSwe * 500.0);
        } else if (dif == 0.0) {
            this.runPackTemp = 0.0;
            this.runPackDef = 0.0;
        } else {
            double pmlt = dif / 80000.0;
            double apmlt = pmlt * this.runSnowCovArea;
            this.runPackDef = 0.0;
            this.runPackTemp = 0.0;
            double apk_ice = this.runPackIce / this.runSnowCovArea;
            if (pmlt > apk_ice) {
                this.runSnowMelt += this.runPackSwe;
                this.runPackSwe = 0.0;
                this.iasw.setValue(false);
                this.runSnowCovArea = 0.0;
                this.runPackDef = 0.0;
                this.runPackTemp = 0.0;
                this.runPackIce = 0.0;
                this.runPackFreeWater = 0.0;
                this.runPackDepth = 0.0;
                this.runPss = 0.0;
                this.runPst = 0.0;
                this.runPackDensity = 0.0;
                this.runPackEnergyBal = 0.0;
            } else {
                this.runPackIce -= apmlt;
                this.runPackFreeWater += apmlt;
                double pwcap = this.packFreeWaterCapacity.getValue() * this.runPackSwe;
                double wDif = this.runPackFreeWater - pwcap;
                if (wDif > 0.0) {
                    this.runSnowMelt += wDif;
                    this.runPackFreeWater = pwcap;
                    this.runPackSwe -= wDif;
                    this.runPackDepth = this.runPackSwe / this.runPackDensity;
                    this.runPss = this.runPackSwe;
                }
            }
        }
    }

    private void energyLost(double calories) {
        if (this.runPackFreeWater == 0.0) {
            this.runPackDef -= calories;
        } else {
            double calnd = this.runPackFreeWater * 80000.0;
            double dif = calories + calnd;
            if (dif < 0.0) {
                this.runPackDef -= dif;
                this.runPackIce += this.runPackFreeWater;
                this.runPackFreeWater = 0.0;
            } else {
                this.runPackIce += -1.0 * calories / 80000.0;
                this.runPackFreeWater -= -1.0 * calories / 80000.0;
                return;
            }
        }
        if (this.runPackSwe > 0.0) {
            this.runPackTemp = -1.0 * this.runPackDef / (this.runPackSwe * 500.0);
        }
    }

    private void calcSnowCoveredArea() {
        double ai;
        this.runSnowCovArea = this.snowAreaCurve[10];
        if (this.runPackSwe > this.runPst) {
            this.runPst = this.runPackSwe;
        }
        if ((ai = this.runPst) >= this.snowAreaThresh.getValue()) {
            ai = this.snowAreaThresh.getValue();
        }
        if (this.runPackSwe > ai) {
            this.iasw.setValue(false);
        } else {
            if (!this.newSnow) {
                if (this.iasw.getValue()) {
                    if (this.runPackSwe > this.runSnowCurve) {
                        return;
                    }
                    if (this.runPackSwe >= this.runPackSWEtm1) {
                        double difx = this.runSnowCovArea - this.runSnowCovAreaSave;
                        double dify = this.runSnowCurve - this.runPackSWEtm1;
                        double pcty = 0.0;
                        if (dify > 1.0E-7) {
                            pcty = (this.runPackSwe - this.runPackSWEtm1) / dify;
                        }
                        this.runSnowCovArea = this.runSnowCovAreaSave + pcty * difx;
                        return;
                    }
                    this.iasw.setValue(false);
                }
            } else {
                if (this.iasw.getValue()) {
                    this.runSnowCurve = this.runPackSwe - 0.25 * this.runSnow;
                } else {
                    this.iasw.setValue(true);
                    this.runSnowCovAreaSave = this.runSnowCovArea;
                    this.runPackSWEtm1 = this.runPackSwe - this.runSnow;
                    this.runSnowCurve = this.runPackSwe - 0.25 * this.runSnow;
                }
                return;
            }
            double frac = this.runPackSwe / ai;
            int idx = (int)(10.0 * (frac + 0.2)) - 1;
            int jdx = idx - 1;
            double af = jdx - 1;
            double dify = frac * 10.0 - af;
            double difx = this.snowAreaCurve[idx] - this.snowAreaCurve[jdx];
            this.runSnowCovArea = this.snowAreaCurve[jdx] + difx * dify;
        }
    }

    private void calcSnowAlbedo() {
        if (!this.newSnow) {
            if (this.runLst) {
                this.runLstSave = this.runPackAlbedoSave - 3.0;
                if (this.runLstSave < 1.0) {
                    this.runLstSave = 1.0;
                }
                if (this.iso.getValue() != 2 && this.runLstSave > 5.0) {
                    this.runLstSave = 5.0;
                }
                this.runLst = false;
                this.runPackSWEtm1 = 0.0;
            }
        } else if (this.mso.getValue() == 2) {
            if (this.rainPart < this.albedoResetRainMelt.getValue()) {
                if (this.runSnow > this.albedoResetSnowMelt.getValue()) {
                    this.runLstSave = 0.0;
                    this.runLst = false;
                    this.runPackSWEtm1 = 0.0;
                } else {
                    this.runPackSWEtm1 += this.runSnow;
                    if (this.runPackSWEtm1 > this.albedoResetSnowMelt.getValue()) {
                        this.runLstSave = 0.0;
                        this.runLst = false;
                        this.runPackSWEtm1 = 0.0;
                    } else {
                        if (!this.runLst) {
                            this.runPackAlbedoSave = this.runLstSave;
                        }
                        this.runLstSave = 0.0;
                        this.runLst = true;
                    }
                }
            }
        } else {
            if (!this.pptMix) {
                this.runLstSave = 0.0;
                this.runLst = false;
            } else if (this.rainPart - this.albedoResetRainAccu.getValue() > 0.0) {
                this.runLst = false;
            } else if (this.runSnow - this.albedoResetSnowAccu.getValue() > 0.0) {
                this.runLstSave = 0.0;
                this.runLst = false;
            } else {
                this.runLstSave -= 3.0;
                if (this.runLstSave < 0.0) {
                    this.runLstSave = 0.0;
                }
                if (this.runLstSave > 5.0) {
                    this.runLstSave = 5.0;
                }
                this.runLst = false;
            }
            this.runPackSWEtm1 = 0.0;
        }
        int i = (int)(this.runLstSave + 0.5);
        this.runLstSave += 1.0;
        if (i > 0) {
            if (this.intAlbedo.getValue() != 2) {
                if (i <= this.MAXALB) {
                    this.packAlbedo.setValue(this.aCum[i]);
                } else {
                    if ((i -= 12) > this.MAXALB) {
                        i = this.MAXALB;
                    }
                    this.packAlbedo.setValue(this.aMlt[i]);
                }
            } else {
                if (i > this.MAXALB) {
                    i = this.MAXALB;
                }
                this.packAlbedo.setValue(this.aMlt[i]);
            }
        } else if (this.mso.getValue() == 2) {
            this.packAlbedo.setValue(0.81);
            this.intAlbedo.setValue(2);
        } else {
            this.packAlbedo.setValue(0.91);
            this.intAlbedo.setValue(1);
        }
    }

    private double calcSnowBalance(double niteda, double temp, double esv, double trd, double cec, double cst, double sw, int month) {
        double sno;
        double ts;
        double air = 5.85E-8 * Math.pow(temp + 273.16, 4.0);
        double emis = esv;
        if (temp < 0.0) {
            ts = temp;
            sno = air;
        } else {
            ts = 0.0;
            sno = 325.7;
        }
        if (this.precip.getValue() > 0.0 && this.tStorm[month] == 1) {
            if (niteda == 1.0) {
                emis = 0.85;
                if (trd > 0.33) {
                    emis = this.emisNoPrecip.getValue();
                }
            } else {
                if (trd > 0.33) {
                    emis = 1.29 - 0.882 * trd;
                }
                if (trd >= 0.5) {
                    emis = 0.95 - 0.2 * trd;
                }
            }
        }
        double sky = (1.0 - this.covDensWin.getValue()) * (emis * air - sno);
        double can = this.covDensWin.getValue() * (air - sno);
        double cecsub = 0.0;
        if (temp > 0.0 && this.precip.getValue() > 0.0) {
            cecsub = cec * temp;
        }
        double calories = sky + can + cecsub + sw;
        if (ts >= 0.0 && calories > 0.0) {
            this.energyGained(calories);
            return calories;
        }
        double qcond = cst * (ts - this.runPackTemp);
        if (qcond < 0.0) {
            if (this.runPackTemp < 0.0) {
                this.runPackDef -= qcond;
                this.runPackTemp = -1.0 * this.runPackDef / (this.runPackSwe * 500.0);
            } else {
                this.energyLost(qcond);
            }
        } else if (qcond <= 0.0) {
            if (this.runPackTemp >= 0.0 && calories > 0.0) {
                this.energyGained(calories);
            }
        } else if (ts >= 0.0) {
            double pk_defsub = this.runPackDef - qcond;
            if (pk_defsub < 0.0) {
                this.runPackDef = 0.0;
                this.runPackTemp = 0.0;
            } else {
                this.runPackDef = pk_defsub;
                this.runPackTemp = -1.0 * pk_defsub / (this.runPackSwe * 500.0);
            }
        } else {
            double pkt = -1.0 * ts * this.runPackSwe * 500.0;
            double pks = this.runPackDef - pkt;
            double pk_defsub = pks - qcond;
            if (pk_defsub < 0.0) {
                this.runPackDef = pkt;
                this.runPackTemp = ts;
            } else {
                this.runPackDef = pk_defsub + pkt;
                this.runPackTemp = -1.0 * this.runPackDef / (this.runPackSwe * 500.0);
            }
        }
        return calories;
    }

    private void calcSnowEvaporation() {
        double ez = 0.0;
        if (this.covType.getValue() > 1.0) {
            double cov = this.covDensWin.getValue();
            if (this.runTranspOn) {
                cov = this.covDensSum.getValue();
            }
            ez = this.petSublimProp.getValue() * this.runPet * this.runSnowCovArea - this.runAet * cov;
        } else {
            ez = this.petSublimProp.getValue() * this.runPet * this.runSnowCovArea;
        }
        if (ez < 0.0) {
            this.snowET.setValue(0.0);
        } else if (ez >= this.runPackSwe) {
            this.snowET.setValue(this.runPackSwe);
            this.runPackSwe = 0.0;
            this.runPackIce = 0.0;
            this.runPackDef = 0.0;
            this.runPackFreeWater = 0.0;
            this.runPackTemp = 0.0;
            this.runPackEnergyBal = 0.0;
        } else {
            this.runPackIce -= ez;
            double cal = this.runPackTemp * ez * 680000.0;
            this.runPackDef += cal;
            this.runPackSwe -= ez;
            this.snowET.setValue(ez);
        }
    }

    public void cleanup() {
    }
}

