/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;

@JAMSComponentDescription(title="StandardLUReader", author="Sven Kralisch", description="This component reads an ASCII file containing any kind of information and adds it to model entities.", date="2022-02-13", version="1.1_0")
public class UniversalParameterReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Land use parameter file name")
    public Attribute.String parameterFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hru objects")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute containing the entity identifiers", defaultValue="ID")
    public Attribute.String entityIDAttribute;

    public void init() {
        Attribute.EntityCollection params = this.getModel().getRuntime().getDataFactory().createEntityCollection();
        params.setEntities(J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.parameterFileName.getValue()), this.getModel()));
        HashMap<Double, Attribute.Entity> paramMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity param : params.getEntities()) {
            paramMap.put(param.getDouble(this.entityIDAttribute.getValue()), param);
        }
        for (Attribute.Entity e : this.entities.getEntities()) {
            Attribute.Entity param;
            param = (Attribute.Entity)paramMap.get(e.getDouble(this.entityIDAttribute.getValue()));
            if (param == null) {
                this.getModel().getRuntime().sendHalt("No data found for entity " + e.getId() + "!");
                return;
            }
            Object[] attrs = param.getKeys();
            for (int i = 0; i < attrs.length; ++i) {
                e.setDouble((String)attrs[i], param.getDouble((String)attrs[i]));
            }
        }
        this.getModel().getRuntime().println("parameter file processed ...", 2);
    }
}

