/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Calculate logarithmic wind profile", author="Annika K\u00fcnne", description="Approximation of wind speed at 2m above ground using the e logarithmic wind profile at HRU level", date="2024-04-09", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class LogarithmicWindProfile
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="wind speed in 10m height above ground", unit="m/s")
    public Attribute.Double v10;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="roughness length", unit="m")
    public Attribute.Double z0;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="wind speed in 2m height above ground", unit="m/s")
    public Attribute.Double v2;

    public void init() {
    }

    private double calculateWindSpeedAt2m(double v10, double z0, double d) {
        double v2_ = v10 * Math.log((2.0 - d) / z0) / Math.log((10.0 - d) / z0);
        return v2_;
    }

    public void run() {
        double v10_ = this.v10.getValue();
        double z0_ = this.z0.getValue();
        double v2_ = this.calculateWindSpeedAt2m(v10_, z0_, 0.0);
        this.v2.setValue(v2_);
    }

    public void cleanup() {
    }
}

