/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcLanduseStateVars", author="Peter Krause", description="Calculates landuse state variables for each entity")
public class CalcLanduseStateVarsHaude
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current hru entity")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU statevar LAI values (366)")
    public Attribute.DoubleArray LAIArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Monthly stomata resistance values")
    public Attribute.DoubleArray etMonthFactorArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute name elevation")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="flag indicating that Haude ET is used")
    public Attribute.Boolean haudeET;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};
    int oldmonth = 0;
    double rsc0 = 0.0;

    public void init() {
    }

    public void run() {
        int julDay;
        int j;
        Attribute.Entity entity = this.entities.getCurrent();
        double[] lai_vals = null;
        if (this.tempRes == null || this.tempRes.getValue().equals("d") || this.tempRes.getValue().equals("h")) {
            lai_vals = new double[366];
        } else if (this.tempRes.getValue().equals("m")) {
            lai_vals = new double[12];
        }
        double HRUelevation = this.elevation.getValue();
        double[] lais = new double[4];
        String laiName = "LAI_d";
        for (int i = 0; i < 4; ++i) {
            int count = i + 1;
            String loopName = laiName + count;
            lais[i] = entity.getDouble(loopName);
        }
        if (this.tempRes == null || this.tempRes.getValue().equals("d") || this.tempRes.getValue().equals("h")) {
            for (j = 0; j < 366; ++j) {
                julDay = j + 1;
                lai_vals[j] = this.calcLAI(lais, HRUelevation, julDay);
            }
        } else if (this.tempRes.getValue().equals("m")) {
            for (j = 0; j < 12; ++j) {
                julDay = this.monthMean[j];
                lai_vals[j] = this.calcLAI(lais, HRUelevation, julDay);
            }
        }
        this.LAIArray.setValue(lai_vals);
        double[] emf = new double[12];
        String emfName = this.haudeET != null && this.haudeET.getValue() ? "hf" : "RSC0_";
        for (int i = 0; i < 12; ++i) {
            int count = i + 1;
            String loopName = emfName + count;
            emf[i] = entity.getDouble(loopName);
        }
        this.etMonthFactorArray.setValue(emf);
    }

    public void cleanup() {
    }

    private double calcLAI(double[] lais, double targetElevation, int julDay) {
        int dTime = 0;
        double Lait1 = 0.0;
        double dLai = 0.0;
        int d1_400 = 110;
        int d2_400 = 150;
        int d3_400 = 250;
        int d4_400 = 280;
        int d1 = (int)((double)d1_400 + 0.025 * (targetElevation - 400.0));
        int d2 = (int)((double)d2_400 + 0.025 * (targetElevation - 400.0));
        int d3 = (int)((double)d3_400 - 0.025 * (targetElevation - 400.0));
        int d4 = (int)((double)d4_400 - 0.025 * (targetElevation - 400.0));
        double LAI = 0.0;
        if (julDay <= d1) {
            LAI = lais[0];
        } else if (julDay > d1 && julDay <= d2) {
            double LAI_1 = lais[0];
            double LAI_2 = lais[1];
            dTime = d2 - d1;
            dLai = LAI_2 - LAI_1;
            Lait1 = dLai / (double)dTime;
            LAI = Lait1 * (double)(julDay - d1) + LAI_1;
        } else if (julDay > d2 && julDay <= d3) {
            double LAI_2 = lais[1];
            double LAI_3 = lais[2];
            dTime = d3 - d2;
            dLai = LAI_3 - LAI_2;
            Lait1 = dLai / (double)dTime;
            LAI = Lait1 * (double)(julDay - d2) + LAI_2;
        } else if (julDay > d3 && julDay <= d4) {
            double LAI_3 = lais[2];
            double LAI_4 = lais[3];
            dTime = d4 - d3;
            dLai = LAI_4 - LAI_3;
            Lait1 = dLai / (double)dTime;
            LAI = Lait1 * (double)(julDay - d3) + LAI_3;
        } else if (julDay > d4) {
            double LAI_4;
            LAI = LAI_4 = lais[3];
        }
        return LAI;
    }
}

