/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.groundwater;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KGroundwater", author="Peter Krause", description="Initialises the J2KGroundwater module by multiplying the maximum storage capacity of the two groundwater storages RG1 and RG2by the area of the respective modelling unit to provide them withabsolute storage capacity values in litres. Secondly the actualcontent of the two storages can be set to a relative amount.", version="1.0_0", date="2010-10-29")
public class InitJ2KProcessGroundwater
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The collection of model entities")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="maximum RG1 storage", lowerBound=0.0, unit="L")
    public Attribute.Double maxRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="maximum RG2 storage", lowerBound=0.0, unit="L")
    public Attribute.Double maxRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actual RG1 storage", lowerBound=0.0, unit="L")
    public Attribute.Double actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actual RG2 storage", lowerBound=0.0, unit="L")
    public Attribute.Double actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="relative initial RG1 storage", lowerBound=0.0, upperBound=1.0, unit="n/a", defaultValue="0.0")
    public Attribute.Double initRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="relative initial RG2 storage", lowerBound=0.0, upperBound=1.0, unit="n/a", defaultValue="0.0")
    public Attribute.Double initRG2;

    public void init() {
    }

    public void run() {
        Attribute.Entity entity = this.entities.getCurrent();
        double area = entity.getDouble("area");
        this.maxRG1.setValue(entity.getDouble("RG1_max") * area);
        this.maxRG2.setValue(entity.getDouble("RG2_max") * area);
        this.actRG1.setValue(this.maxRG1.getValue() * this.initRG1.getValue());
        this.actRG2.setValue(this.maxRG2.getValue() * this.initRG2.getValue());
    }

    public void cleanup() {
    }
}

