/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.geographicalCalculations;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import org.unijena.j2k.geographicalCalculations.CalcSlopeAspectCorrectionFactor;
import org.unijena.j2k.geographicalCalculations.GKConversion;
import org.unijena.j2k.geographicalCalculations.UTMConversion;

@JAMSComponentDescription(title="CalcLatLong", author="Peter Krause", description="Handling of geographical coordination system and conversioninto lat-long values. The module can handle UTM or Gauss-Krueger coordinates. Additionally, a slope-aspect correction factor for a standard year is calculated which considers the specific slope-aspectcombination of a spatial modelling unit and the implication for e.g.incoming radiation.", version="1.0_0", date="2011-05-30")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2011-05-30", comment="Initial version"), @VersionComments.Entry(version="1.0_1", date="2016-05-13", comment="Added default values for projection and tempRes")})
public class CalcLatLong
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity x-coordinate")
    public Attribute.Double x;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity y-coordinate")
    public Attribute.Double y;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity slope", unit="degree", lowerBound=0.0, upperBound=90.0)
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity aspect", unit="degree from north", lowerBound=0.0, upperBound=360.0)
    public Attribute.Double aspect;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="entity latitute", unit="degree", lowerBound=0.0, upperBound=90.0)
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="entity longitude", unit="degree", lowerBound=0.0, upperBound=180.0)
    public Attribute.Double longitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="entity slopeAspectCorrectionFactor", unit="n/a", lowerBound=0.0, upperBound=1000.0)
    public Attribute.DoubleArray slAsCfArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Projection [GK, UTMZZL, LL]", defaultValue="GK")
    public Attribute.String projection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]", defaultValue="d")
    public Attribute.String tempRes;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};

    public void init() {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double[] latLong = new double[2];
        String proj = this.projection.toString() == null ? "GK" : this.projection.toString();
        if (proj.equals("GK")) {
            latLong = GKConversion.GK2LatLon(this.x.getValue(), this.y.getValue());
            this.latitude.setValue(latLong[0]);
            this.longitude.setValue(latLong[1]);
        } else if (!proj.equals("LL") && proj.substring(0, 3).equals("UTM")) {
            int len = proj.length();
            String zoneStr = proj.substring(3, len);
            latLong = UTMConversion.utm2LatLong(this.x.getValue(), this.y.getValue(), zoneStr);
            this.latitude.setValue(latLong[0]);
            this.longitude.setValue(latLong[1]);
        }
        double[] sloAspCorr = null;
        if (this.tempRes == null || this.tempRes.getValue().equals("d") || this.tempRes.getValue().equals("h")) {
            sloAspCorr = new double[366];
            for (int i = 0; i < 366; ++i) {
                int julDay = i + 1;
                sloAspCorr[i] = CalcSlopeAspectCorrectionFactor.calc_slopeAspectCorrectionFactor(julDay, this.latitude.getValue(), this.slope.getValue(), this.aspect.getValue());
            }
        } else if (this.tempRes.getValue().equals("m")) {
            sloAspCorr = new double[12];
            for (int i = 0; i < 12; ++i) {
                int julDay = this.monthMean[i];
                sloAspCorr[i] = CalcSlopeAspectCorrectionFactor.calc_slopeAspectCorrectionFactor(julDay, this.latitude.getValue(), this.slope.getValue(), this.aspect.getValue());
            }
        }
        this.slAsCfArray.setValue(sloAspCorr);
    }

    public void cleanup() {
    }
}

