/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcAreaWeight", author="Peter Krause", description="Calculates a relative area weight as a fraction between the spatial entitie's area and the sum of the area of all spatialentities (i.e. the area of the catchment)", version="1.0_0", date="2011-05-30")
public class CalcAreaWeight
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the area of the single entity", unit="m^2")
    public Attribute.Double entityArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the area of the catchment", unit="m^2")
    public Attribute.Double catchmentArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the relative area weight of the entity", unit="n/a")
    public Attribute.Double areaWeight;

    public void run() {
        this.areaWeight.setValue(this.catchmentArea.getValue() / this.entityArea.getValue());
    }
}

