/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.topology;

import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.List;
import org.unijena.j2k.topology.ReachSubbasin;

@JAMSComponentDescription(title="ReachUpstream", author="Sven Kralisch", description="Retrieve the (full, upstream) subbasin of a given reach", date="2022-05-19", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class ReachUpstream
extends ReachSubbasin {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of reach downstream linkage", defaultValue="to_reach")
    public Attribute.String reach2reachAttributeName;

    @Override
    public void init() {
        super.init();
        for (Attribute.Entity reach : this.reaches.getEntities()) {
            reach.setObject("__upstreamHRUs", new ArrayList());
        }
        for (Attribute.Entity reach : this.reaches.getEntities()) {
            List upstreamList = (List)reach.getObject("__upstreamHRUs");
            List subbasinList = (List)this.reach2hruMap.get(reach);
            if (subbasinList != null) {
                upstreamList.addAll(subbasinList);
            }
            Attribute.EntityCollection hrus = this.getModel().getRuntime().getDataFactory().createEntityCollection();
            hrus.setEntities(upstreamList);
            reach.setObject(this.subbasinEntitiesAttributeName.getValue(), (Object)hrus);
            Attribute.Entity destReach = (Attribute.Entity)reach.getObject(this.reach2reachAttributeName.getValue());
            if (destReach.isEmpty()) continue;
            List destReachList = (List)destReach.getObject("__upstreamHRUs");
            destReachList.addAll(upstreamList);
        }
    }
}

