/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="SnowSublimation", author="Sven Kralisch", description="Calculate snow sublimation after https://doi.org/10.1029/2020WR029266", date="2022-02-16", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class SnowSublimation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily mean air temperature", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="precipitation", unit="mm")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily shortwave radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double swRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="minimum daily shortwave radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double swRadMin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum daily shortwave radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double swRadMax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity elevation", unit="m")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity area", unit="m\u00b2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="topographic exposure")
    public Attribute.Double topex;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="albedo")
    public Attribute.Double albedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="minimum elevation where sublimation occurs", defaultValue="2500")
    public Attribute.Double minElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum elevation where sublimation occurs", defaultValue="6500")
    public Attribute.Double maxElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="sublimation factor", defaultValue="1")
    public Attribute.Double sFact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="total snow water equivalent", unit="L")
    public Attribute.Double totSWE;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actual sublimation", unit="L")
    public Attribute.Double sublimation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="actual sublimation", unit="L")
    public Attribute.Double ID;
    public static final double L = 2.838;

    public void run() {
        double scaledElevation = Math.min(Math.max(this.elevation.getValue(), this.minElevation.getValue()), this.maxElevation.getValue());
        scaledElevation -= this.minElevation.getValue();
        double pSub = this.swRad.getValue() * this.topex.getValue() * (scaledElevation /= this.maxElevation.getValue() - this.minElevation.getValue());
        double pSubMin = this.swRadMin.getValue() * this.topex.getValue() * scaledElevation;
        double pSubMax = this.swRadMax.getValue() * this.topex.getValue() * scaledElevation;
        if (pSub != 0.0) {
            pSub = (pSub - pSubMin) / (pSubMax - pSubMin);
        }
        double sMax = (1.0 - this.albedo.getValue()) * this.swRad.getValue() * 2.838;
        boolean sCon = this.tmean.getValue() <= 0.0 && this.precip.getValue() <= 1.0;
        double sPot = !sCon ? 0.0 : this.sFact.getValue() * pSub * sMax;
        double sAct = Math.min(sPot *= this.area.getValue(), this.totSWE.getValue());
        this.totSWE.setValue(this.totSWE.getValue() - sAct);
        this.sublimation.setValue(sAct);
    }

    public void cleanup() {
    }
}

