/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="ABCSnowModule", author="Peter Krause", description="The famous snow-17 snow module. Implementation is based on the original sources of Eric Anderson in a reworked version for the ModularModellingSystem MMSsome very minor adaptation were necessary to make the routine JAMS compatible")
public class Snow17ModuleMMS
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time interval")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity elevation")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity latitude")
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain amount")
    public Attribute.Double rain_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow amount")
    public Attribute.Double snow_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the temperature")
    public Attribute.Double airTemperature;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the daily minimum temperature")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the daily maximum temperature")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow water equivalent [WE]")
    public Attribute.Double swe_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="negative snow heat [NEGHS]")
    public Attribute.Double negSnowHeat_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="cnhs not clear [CNHS]")
    public Attribute.Double cnhs_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="liquid water in snow pack [LIQW]")
    public Attribute.Double liqWater_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Antecedent temperature index [TINDEX]")
    public Attribute.Double tindex_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Cumulated snow water including liquid [ACCMAX]")
    public Attribute.Double maxAccumulation_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Snow liquid water attenuation storage [STORGE]")
    public Attribute.Double liqWaterAttStorage_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Adjusted areal snow cover fraction [AEADJ]")
    public Attribute.Double aeAdj_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array of lagged liquid water values [EXLAG]")
    public Attribute.DoubleArray exlag_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Average snow temperature [SNTMP]")
    public Attribute.Double snowTemp_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Average snow depth [SNDPT]")
    public Attribute.Double snowDepth_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Average snow density [DS]")
    public Attribute.Double snowDens_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Areal snow cover [AESC]")
    public Attribute.Double arealSnowCover_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="internal state [SB]")
    public Attribute.Double sb_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="internal state [SBWS]")
    public Attribute.Double sbws_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="internal state [SBAESC]")
    public Attribute.Double sbaesc_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total pack water")
    public Attribute.Double totalPackWater_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain passed by the snow module [RAIN]")
    public Attribute.Double rainOut_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow pack runoff [PACKRO]")
    public Attribute.Double packRunoff_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="ground melt runoff [GMRO]")
    public Attribute.Double groundMeltRunoff_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="pack melt [MELT]")
    public Attribute.Double packMelt_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain on bare ground [ROBG]")
    public Attribute.Double rainOnBareGround_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="refrozen water [SXRFRZ]")
    public Attribute.Double refrozenWater_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="total output [RM]")
    public Attribute.Double totalOutput_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="net surface energy exchange [QNET]")
    public Attribute.Double netSurfaceEnergyExchange_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow evaporation")
    public Attribute.Double snowEvap_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="maximum temperature at timeStep-1")
    public Attribute.Double tmaxPre;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow correction factor [SCF]")
    public Attribute.Double snowCorrectionFactor_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="minimum melt factor [MFMIN]")
    public Attribute.Double meltFactorMin_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum melt factor [MFMAX]")
    public Attribute.Double meltFactorMax_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="average wind function [UADJ]")
    public Attribute.Double avgWindFunction_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="minimum SWE for 100% cover [SI]")
    public Attribute.Double min100CoverSwe_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="ordinates of the areal depletion curve [ADC]")
    public Attribute.DoubleArray arealDepletionCurve_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum negative melt factor [NMF]")
    public Attribute.Double maxNegativeMeltFactor_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="antecedent temperature index parameter [TIPM]")
    public Attribute.Double tipm_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temperature which delineates rain from snow [PXTEMP]not used in this version, because rain and snow comes as input")
    public Attribute.Double pxtemp_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="percent (decimal) liquid water holding capacity [PLWHC]")
    public Attribute.Double maxWaterCap_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="constant amount of melt at the snow-soil interface [DAYGM]")
    public Attribute.Double groundMelt_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="base temperature for snowmelt computations during non-rain periods [MBASE]")
    public Attribute.Double baseTemp_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="melt factor variation type: [LMFV]0 & latitude < 54 default;0 & latitude > 54 Alaska type;1 user specified ")
    public Attribute.Integer lmfv_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="module active")
    public Attribute.Boolean active;
    double sfnew;
    double rfmin;
    double sbci;
    int deltaTime;
    int month;
    int date;
    int julDay;
    double packRunoff;
    double groundMeltRunoff;
    double rainOnBareGround;
    double refrozenWater;
    double totalOutput;
    double packMelt;
    double rainMelt;
    double snowEvap;
    double[] exlag;
    double[] arealDepletionCurve = new double[]{0.0, 0.07, 0.21, 0.3, 0.36, 0.41, 0.45, 0.51, 0.6, 0.7, 1.0};
    double[] monthlyMeltFactor = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    double precip;
    double rainOut;
    double rainIn;
    double snowIn;
    double airTemp;
    double snowFall;
    double swe;
    double liqWater;
    double snowTemp;
    double sb;
    double sbws;
    double sbaesc;
    double maxAccumulation;
    double aeAdj;
    double tindex;
    double liqWaterAttStorage;
    double snowDepth;
    double snowDens;
    double groundSnowLoss;
    double groundWaterLoss;
    double arealSnowCover;
    double cnhs;
    double negSnowHeat;
    double netSurfaceEnergyExchange;
    boolean meltComputed;
    double pmSave;
    double dqnet;
    double totalPackWater;
    int nosnow = 1;
    double snof;
    double cnhspx;
    double groundMelt;
    double avgWindFunction;
    double maxWaterCap;
    final double SNEW = 1.5;
    final double RMIN = 0.25;
    final double SBC = 0.0612;
    double sublimationRate = 0.0;

    public void init() {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        if (this.active == null || this.active.getValue()) {
            double rfrac;
            int tu;
            if (this.exlag_1.getValue() == null) {
                double[] ex = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                this.exlag_1.setValue(ex);
            }
            if ((tu = this.timeInterval.getTimeUnit()) == 6) {
                this.deltaTime = 24 * this.timeInterval.getTimeUnitCount();
            }
            if (tu == 11) {
                this.deltaTime = this.timeInterval.getTimeUnitCount();
            }
            this.sfnew = 1.5 * (double)this.deltaTime;
            this.rfmin = 0.25 * (double)this.deltaTime;
            this.sbci = 0.0612 * (double)this.deltaTime;
            double airPressure = 1012.4 - 11.34 * this.elevation.getValue() / 100.0 + 0.00745 * Math.pow(this.elevation.getValue() / 100.0, 2.4);
            this.rainOut = 0.0;
            this.packRunoff = 0.0;
            this.groundMeltRunoff = 0.0;
            this.packMelt = 0.0;
            this.pmSave = 0.0;
            this.rainOnBareGround = 0.0;
            this.refrozenWater = 0.0;
            this.totalOutput = 0.0;
            this.meltComputed = false;
            this.rainMelt = 0.0;
            this.groundSnowLoss = 0.0;
            this.netSurfaceEnergyExchange = 0.0;
            this.month = this.time.get(2);
            this.date = this.time.get(5);
            this.julDay = this.time.get(6);
            this.rainIn = this.rain_1.getValue() / this.area.getValue();
            this.snowIn = this.snow_1.getValue() / this.area.getValue();
            this.precip = this.rainIn + this.snowIn;
            this.airTemp = this.airTemperature.getValue();
            this.swe = this.swe_1.getValue();
            this.liqWater = this.liqWater_1.getValue();
            this.snowTemp = this.snowTemp_1.getValue();
            this.sb = this.sb_1.getValue();
            this.sbws = this.sbws_1.getValue();
            this.sbaesc = this.sbaesc_1.getValue();
            this.maxAccumulation = this.maxAccumulation_1.getValue();
            this.aeAdj = this.aeAdj_1.getValue();
            this.tindex = this.tindex_1.getValue();
            this.exlag = this.exlag_1.getValue();
            this.liqWaterAttStorage = this.liqWaterAttStorage_1.getValue();
            this.snowDepth = this.snowDepth_1.getValue();
            this.snowDens = this.snowDens_1.getValue();
            this.arealSnowCover = this.arealSnowCover_1.getValue();
            this.cnhs = this.cnhs_1.getValue();
            this.negSnowHeat = this.negSnowHeat_1.getValue();
            this.cnhspx = 0.0;
            this.groundMelt = this.groundMelt_1.getValue();
            this.avgWindFunction = this.avgWindFunction_1.getValue();
            this.maxWaterCap = this.maxWaterCap_1.getValue();
            double sfrac = 0.0;
            if (this.precip > 0.0) {
                rfrac = this.rainIn / this.precip;
                sfrac = this.snowIn / this.precip;
            } else {
                rfrac = 0.0;
                sfrac = 0.0;
            }
            this.nwsmrun();
            double lagged = 0.0;
            for (int i = 0; i < this.exlag.length; ++i) {
                lagged += this.exlag[i];
            }
            this.totalPackWater = this.swe + this.liqWater + this.liqWaterAttStorage + lagged;
            this.rainOut_1.setValue(this.rainOut * this.area.getValue());
            this.packRunoff_1.setValue(this.packRunoff * this.area.getValue());
            this.groundMeltRunoff_1.setValue(this.groundMeltRunoff);
            this.packMelt_1.setValue(this.pmSave);
            this.rainOnBareGround_1.setValue(this.rainOnBareGround);
            this.refrozenWater_1.setValue(this.refrozenWater);
            this.totalOutput_1.setValue(this.totalOutput);
            this.netSurfaceEnergyExchange_1.setValue(this.netSurfaceEnergyExchange);
            this.swe_1.setValue(this.swe);
            this.liqWater_1.setValue(this.liqWater);
            this.snowTemp_1.setValue(this.snowTemp);
            this.sb_1.setValue(this.sb);
            this.sbws_1.setValue(this.sbws);
            this.sbaesc_1.setValue(this.sbaesc);
            this.maxAccumulation_1.setValue(this.maxAccumulation);
            this.aeAdj_1.setValue(this.aeAdj);
            this.tindex_1.setValue(this.tindex);
            this.exlag_1.setValue(this.exlag);
            this.liqWaterAttStorage_1.setValue(this.liqWaterAttStorage);
            this.snowDepth_1.setValue(this.snowDepth);
            this.snowDens_1.setValue(this.snowDens);
            this.arealSnowCover_1.setValue(this.arealSnowCover);
            this.cnhs_1.setValue(this.cnhs);
            this.negSnowHeat_1.setValue(this.negSnowHeat);
            this.totalPackWater_1.setValue(this.totalPackWater * this.area.getValue());
            this.snow_1.setValue(0.0);
        }
    }

    public void cleanup() {
    }

    public void nwsmrun() {
        int i;
        this.packRunoff = 0.0;
        if (this.swe == 0.0 && this.precip == 0.0) {
            return;
        }
        double[] t6hr = new double[4];
        double tmnpst = this.tmin.getValue() - this.tmax.getValue() + this.tmaxPre.getValue();
        t6hr[0] = 0.95 * this.tmin.getValue() + 0.05 * this.tmaxPre.getValue();
        t6hr[1] = 0.4 * this.tmin.getValue() + 0.6 * this.tmax.getValue();
        t6hr[2] = 0.925 * this.tmax.getValue() + 0.025 * this.tmin.getValue() + 0.05 * tmnpst;
        t6hr[3] = 0.33 * this.tmax.getValue() + 0.67 * tmnpst;
        this.tmaxPre.setValue(this.tmax.getValue());
        double lagged = 0.0;
        for (int i2 = 0; i2 < this.exlag.length; ++i2) {
            lagged += this.exlag[i2];
        }
        double beginpack = this.swe + this.liqWater + lagged + this.liqWaterAttStorage;
        double dsfall = 0.0;
        double drain = 0.0;
        double dqnet = 0.0;
        double meltFactor = this.calcMeltFactor(this.julDay, this.latitude.getValue(), this.meltFactorMax_1.getValue(), this.meltFactorMin_1.getValue());
        double ratio = meltFactor / this.meltFactorMax_1.getValue();
        double elev100 = this.elevation.getValue() / 100.0;
        double airPressure = 1012.4 - 11.34 * elev100 + 0.00745 * Math.pow(elev100, 2.4);
        int tsHours = 0;
        int tu = this.timeInterval.getTimeUnit();
        if (tu == 6) {
            tsHours = 24;
        } else if (tu == 5) {
            tsHours = this.timeInterval.getTimeUnitCount();
        }
        int ndt = 24 / tsHours;
        tsHours = 24 / ndt;
        if (ndt != 4) {
            ndt = 4;
        }
        if (tsHours != 6) {
            tsHours = 6;
        }
        double sfnew = 1.5 * (double)tsHours;
        double rfmin = 0.25 * (double)tsHours;
        double sbci = 0.0612 * (double)tsHours;
        double gm = this.groundMelt_1.getValue() / (double)ndt;
        this.nosnow = 0;
        this.packMelt = 0.0;
        for (int t = 0; t < ndt; ++t) {
            double tAir;
            this.snowEvap = 0.0;
            this.packMelt = 0.0;
            double rainInTs = 0.0;
            this.rainMelt = 0.0;
            this.cnhs = 0.0;
            this.cnhspx = 0.0;
            this.snowFall = 0.0;
            this.groundMeltRunoff = 0.0;
            this.rainOnBareGround = 0.0;
            this.nosnow = 1;
            boolean stillSnow = true;
            double precip6hr = this.precip / (double)ndt;
            double tRain = tAir = t6hr[t];
            if (precip6hr > 0.0) {
                if (tAir <= this.pxtemp_1.getValue()) {
                    this.snowTemp = tRain;
                    if (this.snowTemp > 0.0) {
                        this.snowTemp = 0.0;
                    }
                    this.snowFall = precip6hr;
                    if (this.rainIn > 0.0) {
                        this.rainIn -= this.snowFall;
                    }
                    if (this.rainIn < 0.0) {
                        this.rainIn = 0.0;
                    }
                    dsfall += this.snowFall;
                    this.sbws = this.swe + this.liqWater + 0.75 * precip6hr;
                    this.swe += this.snowFall;
                    if (this.swe + this.liqWater >= 3.0 * this.sb) {
                        this.maxAccumulation = this.swe + this.liqWater;
                    }
                    this.cnhspx = -1.0 * this.snowTemp * this.snowFall / 160.0;
                    if (precip6hr > sfnew) {
                        this.tindex = this.airTemp;
                    }
                    precip6hr = 0.0;
                } else if (this.swe > 0.0) {
                    if (tRain < 0.0) {
                        tRain = 0.0;
                    }
                    this.rainMelt = 0.0125 * precip6hr * tRain;
                    drain += precip6hr;
                    rainInTs = precip6hr;
                } else {
                    this.rainOut += precip6hr;
                    drain += precip6hr;
                    this.call300();
                    stillSnow = false;
                }
            }
            if (stillSnow) {
                if (this.swe <= gm) {
                    this.groundMeltRunoff = this.swe + this.liqWater;
                    rainInTs = 0.0;
                    this.rainOnBareGround = precip6hr;
                    this.call300();
                    stillSnow = false;
                } else {
                    this.groundWaterLoss = gm / this.swe * this.liqWater;
                    this.groundMeltRunoff = gm + this.groundWaterLoss;
                }
            }
            if (stillSnow) {
                this.packMelt = this.callMeltrate(tAir, ratio, rainInTs, meltFactor, t, airPressure);
                this.arealSnowCover = this.callAeSnow();
                if (this.arealSnowCover < 1.0) {
                    gm *= this.arealSnowCover;
                    this.groundMeltRunoff *= this.arealSnowCover;
                    this.groundWaterLoss *= this.arealSnowCover;
                    this.packMelt *= this.arealSnowCover;
                    this.cnhs *= this.arealSnowCover;
                    this.snowEvap *= this.arealSnowCover;
                    this.rainOnBareGround = this.rainIn * (1.0 - this.arealSnowCover);
                    this.rainIn -= this.rainOnBareGround;
                } else {
                    this.rainOnBareGround = 0.0;
                }
                this.swe -= gm;
                this.liqWater -= this.groundWaterLoss;
                if (this.cnhs + this.negSnowHeat < 0.0) {
                    this.cnhs = -1.0 * this.negSnowHeat;
                }
                if (this.packMelt >= this.swe) {
                    this.packMelt = this.swe + this.liqWater;
                    dqnet += this.packMelt;
                    this.call300();
                    stillSnow = false;
                } else {
                    this.swe -= this.packMelt;
                }
            }
            if (stillSnow) {
                if (this.snowEvap >= this.swe) {
                    this.snowEvap = this.swe + this.liqWater;
                    dqnet += this.snowEvap;
                    this.call300();
                    stillSnow = false;
                } else {
                    this.swe -= this.snowEvap;
                }
            }
            if (stillSnow) {
                this.netSurfaceEnergyExchange = this.packMelt - this.cnhs - this.cnhspx + this.snowEvap;
                dqnet += this.netSurfaceEnergyExchange;
                double excessWater = this.callHeatWater(rainInTs);
                rainInTs = 0.0;
                this.packRunoff += this.callRoute2(tsHours, excessWater);
                this.packRunoff += this.groundMeltRunoff;
            }
            this.pmSave += this.packMelt;
            this.rainOut += rainInTs;
        }
        if (this.nosnow > 0) {
            lagged = 0.0;
            for (i = 0; i < this.exlag.length; ++i) {
                lagged += this.exlag[i];
            }
            this.totalPackWater = this.swe + this.liqWater + this.liqWaterAttStorage + lagged;
            this.arealSnowCover = this.callAeSnow();
        } else {
            this.totalPackWater = 0.0;
            for (i = 0; i < this.exlag.length; ++i) {
                this.exlag[i] = 0.0;
            }
        }
    }

    public void call300() {
        double lagged = 0.0;
        for (int i = 0; i < this.exlag.length; ++i) {
            lagged += this.exlag[i];
            this.exlag[i] = 0.0;
        }
        this.packRunoff = this.packRunoff + this.groundMeltRunoff + this.packMelt + lagged + this.liqWaterAttStorage;
        this.swe = 0.0;
        this.negSnowHeat = 0.0;
        this.liqWater = 0.0;
        this.sb = 0.0;
        this.sbaesc = 0.0;
        this.sbws = 0.0;
        this.maxAccumulation = 0.0;
        this.arealSnowCover = 0.0;
        this.tindex = 0.0;
        this.liqWaterAttStorage = 0.0;
        this.nosnow = 0;
    }

    public double calcMeltFactor(int jDay, double lat, double mfMax, double mfMin) {
        double diff = mfMax - mfMin;
        double meltFactor = 0.0;
        double x = 0.0;
        double adjmf = 0.0;
        int dayN = this.julDay > 79 ? this.julDay - 79 : 366 + this.julDay - 79;
        if (lat < 54.0) {
            meltFactor = Math.sin((double)dayN * 2.0 * Math.PI / 366.0) * diff * 0.5 + (mfMax + mfMin) * 0.5;
        } else {
            x = this.julDay >= 275 ? (double)((dayN - 275) / 183) : (this.julDay >= 92 ? (275.0 - (double)dayN) / 183.0 : (double)((91 + dayN) / 183));
            double xx = Math.sin((double)(dayN * 2) * Math.PI / 366.0) * 0.5 + 0.5;
            adjmf = x <= 0.48 ? 0.0 : (x >= 0.7 ? 1.0 : (x - 0.48) / 0.21999999999999997);
            meltFactor = xx * adjmf * diff + mfMin;
        }
        return meltFactor;
    }

    public double callMeltrate(double airTemp, double ratio, double rain, double meltFactor, int subInt, double airPressure) {
        double tsur;
        double meltRate = 0.0;
        double tmx = airTemp - this.baseTemp_1.getValue();
        if (tmx < 0.0) {
            tmx = 0.0;
        }
        if ((tsur = airTemp) > 0.0) {
            tsur = 0.0;
        }
        double nmindex = this.tindex - tsur;
        double nmrate = ratio * this.maxNegativeMeltFactor_1.getValue();
        this.cnhs = nmrate * nmindex;
        this.tindex += this.tipm_1.getValue() * (airTemp - this.tindex);
        if (rain <= this.rfmin) {
            meltRate = meltFactor * tmx + this.rainMelt;
            if (subInt > 0 && subInt < 3) {
                this.snowEvap += this.sublimationRate * 0.5;
            }
        } else {
            double ea = 2.7489E8 * Math.exp(-4278.63 / (airTemp + 242.792));
            double tak4 = Math.pow((airTemp + 273.16) * 0.01, 4.0);
            double qn = this.sbci * (tak4 - 55.55);
            double qe = 8.5 * ((ea *= 0.9) - 6.11) * this.avgWindFunction_1.getValue();
            double qh = 0.0048449999999999995 * airPressure * this.avgWindFunction_1.getValue() * airTemp;
            meltRate = qn + qe + qh + this.rainMelt;
        }
        if (meltRate < 0.0) {
            meltRate = 0.0;
        }
        return meltRate;
    }

    private double callAeSnow() {
        double aesc = 0.0;
        double twe = this.swe + this.liqWater;
        if (twe > this.maxAccumulation) {
            this.maxAccumulation = twe;
        }
        double ai = this.maxAccumulation;
        if (this.maxAccumulation > this.min100CoverSwe_1.getValue()) {
            ai = this.min100CoverSwe_1.getValue();
        }
        if (twe >= ai) {
            this.sb = twe;
            this.sbws = twe;
            aesc = 1.0;
        } else if (twe <= this.sb) {
            double r;
            double fn;
            double n;
            int idx = (int)n;
            if ((aesc = this.arealDepletionCurve[idx] + (this.arealDepletionCurve[idx + 1] - this.arealDepletionCurve[idx]) * (r -= (fn = (n = (r = twe / ai * 10.0))))) > 1.0) {
                aesc = 1.0;
            }
            this.sb = twe + 1.27;
            this.sbaesc = aesc;
        } else if (twe >= this.sbws) {
            aesc = 1.0;
        }
        if (aesc < 0.05) {
            aesc = 0.05;
        }
        if (aesc > 1.0) {
            aesc = 1.0;
        }
        return aesc;
    }

    private double callHeatWater(double rainInTs) {
        double excessWater;
        double water = this.packMelt + rainInTs;
        this.rainIn -= rainInTs;
        double heat = this.cnhs + this.cnhspx;
        double liqWMax = this.maxWaterCap_1.getValue() * this.swe;
        this.negSnowHeat += heat;
        if (this.negSnowHeat < 0.0) {
            this.negSnowHeat = 0.0;
        }
        if (this.negSnowHeat > 0.33 * this.swe) {
            this.negSnowHeat = 0.33 * this.swe;
        }
        if (water + this.liqWater < liqWMax + this.negSnowHeat + this.maxWaterCap_1.getValue() * this.negSnowHeat) {
            if (water + this.liqWater < this.negSnowHeat) {
                this.swe = this.swe + water + this.liqWater;
                this.negSnowHeat = this.negSnowHeat - water - this.liqWater;
                this.refrozenWater = this.refrozenWater + water + this.liqWater;
                this.liqWater = 0.0;
                water = 0.0;
                excessWater = 0.0;
            } else {
                this.liqWater = this.liqWater + water - this.negSnowHeat;
                this.swe += this.negSnowHeat;
                this.refrozenWater += this.negSnowHeat;
                this.negSnowHeat = 0.0;
                excessWater = 0.0;
            }
        } else {
            excessWater = water + this.liqWater - liqWMax - this.negSnowHeat - this.maxWaterCap_1.getValue() * this.negSnowHeat;
            this.liqWater = liqWMax + this.maxWaterCap_1.getValue() * this.negSnowHeat;
            this.swe += this.negSnowHeat;
            this.negSnowHeat = 0.0;
        }
        if (this.tindex > 0.0) {
            this.tindex = 0.0;
        }
        if (this.negSnowHeat == 0.0) {
            this.tindex = 0.0;
        }
        return excessWater;
    }

    private double callRoute(int hoursInTimeStep, double excessWater) {
        double packro = 0.0;
        double cl = 0.03 * (double)hoursInTimeStep / 6.0;
        double prior = this.liqWaterAttStorage + this.exlag[0];
        boolean hundredfifty = false;
        boolean hundredsixty = false;
        boolean hundredninety = false;
        if (excessWater == 0.0 && prior == 0.0) {
            hundredninety = true;
        } else if (excessWater == 0.0 && prior >= 0.1) {
            hundredsixty = true;
        } else if (excessWater < 0.1 || this.swe < 1.0) {
            this.exlag[0] = this.exlag[0] + excessWater;
            hundredfifty = true;
        } else {
            double n = Math.pow(excessWater * 4.0, 0.3) + 0.5;
            if (n == 0.0) {
                n = 0.0;
            }
            double fn = n;
            int i = 0;
            while ((double)i < n) {
                double fi = i + 1;
                double term = cl * this.swe * fn / (excessWater * (fi - 0.5));
                if (term > 150.0) {
                    term = 150.0;
                }
                double flag = 5.33 * (1.0 - Math.exp(-term));
                double dl2 = (flag + (double)hoursInTimeStep) / (double)hoursInTimeStep + 1.0;
                double dl1 = dl2 - 1.0;
                double endl1 = dl1 * (double)hoursInTimeStep;
                double por2 = (flag + (double)hoursInTimeStep - endl1) / (double)hoursInTimeStep;
                double por1 = 1.0 - por2;
                int l1 = (int)dl1;
                int l2 = (int)dl2;
                this.exlag[l2] = this.exlag[l2] + por2 * excessWater / fn;
                this.exlag[l1] = this.exlag[l1] + por1 * excessWater / fn;
                ++i;
            }
        }
        if (hundredfifty) {
            if (this.liqWaterAttStorage + this.exlag[0] == 0.0) {
                hundredninety = true;
                hundredsixty = false;
            } else if (this.liqWaterAttStorage + this.exlag[0] >= 0.1) {
                hundredsixty = true;
            } else {
                packro = this.liqWaterAttStorage + this.exlag[0];
                this.liqWaterAttStorage = 0.0;
                hundredninety = true;
            }
        }
        if (hundredsixty) {
            double el = this.exlag[0] / (double)hoursInTimeStep;
            double els = el / (25.4 * this.arealSnowCover);
            double wes = this.swe / (25.4 * this.arealSnowCover);
            double term = 500.0 * els / Math.pow(wes, 1.3);
            if (term > 150.0) {
                term = 150.0;
            }
            double r1 = 1.0 / (5.0 * Math.exp(-term) + 1.0);
            double os = 0.0;
            for (int i = 0; i < hoursInTimeStep; ++i) {
                os = (this.liqWaterAttStorage + el) * r1;
                packro += os;
                this.liqWaterAttStorage = this.liqWaterAttStorage + el - os;
            }
            if (this.liqWaterAttStorage > 0.001) {
                hundredninety = true;
            } else {
                packro += this.liqWaterAttStorage;
                this.liqWaterAttStorage = 0.0;
            }
        }
        if (hundredninety = true) {
            for (int i = 1; i < this.exlag.length; ++i) {
                this.exlag[i - 1] = this.exlag[i];
            }
            this.exlag[this.exlag.length - 1] = 0.0;
        }
        return packro;
    }

    private double callRoute2(int hoursInTimeStep, double excessWater) {
        int it = hoursInTimeStep;
        double packro = 0.0;
        double cl = 0.03 * (double)it / 6.0;
        if (excessWater != 0.0) {
            if (excessWater < 0.1) {
                this.exlag[0] = this.exlag[0] + excessWater;
            } else if (this.swe < 1.0) {
                this.exlag[0] = this.exlag[0] + excessWater;
            } else {
                int n = (int)Math.floor(Math.pow(excessWater * 4.0, 0.3) + 0.5);
                if (n == 0) {
                    n = 1;
                }
                int fn = n;
                int dt = it;
                for (int i = 0; i < n; ++i) {
                    int fi = i + 1;
                    double term = cl * this.swe * (double)fn / (excessWater * ((double)fi - 0.5));
                    if (term > 150.0) {
                        term = 150.0;
                    }
                    double flagg = 5.33 * (1.0 - Math.exp(-term));
                    int l2 = (int)Math.floor((flagg + (double)dt) / (double)dt + 1.0);
                    int l1 = l2 - 1;
                    int endl1 = l1 * it;
                    double por2 = (flagg + (double)dt - (double)endl1) / (double)dt;
                    double por1 = 1.0 - por2;
                    this.exlag[--l2] = this.exlag[l2] + por2 * excessWater / (double)fn;
                    this.exlag[--l1] = this.exlag[l1] + por1 * excessWater / (double)fn;
                }
            }
        }
        if (this.liqWaterAttStorage + this.exlag[0] != 0.0) {
            if (this.liqWaterAttStorage + this.exlag[0] >= 0.1) {
                int dt = it;
                double el = this.exlag[0] / (double)dt;
                double els = el / (25.4 * this.arealSnowCover);
                double wes = this.swe / (25.4 * this.arealSnowCover);
                double term = 500.0 * els / Math.pow(wes, 1.3);
                if (term > 150.0) {
                    term = 150.0;
                }
                double r1 = 1.0 / (5.0 * Math.exp(-term) + 1.0);
                for (int i = 0; i < hoursInTimeStep; ++i) {
                    double os = (this.liqWaterAttStorage + el) * r1;
                    packro += os;
                    this.liqWaterAttStorage = this.liqWaterAttStorage + el - os;
                }
                if (this.liqWaterAttStorage <= 0.001) {
                    packro += this.liqWaterAttStorage;
                    this.liqWaterAttStorage = 0.0;
                }
            } else {
                packro = this.liqWaterAttStorage + this.exlag[0];
                this.liqWaterAttStorage = 0.0;
            }
        }
        for (int i = 1; i < this.exlag.length; ++i) {
            this.exlag[i - 1] = this.exlag[i];
        }
        this.exlag[this.exlag.length - 1] = 0.0;
        return packro;
    }
}

