/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import jams.JAMS;
import jams.data.ArrayPool;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.unijena.j2k.statistics.IDW;

@JAMSComponentDescription(title="Regionalisation_IDW", author="Sven Kraisch based on Regionalisation.java by Peter Krause", version="1.0_0", date="2019-11-27", description="Calculate local (regionalised) input values based on the inverse distance weighting procedure.")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class Regionalisation_IDW
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of data values for current time step")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Regression coefficients")
    public Attribute.DoubleArray regCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Array of station elevations")
    public Attribute.DoubleArray statElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Array of stations' x coordinates")
    public Attribute.DoubleArray statXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Array of stations' y coordinates")
    public Attribute.DoubleArray statYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attribute name elevation")
    public Attribute.Double entityElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Entity's x coordinate")
    public Attribute.Double entityXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Entity's y coordinate")
    public Attribute.Double entityYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Max. number of nearest stations to be considered in IDW", defaultValue="1000")
    public Attribute.Integer nidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Power of IDW function", defaultValue="1")
    public Attribute.Double pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Weights for Thiessen polygons", defaultValue="false")
    public Attribute.Boolean equalWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculation with geographical coordinates lat, long", defaultValue="false")
    public Attribute.Boolean latLong;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Apply elevation correction to measured data")
    public Attribute.Boolean elevationCorrection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Minimum r\u00b2 value for elevation correction application")
    public Attribute.Double rsqThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible minimum value for data set", defaultValue="-Infinity")
    public Attribute.Double fixedMinimum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible maximum value for data set", defaultValue="Infinity")
    public Attribute.Double fixedMaximum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array of station weights")
    public Attribute.DoubleArray statWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array position of weights")
    public Attribute.IntegerArray statOrder;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array io stations distances")
    public Attribute.DoubleArray statDistance;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="regionalised data value")
    public Attribute.Double dataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Calculate statis values for IDW (see next three variables)?", defaultValue="false")
    public Attribute.Boolean calcStats;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Weights of individual stations (first element equals first station in list)")
    public Attribute.Double[] actualWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Weighted average elevation of source stations")
    public Attribute.Double averageSourceElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Weighted average distance of source stations")
    public Attribute.Double averageSourceDistance;
    boolean invalidDatasetReported = false;
    ArrayPool<double[]> memPool = new ArrayPool(Double.TYPE);
    ArrayPool<int[]> imemPool = new ArrayPool(Integer.TYPE);
    IDW idw = new IDW();

    public void initAll() {
        int i;
        double[] statX = this.statXCoord.getValue();
        double[] statY = this.statYCoord.getValue();
        double entityX = this.entityXCoord.getValue();
        double entityY = this.entityYCoord.getValue();
        double power = this.pidw.getValue();
        int nStations = statX.length;
        double[] weights = new double[nStations];
        double[] dists = new double[nStations];
        int[] order = new int[nStations];
        if (this.equalWeights.getValue()) {
            for (int i2 = 0; i2 < nStations; ++i2) {
                weights[i2] = 1 / nStations;
            }
        } else {
            int i3;
            int i4;
            if (this.latLong.getValue()) {
                for (i4 = 0; i4 < nStations; ++i4) {
                    dists[i4] = this.getDistLatLong(entityX, entityY, statX[i4], statY[i4]);
                }
            } else {
                for (i4 = 0; i4 < nStations; ++i4) {
                    dists[i4] = this.getDist(entityX, entityY, statX[i4], statY[i4]);
                }
            }
            double sum = 0.0;
            for (int i5 = 0; i5 < nStations; ++i5) {
                sum += dists[i5];
            }
            int sameLocation = -1;
            for (i3 = 0; i3 < nStations; ++i3) {
                if (dists[i3] == 0.0) {
                    sameLocation = i3;
                    break;
                }
                weights[i3] = Math.pow(sum / dists[i3], power);
            }
            if (sameLocation > -1) {
                for (i3 = 0; i3 < nStations; ++i3) {
                    weights[i3] = sameLocation == i3 ? 1.0 : 0.0;
                }
            }
        }
        ArrayList<Station> stations = new ArrayList<Station>(nStations);
        for (i = 0; i < nStations; ++i) {
            stations.add(new Station(i, weights[i]));
        }
        Collections.sort(stations, new Comparator<Station>(){

            @Override
            public int compare(Station o1, Station o2) {
                if (o1.weight - o2.weight > 0.0) {
                    return -1;
                }
                if (o1.weight - o2.weight < 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        i = 0;
        for (Station s : stations) {
            order[i++] = s.id;
        }
        if (this.calcStats.getValue()) {
            this.statDistance.setValue(dists);
        }
        this.statWeights.setValue(weights);
        this.statOrder.setValue(order);
    }

    public void run() {
        double[] rc = this.regCoeff.getValue();
        double gradient = rc[1];
        double rsq = rc[2];
        double[] sourceElevations = this.statElevation.getValue();
        double[] sourceData = this.dataArray.getValue();
        double[] sourceWeights = this.statWeights.getValue();
        double targetElevation = this.entityElevation.getValue();
        int[] wA = this.statOrder.getValue();
        double value = 0.0;
        double deltaElev = 0.0;
        int nIDW = Math.min(this.nidw.getValue(), wA.length);
        double[] data = (double[])this.memPool.alloc(nIDW);
        double[] weights = (double[])this.memPool.alloc(nIDW);
        double[] elev = (double[])this.memPool.alloc(nIDW);
        int[] source = (int[])this.imemPool.alloc(nIDW);
        double[] dist = null;
        double[] sourceDistances = null;
        if (this.calcStats.getValue()) {
            sourceDistances = this.statDistance.getValue();
            dist = (double[])this.memPool.alloc(nIDW);
            if (this.actualWeights != null) {
                for (Attribute.Double w : this.actualWeights) {
                    w.setValue(0.0);
                }
            }
        }
        int counter = 0;
        int element = 0;
        boolean valid = false;
        while (counter < nIDW) {
            int col = wA[element];
            if (sourceData[col] == JAMS.getMissingDataValue()) {
                ++element;
            } else {
                valid = true;
                source[counter] = col;
                data[counter] = sourceData[col];
                weights[counter] = sourceWeights[col];
                elev[counter] = sourceElevations[col];
                if (this.calcStats.getValue()) {
                    dist[counter] = sourceDistances[col];
                }
                ++counter;
                ++element;
            }
            if (element < wA.length) continue;
            break;
        }
        if (valid) {
            int i;
            double weightsum = 0.0;
            for (i = 0; i < counter; ++i) {
                weightsum += weights[i];
            }
            for (i = 0; i < counter; ++i) {
                weights[i] = weights[i] / weightsum;
            }
            for (i = 0; i < counter; ++i) {
                if (this.elevationCorrection.getValue() && rsq >= this.rsqThreshold.getValue()) {
                    deltaElev = targetElevation - elev[i];
                    double tVal = (deltaElev * gradient + data[i]) * weights[i];
                    value += tVal;
                    continue;
                }
                value += data[i] * weights[i];
            }
            value = Math.max(value, this.fixedMinimum.getValue());
            value = Math.min(value, this.fixedMaximum.getValue());
            if (this.calcStats.getValue()) {
                double avgElev = 0.0;
                double avgDist = 0.0;
                for (int i2 = 0; i2 < counter; ++i2) {
                    avgElev += elev[i2] * weights[i2];
                    avgDist += dist[i2] * weights[i2];
                    if (this.actualWeights == null) continue;
                    this.actualWeights[source[i2]].setValue(weights[i2]);
                }
                this.averageSourceElevation.setValue(avgElev);
                this.averageSourceDistance.setValue(avgDist);
            }
        } else {
            if (!this.invalidDatasetReported) {
                this.getModel().getRuntime().sendInfoMsg("Invalid dataset found while regionalizing data in component " + this.getInstanceName() + ".\nThis might occur if all of the provided values are missing data values.");
                this.invalidDatasetReported = true;
            }
            value = JAMS.getMissingDataValue();
        }
        this.dataValue.setValue(value);
        data = (double[])this.memPool.free((Object)data);
        weights = (double[])this.memPool.free((Object)weights);
        elev = (double[])this.memPool.free((Object)elev);
        if (this.calcStats.getValue()) {
            dist = (double[])this.memPool.free((Object)dist);
        }
    }

    private double getDist(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private double getDistLatLong(double x1, double y1, double x2, double y2) {
        double R = 6378137.0;
        return 6378137.0 * Math.acos(Math.sin(Regionalisation_IDW.rad(y1)) * Math.sin(Regionalisation_IDW.rad(y2)) + Math.cos(Regionalisation_IDW.rad(y1)) * Math.cos(Regionalisation_IDW.rad(y2)) * Math.cos(Regionalisation_IDW.rad(x2) - Regionalisation_IDW.rad(x1)));
    }

    private static double rad(double decDeg) {
        return decDeg * Math.PI / 180.0;
    }

    private static class Station {
        int id;
        double weight;

        public Station(int id, double weight) {
            this.id = id;
            this.weight = weight;
        }
    }
}

