/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="LapseRateAdaptation", author="Sven Kralisch", description="Adaptation of local climate values through elevation difference based on yearly/monthly lapse rates.\n1. Cacluate the elevation difference between modelling unitand climate data source\n2. Adjust the climate value according to the lapse rate and elevation difference", date="2023-02-06", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Fixed bug in fixedMinimum/fixedMaximum evaluation"), @VersionComments.Entry(version="1.0_2", date="2023-02-06", comment="Added option to force keeping zero values")})
public class LapseRateAdaptation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Climate input value")
    public Attribute.Double inputValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Source elevation of the climate input")
    public Attribute.Double sourceElev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity elevation")
    public Attribute.Double entityElev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Lapse rates for 100m elevation difference, given either as a single values or as 12 (monthly) values")
    public Attribute.Double[] lapseRates;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current model time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Calculated output for the modelling entity")
    public Attribute.Double outputValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible minimum value for data set", defaultValue="-Infinity")
    public Attribute.Double fixedMinimum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible maximum value for data set", defaultValue="Infinity")
    public Attribute.Double fixedMaximum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Don't change zero values", defaultValue="False")
    public Attribute.Boolean retainZero;

    public void init() {
        if (this.lapseRates.length != 1 && this.lapseRates.length != 12) {
            this.getModel().getRuntime().sendHalt("Number of lapse rate values must be either 1 or 12!");
        }
    }

    public void run() {
        double input = this.inputValue.getValue();
        if (input != JAMS.getMissingDataValue()) {
            double lapseRate;
            if (this.lapseRates.length > 1) {
                int nowmonth = this.time.get(2);
                lapseRate = this.lapseRates[nowmonth].getValue();
            } else {
                lapseRate = this.lapseRates[0].getValue();
            }
            double elevationdiff = this.sourceElev.getValue() - this.entityElev.getValue();
            double result = input > 0.0 || !this.retainZero.getValue() ? elevationdiff * (lapseRate / 100.0) + input : 0.0;
            result = Math.min(this.fixedMaximum.getValue(), result);
            result = Math.max(this.fixedMinimum.getValue(), result);
            this.outputValue.setValue(result);
            return;
        }
        this.getModel().getRuntime().sendHalt("No station with valid value found. Please check your inputs!");
    }
}

