/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;
import org.unijena.j2k.physicalCalculations.HourlySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

@JAMSComponentDescription(title="CalcHourlyNetRadiation", author="Peter Krause", description="Calculates the hourly net radiation")
public class CalcHourlyNetRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable temperature", unit="\u00b0C")
    public Attribute.Double temp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable relative humidity", unit="%")
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable solar radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable solar radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double extRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable albedo")
    public Attribute.Double albedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute elevation", unit="m")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="calc refET with fixed albedo values", defaultValue="false")
    public Attribute.Boolean refET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily net radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double netRad;

    public void run() {
        double extraterrRadiation = this.extRad.getValue();
        double elev = this.elevation.getValue();
        double alb = this.refET.getValue() ? 0.23 : this.albedo.getValue();
        double temperature = this.temp.getValue();
        double rh = this.rhum.getValue();
        double sRad = this.solRad.getValue();
        double sat_vapour_pressure = ClimatologicalVariables.calc_saturationVapourPressure(temperature);
        double act_vapour_pressure = ClimatologicalVariables.calc_vapourPressure(rh, sat_vapour_pressure);
        double clearSkyRad = SolarRadiationCalculationMethods.calc_ClearSkySolarRadiation(elev, extraterrRadiation);
        double netSWRadiation = SolarRadiationCalculationMethods.calc_NetShortwaveRadiation(alb, sRad);
        double netLWRadiation = HourlySolarRadiationCalculationMethods.calc_HourlyNetLongwaveRadiation(temperature, act_vapour_pressure, sRad, clearSkyRad, 0.3, false);
        double nRad = SolarRadiationCalculationMethods.calc_NetRadiation(netSWRadiation, netLWRadiation);
        this.netRad.setValue(nRad);
    }
}

