/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.potET;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;

@JAMSComponentDescription(title="CalcDailyETP_PenmanMonteith", author="Peter Krause", description="Calculates FAO grass reference ET", version="1.0_0", date="2011-05-30")
public class RefET
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable wind", unit="m/s")
    public Attribute.Double wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable relative humidity", unit="%")
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable net radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state extraterrestric radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double extRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable solar radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute elevation", unit="m")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area", unit="m\u00b2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="potential refET [mm/ timeUnit]")
    public Attribute.Double refET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actual ET [mm/ timeUnit]")
    public Attribute.Double actET;

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double netRad = this.netRad.getValue();
        double temperature = this.tmean.getValue();
        double rhum = this.rhum.getValue();
        double wind = this.wind.getValue();
        double elevation = this.elevation.getValue();
        double area = this.area.getValue();
        double rs = 70.0;
        double ra = 208.0 / wind;
        double abs_temp = ClimatologicalVariables.calc_absTemp(temperature, "degC");
        double delta_s = ClimatologicalVariables.calc_slopeOfSaturationPressureCurve(temperature);
        double pz = ClimatologicalVariables.calc_atmosphericPressure(elevation, abs_temp);
        double est = ClimatologicalVariables.calc_saturationVapourPressure(temperature);
        double ea = ClimatologicalVariables.calc_vapourPressure(rhum, est);
        double latH = ClimatologicalVariables.calc_latentHeatOfVaporization(temperature);
        double psy = ClimatologicalVariables.calc_psyConst(pz, latH);
        double G = this.calc_groundHeatFlux(netRad);
        double tempFactor = 0.0;
        double pET = 0.0;
        double aET = 0.0;
        if (this.tempRes.getValue().equals("d")) {
            tempFactor = 891.0;
        } else if (this.tempRes.getValue().equals("h")) {
            tempFactor = 37.0;
        } else if (this.tempRes.getValue().equals("m")) {
            tempFactor = 891.0;
        }
        pET = (0.408 * delta_s * (netRad - G) + psy * (tempFactor / (temperature + 273.0)) * wind * (est - ea)) / (delta_s + psy * (1.0 + 0.34 * wind));
        pET *= area;
        if (this.time != null && this.tempRes.getValue().equals("m")) {
            int daysInMonth = this.time.getActualMaximum(5);
            pET *= (double)daysInMonth;
        }
        if (pET < 0.0) {
            pET = 0.0;
        }
        this.refET.setValue(pET);
        this.actET.setValue(aET);
    }

    private double calc_groundHeatFlux(double netRad) {
        double g = 0.1 * netRad;
        return g;
    }
}

