/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.interception;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessInterception", author="Peter Krause", description="Calculates daily interception based on DICKINSON 1984", version="1.1_0", date="2012-10-10")
public class J2KProcessInterception
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area", unit="m^2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean tempeature", unit="degC")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable rain", unit="L")
    public Attribute.Double rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable snow", unit="L")
    public Attribute.Double snow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable potET", unit="L")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state variable actET", unit="L")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable LAI")
    public Attribute.Double actLAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Snow parameter TRS", lowerBound=-10.0, upperBound=10.0, defaultValue="0.0", unit="degC")
    public Attribute.Double snow_trs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Snow parameter TRANS", lowerBound=0.0, upperBound=5.0, defaultValue="2.0", unit="K")
    public Attribute.Double snow_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Interception parameter a_rain", lowerBound=0.0, upperBound=5.0, defaultValue="0.2", unit="mm")
    public Attribute.Double a_rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Interception parameter a_snow", lowerBound=0.0, upperBound=5.0, defaultValue="0.5", unit="mm")
    public Attribute.Double a_snow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="state variable net-rain", unit="L")
    public Attribute.Double netRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="state variable net-snow", unit="L")
    public Attribute.Double netSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="state variable throughfall", unit="L")
    public Attribute.Double throughfall;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="state variable dy-interception", unit="L")
    public Attribute.Double interception;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state variable interception storage", unit="L")
    public Attribute.Double intercStorage;

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double deltaIntc;
        double relSnow;
        double relRain;
        double alpha = 0.0;
        double out_throughfall = 0.0;
        double out_interception = 0.0;
        double in_rain = this.rain.getValue();
        double in_snow = this.snow.getValue();
        double in_temp = this.tmean.getValue();
        double in_potETP = this.potET.getValue();
        double in_actETP = this.actET.getValue();
        double in_LAI = this.actLAI.getValue();
        double in_Area = this.area.getValue();
        double out_InterceptionStorage = this.intercStorage.getValue();
        double out_actETP = in_actETP;
        double sum_precip = in_rain + in_snow;
        double deltaETP = in_potETP - in_actETP;
        if (sum_precip > 0.0) {
            relRain = in_rain / sum_precip;
            relSnow = in_snow / sum_precip;
        } else {
            relRain = 1.0;
            relSnow = 0.0;
        }
        alpha = in_temp < this.snow_trs.getValue() - this.snow_trans.getValue() ? this.a_snow.getValue() : this.a_rain.getValue();
        double maxIntcCap = in_LAI * alpha * in_Area;
        if (out_InterceptionStorage > maxIntcCap) {
            out_throughfall = out_InterceptionStorage - maxIntcCap;
            out_InterceptionStorage = maxIntcCap;
        }
        if ((deltaIntc = maxIntcCap - out_InterceptionStorage) > 0.0) {
            if (sum_precip > deltaIntc) {
                out_InterceptionStorage = maxIntcCap;
                out_throughfall += (sum_precip -= deltaIntc);
                out_interception = deltaIntc;
                deltaIntc = 0.0;
            } else {
                out_InterceptionStorage += sum_precip;
                out_interception = sum_precip;
                sum_precip = 0.0;
            }
        } else {
            out_throughfall += sum_precip;
        }
        if (deltaETP > 0.0) {
            if (out_InterceptionStorage > deltaETP) {
                out_InterceptionStorage -= deltaETP;
                out_actETP = in_actETP + deltaETP;
                deltaETP = 0.0;
            } else {
                out_actETP = in_actETP + out_InterceptionStorage;
                out_InterceptionStorage = 0.0;
                deltaETP = 0.0;
            }
        }
        this.netRain.setValue(out_throughfall * relRain);
        this.netSnow.setValue(out_throughfall * relSnow);
        this.actET.setValue(out_actETP);
        this.intercStorage.setValue(out_InterceptionStorage);
        this.interception.setValue(out_interception);
        this.throughfall.setValue(out_throughfall);
    }

    public void cleanup() {
        this.intercStorage.setValue(0.0);
    }
}

