/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import org.unijena.j2k.statistics.Regression;

@JAMSComponentDescription(title="CalcAbsoluteHumidity", author="Peter Krause", description="Calculates absolute humidity of relative humidity and temperatureat climate station location. If either rhum or temp is missing ahum will no be calculated.", version="1.1_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.1_0", comment="Changed selection procedure for temperature station. Now, the closest station will be used. If its distance to the rhum station is > 0, an info message will be issued.")})
public class CalcAbsoluteHumidity
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the relative humidity values")
    public Attribute.DoubleArray rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temperature for the computation")
    public Attribute.DoubleArray temperature;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="absolute humidity values")
    public Attribute.DoubleArray ahum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of temperature station elevations")
    public Attribute.DoubleArray tempElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of temperature station's x coordinate")
    public Attribute.DoubleArray tempXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of temperature station's y coordinate")
    public Attribute.DoubleArray tempYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of rhum station elevations")
    public Attribute.DoubleArray rhumElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of rhum station's x coordinate")
    public Attribute.DoubleArray rhumXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of rhum station's y coordinate")
    public Attribute.DoubleArray rhumYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="rsqr for ahum stations")
    public Attribute.DoubleArray regCoeffAhum;

    public void init() {
    }

    public void run() {
        int i;
        double[] rhum = this.rhum.getValue();
        double[] temperature = this.temperature.getValue();
        double[] ahum = new double[rhum.length];
        double[] rhumElev = new double[rhum.length];
        double[] rhumX = new double[rhum.length];
        double[] rhumY = new double[rhum.length];
        double[] tempElev = new double[temperature.length];
        double[] tempX = new double[temperature.length];
        double[] tempY = new double[temperature.length];
        for (i = 0; i < rhum.length; ++i) {
            rhumElev[i] = this.rhumElevation.getValue()[i];
            rhumX[i] = this.rhumXCoord.getValue()[i];
            rhumY[i] = this.rhumYCoord.getValue()[i];
        }
        for (i = 0; i < temperature.length; ++i) {
            tempElev[i] = this.tempElevation.getValue()[i];
            tempX[i] = this.tempXCoord.getValue()[i];
            tempY[i] = this.tempYCoord.getValue()[i];
        }
        for (int r = 0; r < ahum.length; ++r) {
            if (rhum[r] > 0.0) {
                int t;
                double rhumTemp = 0.0;
                double absDist = -1.0;
                int minT = 0;
                double minDist = Double.MAX_VALUE;
                for (t = 0; absDist != 0.0 && t < temperature.length; ++t) {
                    absDist = Math.sqrt(Math.pow(tempX[t] - rhumX[r], 2.0) + Math.pow(tempY[t] - rhumY[r], 2.0));
                    if (!(absDist < minDist)) continue;
                    minDist = absDist;
                    minT = t;
                }
                if (absDist != 0.0) {
                    t = minT + 1;
                    this.getModel().getRuntime().println("Attention: using remote temperature station for ahum calculation! Distance: " + minDist + "m", 2);
                }
                if ((rhumTemp = temperature[t - 1]) != JAMS.getMissingDataValue()) {
                    double est = 6.11 * Math.exp(17.62 * rhumTemp / (243.12 + rhumTemp));
                    double maxHum = est * 216.7 / (rhumTemp + 273.15);
                    ahum[r] = maxHum * (rhum[r] / 100.0);
                    continue;
                }
                ahum[r] = JAMS.getMissingDataValue();
                continue;
            }
            ahum[r] = JAMS.getMissingDataValue();
        }
        this.ahum.setValue(ahum);
        this.regCoeffAhum.setValue(Regression.calcLinReg(this.rhumElevation.getValue(), this.ahum.getValue()));
    }

    public void cleanup() {
    }
}

