/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.testFunctions;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Hosaki Test Function", author="Peter Krause", description="A test function for optimizers which has a global and a local optimum")
public class ThreeFactorLinearTestFunction
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter c")
    public Attribute.Double paraC;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter d")
    public Attribute.Double paraD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter e")
    public Attribute.Double paraE;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the input value")
    public Attribute.Double input;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the simulated response")
    public Attribute.Double simulation;

    public void init() {
    }

    public void run() {
        double c = this.paraC.getValue();
        double d = this.paraD.getValue();
        double e = this.paraE.getValue();
        double y = (c + c * d + c * d * e) * this.input.getValue();
        this.simulation.setValue(y);
    }
}

