/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.testFunctions;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Test Functions from Dixon Test", author="Christian Fischer", description="Test functions for optimizers from http://www-optima.amp.i.kyoto-u.ac.jp/member/student/hedar/Hedar_files/TestGO.htm")
public class DixonTestSet
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X1")
    public Attribute.Double paraX1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X2")
    public Attribute.Double paraX2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X3")
    public Attribute.Double paraX3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X2")
    public Attribute.Double paraX4;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X1")
    public Attribute.Double paraX5;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X2")
    public Attribute.Double paraX6;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X3")
    public Attribute.Double paraX7;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X2")
    public Attribute.Double paraX8;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X1")
    public Attribute.Double paraX9;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X2")
    public Attribute.Double paraX10;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X3")
    public Attribute.Double paraX11;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X2")
    public Attribute.Double paraX12;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X1")
    public Attribute.Double paraX13;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X2")
    public Attribute.Double paraX14;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X3")
    public Attribute.Double paraX15;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X2")
    public Attribute.Double paraX16;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="parameter X2")
    public Attribute.Integer function;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="function y")
    public Attribute.Double yVal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="function y")
    public Attribute.Double option;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="function y")
    public Attribute.Integer n;

    public void run() {
        if (this.function == null) {
            this.getModel().getRuntime().sendHalt("parameter function must be specified!");
            return;
        }
        double x1 = 0.0;
        double x2 = 0.0;
        double x3 = 0.0;
        double x4 = 0.0;
        double x5 = 0.0;
        double x6 = 0.0;
        double x7 = 0.0;
        double x8 = 0.0;
        double x9 = 0.0;
        double x10 = 0.0;
        double x11 = 0.0;
        double x12 = 0.0;
        double x13 = 0.0;
        double x14 = 0.0;
        double x15 = 0.0;
        double x16 = 0.0;
        int n = this.n.getValue();
        if (this.paraX1 != null) {
            x1 = this.paraX1.getValue();
        }
        if (this.paraX2 != null) {
            x2 = this.paraX2.getValue();
        }
        if (this.paraX3 != null) {
            x3 = this.paraX3.getValue();
        }
        if (this.paraX4 != null) {
            x4 = this.paraX4.getValue();
        }
        if (this.paraX5 != null) {
            x5 = this.paraX5.getValue();
        }
        if (this.paraX6 != null) {
            x6 = this.paraX6.getValue();
        }
        if (this.paraX7 != null) {
            x7 = this.paraX7.getValue();
        }
        if (this.paraX8 != null) {
            x8 = this.paraX8.getValue();
        }
        if (this.paraX9 != null) {
            x9 = this.paraX9.getValue();
        }
        if (this.paraX10 != null) {
            x10 = this.paraX10.getValue();
        }
        if (this.paraX11 != null) {
            x11 = this.paraX11.getValue();
        }
        if (this.paraX12 != null) {
            x12 = this.paraX12.getValue();
        }
        if (this.paraX13 != null) {
            x13 = this.paraX13.getValue();
        }
        if (this.paraX14 != null) {
            x14 = this.paraX14.getValue();
        }
        if (this.paraX15 != null) {
            x15 = this.paraX15.getValue();
        }
        if (this.paraX16 != null) {
            x16 = this.paraX16.getValue();
        }
        double[] x = new double[]{x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15, x16};
        double r = 0.0;
        switch (this.function.getValue()) {
            case 1: {
                double a = 20.0;
                double b = 0.2;
                double c = Math.PI * 2;
                double s1 = 0.0;
                double s2 = 0.0;
                for (int i = 0; i < n; ++i) {
                    s1 += x[i] * x[i];
                    s2 += Math.cos(Math.PI * 2 * x[i]);
                }
                r = -a * Math.exp(-b * Math.sqrt(s1 /= (double)n)) - Math.exp(s2 /= (double)n) + a + Math.exp(1.0);
                break;
            }
            case 1001: {
                double a = 20.0;
                double b = 0.2;
                double c = Math.PI * 2;
                double shift = 0.3333333333333333;
                double s1 = 0.0;
                double s2 = 0.0;
                for (int i = 0; i < n; ++i) {
                    s1 += (x[i] + shift) * (x[i] + shift);
                    s2 += Math.cos(c * (x[i] + shift));
                }
                r = -a * Math.exp(-b * Math.sqrt(s1 /= (double)n)) - Math.exp(s2 /= (double)n) + a + Math.exp(1.0);
                break;
            }
            case 2: {
                r = Math.pow(1.5 - x1 * (1.0 - x2), 2.0) + Math.pow(2.25 - x1 * (1.0 - x2 * x2), 2.0) + Math.pow(2.625 - x1 * (1.0 - x2 * x2 * x2), 2.0);
                break;
            }
            case 3: {
                r = x1 * x1 + 2.0 * x2 * x2 - 0.3 * Math.cos(Math.PI * 3 * x1) - 0.4 * Math.cos(Math.PI * 4 * x2) + 0.7;
                break;
            }
            case 4: {
                r = x1 * x1 + 2.0 * x2 * x2 - 0.3 * Math.cos(Math.PI * 3 * x1) * Math.cos(Math.PI * 4 * x2) + 0.3;
                break;
            }
            case 5: {
                r = x1 * x1 + 2.0 * x2 * x2 - 0.3 * Math.cos(Math.PI * 3 * x1 + Math.PI * 4 * x2) + 0.3;
                break;
            }
            case 6: {
                r = Math.pow(x1 + 2.0 * x2 - 7.0, 2.0) + Math.pow(2.0 * x1 + x2 - 5.0, 2.0);
                break;
            }
            case 7: {
                r = Math.pow(x2 - 0.12918450914398066 * x1 * x1 + 5.0 * x1 / Math.PI - 6.0, 2.0) + 9.602112642270262 * Math.cos(x1) + 10.0;
                break;
            }
            case 8: {
                r = 100.0 * Math.pow(x1 * x1 - x2, 2.0) + Math.pow(x1 - 1.0, 2.0) + Math.pow(x3 - 1.0, 2.0) + 90.0 * Math.pow(x3 * x3 - x4, 2.0) + 10.1 * (Math.pow(x2 - 1.0, 2.0) + Math.pow(x4 - 1.0, 2.0)) + 19.8 * (1.0 - x2) * (x4 - 1.0);
                break;
            }
            case 9: {
                r = Math.pow(x1 - 1.0, 2.0);
                for (int i = 1; i < n; ++i) {
                    r += (double)(i + 1) * Math.pow(2.0 * x[i] * x[i] - x[i - 1], 2.0);
                }
                break;
            }
            case 10: {
                r = -1.0;
                double tmp = 0.0;
                for (int i = 0; i < n; ++i) {
                    r *= Math.cos(x[i]);
                    tmp -= Math.pow(x[i] - Math.PI, 2.0);
                }
                r *= Math.exp(tmp);
                break;
            }
            case 11: {
                r = (1.0 + Math.pow(x1 + x2 + 1.0, 2.0) * (19.0 - 14.0 * x1 + 3.0 * x1 * x1 - 14.0 * x2 + 6.0 * x1 * x2 + 3.0 * x2 * x2)) * (30.0 + Math.pow(2.0 * x1 - 3.0 * x2, 2.0) * (18.0 - 32.0 * x1 + 12.0 * x1 * x1 + 48.0 * x2 - 36.0 * x1 * x2 + 27.0 * x2 * x2));
                break;
            }
            case 12: {
                double s = 0.0;
                double p = 1.0;
                double fr = 4000.0;
                for (int i = 0; i < n; ++i) {
                    s += x[i] * x[i];
                    p += Math.cos(x[i] / Math.sqrt(i + 1));
                }
                r = s / fr - p + 1.0;
                break;
            }
            case 1012: {
                double s = 0.0;
                double p = 1.0;
                double fr = 4000.0;
                double shift = 3.0303030303030303;
                for (int i = 0; i < n; ++i) {
                    s += (x[i] + shift) * (x[i] + shift);
                    p += Math.cos((x[i] + shift) / Math.sqrt(i + 1));
                }
                r = s / fr - p + 1.0;
                break;
            }
            case 13: {
                double[][] a = new double[4][3];
                double[] c = new double[4];
                double[][] p = new double[4][3];
                for (int i = 0; i < 2; ++i) {
                    a[2 * i + 0][0] = 3.0;
                    a[2 * i + 1][0] = 0.1;
                    a[2 * i + 0][1] = 10.0;
                    a[2 * i + 1][1] = 10.0;
                    a[2 * i + 0][2] = 30.0;
                    a[2 * i + 1][2] = 35.0;
                }
                c[0] = 1.0;
                c[1] = 1.2;
                c[2] = 3.0;
                c[3] = 3.2;
                p[0][0] = 0.3689;
                p[0][1] = 0.117;
                p[0][2] = 0.2673;
                p[1][0] = 0.4699;
                p[1][1] = 0.4387;
                p[1][2] = 0.747;
                p[2][0] = 0.1091;
                p[2][1] = 0.8732;
                p[2][2] = 0.5547;
                p[3][0] = 0.03815;
                p[3][1] = 0.5743;
                p[3][2] = 0.8828;
                double s = 0.0;
                x = new double[]{x1, x2, x3};
                for (int i = 0; i < 4; ++i) {
                    double sm = 0.0;
                    for (int j = 0; j < 3; ++j) {
                        sm += a[i][j] * (x[j] - p[i][j]) * (x[j] - p[i][j]);
                    }
                    s += c[i] * Math.exp(-sm);
                }
                r = -s;
                break;
            }
            case 14: {
                r = 1.0316285 + 4.0 * x1 * x1 - 2.1 * Math.pow(x1, 4.0) + Math.pow(x1, 6.0) / 3.0 + x1 * x2 - 4.0 * x2 * x2 + 4.0 * Math.pow(x2, 4.0);
                break;
            }
            case 15: {
                double[] z = new double[n];
                for (int i = 0; i < n; ++i) {
                    z[i] = 1.0 + (x[i] - 1.0) / 4.0;
                }
                double s = Math.sin(Math.PI * z[0]) * Math.sin(Math.PI * z[0]);
                for (int i = 0; i < n - 1; ++i) {
                    s += (z[i] - 1.0) * (z[i] - 1.0) * (1.0 + 10.0 * Math.pow(Math.sin(Math.PI * z[i] + 1.0), 2.0));
                }
                r = s + (z[n - 1] - 1.0) * (z[n - 1] - 1.0) * 2.0 * (1.0 + Math.pow(Math.sin(Math.PI * 2 * z[n - 1]), 2.0));
                break;
            }
            case 16: {
                r = 0.26 * (x1 * x1 + x2 * x2) - 0.48 * x1 * x2;
                break;
            }
            case 17: {
                r = 0.0;
                for (int i = 0; i < n; ++i) {
                    r -= Math.sin(x[i]) * Math.pow((double)(i + 1) * Math.sin(x[i] * x[i] / Math.PI), 20.0);
                }
                break;
            }
            case 18: {
                double s_out = 0.0;
                double b = 0.0;
                for (int k = 0; k < n; ++k) {
                    double s_in = 0.0;
                    for (int j = 0; j < n; ++j) {
                        s_in += (Math.pow(j + 1, k + 1) + b) * (Math.pow(x[j] / (double)(j + 1), k + 1) - 1.0);
                    }
                    s_out += s_in * s_in;
                }
                r = s_out;
                break;
            }
            case 19: {
                x = new double[]{x1, x2, x3, x4};
                double[] fvec = new double[]{x[0] + 10.0 * x[1], Math.sqrt(5.0) * (x[2] - x[3]), (x[1] - 2.0 * x[2]) * (x[1] - 2.0 * x[2]), Math.sqrt(10.0) * (x[0] - x[3]) * (Math.sqrt(10.0) * (x[0] - x[3]))};
                r = fvec[0] * fvec[0] + fvec[1] * fvec[1] + fvec[2] * fvec[2] + fvec[3] * fvec[3];
                break;
            }
            case 20: {
                x = new double[]{x1, x2, x3, x4};
                double[] b = new double[]{8.0, 18.0, 44.0, 114.0};
                double s_out = 0.0;
                for (int k = 0; k < 4; ++k) {
                    double s_in = 0.0;
                    for (int j = 0; j < 4; ++j) {
                        s_in += Math.pow(x[j], k + 1);
                    }
                    s_out += (s_in - b[k]) * (s_in - b[k]);
                }
                r = s_out;
                break;
            }
            case 21: {
                r = 100.0 * ((x1 * x1 - x2) * (x1 * x1 - x2) + (x1 - 1.0) * (x1 - 1.0));
                break;
            }
            case 22: {
                double s = 0.0;
                for (int i = 0; i < n; ++i) {
                    s -= x[i] * Math.sin(Math.sqrt(Math.abs(x[i])));
                }
                r = 418.9829 * (double)n + s;
                break;
            }
            case 23: {
                double m = 10.0;
                x = new double[]{x1, x2, x3, x4};
                double[][] a = new double[10][4];
                a[0][0] = 4.0;
                a[0][1] = 4.0;
                a[0][2] = 4.0;
                a[0][3] = 4.0;
                a[1][0] = 1.0;
                a[1][1] = 1.0;
                a[1][2] = 1.0;
                a[1][3] = 1.0;
                a[2][0] = 8.0;
                a[2][1] = 8.0;
                a[2][2] = 8.0;
                a[2][3] = 8.0;
                a[3][0] = 6.0;
                a[3][1] = 6.0;
                a[3][2] = 6.0;
                a[3][3] = 6.0;
                a[4][0] = 3.0;
                a[4][1] = 7.0;
                a[4][2] = 3.0;
                a[4][3] = 7.0;
                a[5][0] = 2.0;
                a[5][1] = 9.0;
                a[5][2] = 2.0;
                a[5][3] = 9.0;
                a[6][0] = 5.0;
                a[6][1] = 5.0;
                a[6][2] = 3.0;
                a[6][3] = 3.0;
                a[7][0] = 8.0;
                a[7][1] = 1.0;
                a[7][2] = 8.0;
                a[7][3] = 1.0;
                a[8][0] = 6.0;
                a[8][1] = 2.0;
                a[8][2] = 6.0;
                a[8][3] = 2.0;
                a[9][0] = 7.0;
                a[9][1] = 3.6;
                a[9][2] = 7.0;
                a[9][3] = 3.6;
                double[] c = new double[]{0.1, 0.2, 0.2, 0.4, 0.4, 0.6, 0.3, 0.7, 0.5, 0.5};
                double s = 0.0;
                int j = 0;
                while ((double)j < m) {
                    double p = 0.0;
                    for (int i = 0; i < 4; ++i) {
                        p += (x[i] - a[j][i]) * (x[i] - a[j][i]);
                    }
                    s += 1.0 / (p + c[j]);
                    ++j;
                }
                r = -s;
                break;
            }
            case 24: {
                double s1 = 0.0;
                double s2 = 0.0;
                for (int i = 1; i < 6; ++i) {
                    s1 += (double)i * Math.cos((double)(i + 1) * x1 + (double)i);
                    s2 += (double)i * Math.cos((double)(i + 1) * x2 + (double)i);
                }
                r = s1 * s2;
                break;
            }
            case 25: {
                r = 0.0;
                for (int i = 0; i < n; ++i) {
                    r += x[i] * x[i];
                }
                break;
            }
            case 1025: {
                r = 0.0;
                double shift = 0.3333333333333333;
                for (int i = 0; i < n; ++i) {
                    r += (x[i] + shift) * (x[i] + shift);
                }
                break;
            }
            case 26: {
                r = 0.0;
                for (int i = 0; i < n; ++i) {
                    r += (double)(i + 1) * x[i] * x[i];
                }
                break;
            }
            case 1026: {
                r = 0.0;
                double shift = 0.3333333333333333;
                for (int i = 0; i < n; ++i) {
                    r += (double)(i + 1) * (x[i] + shift) * (x[i] + shift);
                }
                break;
            }
            case 27: {
                int i;
                double s1 = 0.0;
                double s2 = 0.0;
                for (i = 0; i < n; ++i) {
                    s1 += (x[i] - 1.0) * (x[i] - 1.0);
                }
                for (i = 1; i < n; ++i) {
                    s2 += x[i] * x[i - 1];
                }
                r = s1 - s2;
                break;
            }
            case 28: {
                int i;
                double s1 = 0.0;
                double s2 = 0.0;
                for (i = 0; i < n; ++i) {
                    s1 += x[i] * x[i];
                }
                for (i = 0; i < n; ++i) {
                    s2 += 0.5 * (double)(i + 1) * x[i];
                }
                double p2s2 = s2 * s2;
                r = s1 + p2s2 + p2s2 * p2s2;
                break;
            }
            case 1028: {
                int i;
                double s1 = 0.0;
                double s2 = 0.0;
                double shift = 0.3333333333333333;
                for (i = 0; i < n; ++i) {
                    s1 += (x[i] + shift) * (x[i] + shift);
                }
                for (i = 0; i < n; ++i) {
                    s2 += 0.5 * (double)(i + 1) * (x[i] + shift);
                }
                double p2s2 = s2 * s2;
                r = s1 + p2s2 + p2s2 * p2s2;
                break;
            }
            case 29: {
                r = x[0] + 2.0 * x[1];
                break;
            }
            case 30: {
                r = 1.0;
                for (int i = 0; i < n; ++i) {
                    double ai = ((double)(i + 1) - 2.0) / 2.0;
                    double s = (Math.abs(4.0 * x[i] - 2.0) + ai) / (1.0 + ai);
                    r *= s;
                }
                break;
            }
        }
        this.yVal.setValue(r);
    }
}

