/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.testFunctions;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;

@JAMSComponentDescription(title="dataWriter", author="Peter Krause", description="The data writer for the test cases model")
public class DataWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="full qualified path name for model output file")
    public Attribute.String outFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the current date provided by the temporal context")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the input value of the respective time step")
    public Attribute.Double input;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the simulation value of the respective time step")
    public Attribute.Double simulation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the observation value of the respective time step")
    public Attribute.Double observation;
    private GenericDataWriter writer;

    public void init() {
        this.writer = new GenericDataWriter(this.outFileName.getValue());
        this.writer.addComment("test output");
        this.writer.addComment("");
        this.writer.addColumn("time");
        this.writer.addColumn("input");
        this.writer.addColumn("simulation");
        this.writer.addColumn("observation");
        this.writer.writeHeader();
    }

    public void run() {
        this.writer.addData((Object)this.time);
        this.writer.addData((Object)this.input);
        this.writer.addData((Object)this.simulation);
        this.writer.addData((Object)this.observation);
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            System.out.println(jre.getMessage());
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

