/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.testFunctions;

import jams.data.Attribute;
import jams.io.GenericDataReader;
import jams.io.JAMSTableDataArray;
import jams.io.JAMSTableDataConverter;
import jams.io.JAMSTableDataStore;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

@JAMSComponentDescription(title="DataReader", author="Peter Krause", description="Component which reads input and output data for test cases")
public class DataReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="A full qualfied file name pointing to a testFunctioncompliant data file")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Internal variable name for the input value ofeach time step")
    public Attribute.Double input;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Internal variable name for the observed value ofeach time step")
    public Attribute.Double observation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time interval of current temporal context")
    public Attribute.TimeInterval timeInterval;
    private JAMSTableDataStore store;
    public HashMap dataMap = new HashMap();
    private String[] md;
    private JAMSTableDataArray da;

    public void init() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.fileName.getValue()));
            String line = reader.readLine();
            StringTokenizer strTok = new StringTokenizer(line, "\t");
            String desc = strTok.nextToken();
            String start = strTok.nextToken();
            Attribute.Calendar startTime = this.parseTime(start);
            line = reader.readLine();
            strTok = new StringTokenizer(line, "\t");
            desc = strTok.nextToken();
            String end = strTok.nextToken();
            Attribute.Calendar endTime = this.parseTime(end);
            line = reader.readLine();
            strTok = new StringTokenizer(line, "\t");
            int cols = strTok.countTokens() - 1;
            this.md = new String[cols];
            strTok.nextToken();
            for (int i = 0; i < cols; ++i) {
                this.md[i] = strTok.nextToken();
            }
            this.store = new GenericDataReader(this.fileName.getValue(), true, 1, 4);
            if (this.timeInterval != null) {
                if (this.timeInterval.getStart().before(startTime) || this.timeInterval.getEnd().after(endTime)) {
                    this.getModel().getRuntime().sendHalt("TSData start and end time of " + this.fileName.getValue() + " do not match current temporal context!");
                }
                int timeUnit = this.timeInterval.getTimeUnit();
                Attribute.Calendar tiStart = this.timeInterval.getStart();
                Attribute.Calendar date = this.getModel().getRuntime().getDataFactory().createCalendar();
                date.set(tiStart.get(1), tiStart.get(2), tiStart.get(5), startTime.get(11), startTime.get(12), startTime.get(13));
                while (startTime.before(date) && this.store.hasNext()) {
                    this.da = this.store.getNext();
                    if (timeUnit == 6) {
                        startTime.add(5, 1);
                        continue;
                    }
                    if (timeUnit == 11) {
                        startTime.add(11, 1);
                        continue;
                    }
                    if (timeUnit != 2) continue;
                    startTime.add(2, 1);
                }
                this.getModel().getRuntime().println(this.fileName.getValue() + " data file initalised ... ", 2);
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
    }

    public void run() {
        JAMSTableDataArray da = this.store.getNext();
        double[] vals = JAMSTableDataConverter.toDouble((JAMSTableDataArray)da);
        for (int i = 0; i < this.md.length; ++i) {
            this.dataMap.put(this.md[i], vals[i]);
        }
        this.input.setValue(((Double)this.dataMap.get("input")).doubleValue());
        this.observation.setValue(((Double)this.dataMap.get("observation")).doubleValue());
    }

    public void cleanup() {
        this.store.close();
    }

    private Attribute.Calendar parseTime(String timeString) {
        String[] timeArray = new String[]{"1", "1", "0"};
        StringTokenizer st = new StringTokenizer(timeString, ".-/ :");
        int n = st.countTokens();
        for (int i = 0; i < n; ++i) {
            timeArray[i] = st.nextToken();
        }
        Attribute.Calendar cal = this.getModel().getRuntime().getDataFactory().createCalendar();
        cal.setValue(timeArray[2] + "-" + timeArray[1] + "-" + timeArray[0]);
        return cal;
    }
}

