/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.soilWater;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InitGeoFemSoilWaterStates", author="Peter Krause", description="Defines soil water attributes for each HRU")
public class InitGeoFemSoilWaterStates
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current hru entity")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="field capacity adaptation factor")
    public Attribute.Double FCAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU statevar rooting depth")
    public Attribute.Double rootDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU attribute maximum MPS")
    public Attribute.Double maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var actual MPS")
    public Attribute.Double actMPS;

    public void init() {
    }

    public void run() {
        Attribute.Entity entity = this.entities.getCurrent();
        double rootDepth = this.rootDepth.getValue();
        double mxMPS = 0.0;
        String aNameFC = "fc_";
        int d = 0;
        while ((double)d < rootDepth) {
            int count = d + 1;
            String mpsDesc = aNameFC + count;
            double mpsVal = entity.getDouble(mpsDesc);
            mxMPS += mpsVal;
            ++d;
        }
        mxMPS *= this.area.getValue();
        this.maxMPS.setValue(mxMPS *= this.FCAdaptation.getValue());
    }

    public void cleanup() {
    }
}

