/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;

@JAMSComponentDescription(title="GlacierModule", author="Peter Krause", description="Simple process module for glacier simulation. The module calculates snow accumulation by a temperature threshold approach and snow melt from the glacier with a day-degree-approach. Melt from the glacier is implementing by the melt formula according to Hock (1998, 1999) in a simple and a more complex form. The simple form needs temperature only whereasthe complex form needs also radiation.Glacier runoff is calculated by the outflow from two reservoirs. The firstrepresents snow falling on the glacier whereas the second represents theice of the glacier. The same idea was implemented in WasimETH first.Changed:meltTemp is derived from the average of Tmax and Tmeanintegrating melt correction factor to include slope and aspect in radiation based model//s.nepal., to be changed")
public class GlacierModuleHimalaya
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the tmax input", unit="?C")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the tmean input", unit="?C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the actual rainfall", unit="L/m^2")
    public Attribute.Double rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute slope")
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute elevation")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Elevation Threshold for debris covered Glacier")
    public Attribute.Double elevationThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Slope Threshold for debris covered Glacier")
    public Attribute.Double slopeThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="the total precip", unit="L/m^2")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the actual global radiation", unit="MJ/day")
    public Attribute.Double radiation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actual snow storage", unit="L/m^2")
    public Attribute.Double snowTotSWE;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area", unit="m^2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow runoff of time step before", unit="L")
    public Attribute.Double snowRunofftm1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow melt from glacier areas", unit="L")
    public Attribute.Double snowMelt_G;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain runoff of time step before", unit="L")
    public Attribute.Double rainRunofftm1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="ice runoff of time step before", unit="L")
    public Attribute.Double iceRunofftm1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total runoff of unit", unit="L")
    public Attribute.Double glacierRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total direct runoff of unit", unit="L")
    public Attribute.Double dirQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="runoff from glacier ice melt", unit="L")
    public Attribute.Double iceRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="runoff from snow rain", unit="L")
    public Attribute.Double rainRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="remaining storage (only for balance calculation)", unit="L")
    public Attribute.Double glacStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="generalised melt factor ice")
    public Attribute.Double meltFactorIce;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="day degree factor for snow")
    public Attribute.Double ddfSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="day degree factor for ice")
    public Attribute.Double ddfIce;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="melt coefficient for ice")
    public Attribute.Double alphaIce;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="routing coefficient for snow")
    public Attribute.Double kSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="routing coefficient for ice")
    public Attribute.Double kIce;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="routing coefficient for rain")
    public Attribute.Double kRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="threshold temperature for icemelt")
    public Attribute.Double tbase;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="melt formula [1 = simple, 2 = complex]")
    public Attribute.Integer meltFormula;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="debris factor based on the debris cover on glaciers")
    public Attribute.Double debrisFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state var slope-aspect-correction-factor")
    public Attribute.Double actSlAsCf;

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double snowStor = this.snowTotSWE.getValue();
        double tmax = this.tmax.getValue();
        double tmean = this.tmean.getValue();
        double SAC = this.actSlAsCf.getValue();
        double meltTemp = (tmax + tmean) / 2.0;
        double n = 0.0;
        if (this.tempRes.getValue().equals("d")) {
            n = 1.0;
        } else if (this.tempRes.getValue().equals("h")) {
            n = 24.0;
        } else if (this.tempRes.getValue().equals("m")) {
            n = 0.0;
        }
        double iceMelt = 0.0;
        double totalMelt = 0.0;
        if (meltTemp > this.tbase.getValue() && snowStor == 0.0) {
            if (this.meltFormula.getValue() == 1) {
                iceMelt = 1.0 / n * this.ddfIce.getValue() * (meltTemp - this.tbase.getValue());
                iceMelt *= this.area.getValue();
            }
            if (this.meltFormula.getValue() == 2) {
                iceMelt = 1.0 / n * (this.meltFactorIce.getValue() + this.alphaIce.getValue() * this.radiation.getValue()) * (meltTemp - this.tbase.getValue());
                iceMelt *= this.area.getValue();
            }
        } else {
            iceMelt = 0.0;
        }
        if (this.slope.getValue() < this.slopeThreshold.getValue() && this.elevation.getValue() < this.elevationThreshold.getValue()) {
            iceMelt -= iceMelt * this.debrisFactor.getValue() / 10.0;
        }
        totalMelt = this.snowMelt_G.getValue() + (iceMelt *= SAC);
        double allIn = this.snowMelt_G.getValue() + this.rain.getValue();
        double q_snow = this.snowRunofftm1.getValue() * Math.exp(-1.0 / this.kSnow.getValue()) + this.snowMelt_G.getValue() * (1.0 - Math.exp(-1.0 / this.kSnow.getValue()));
        double q_rain = this.rainRunofftm1.getValue() * Math.exp(-1.0 / this.kRain.getValue()) + this.rain.getValue() * (1.0 - Math.exp(-1.0 / this.kRain.getValue()));
        double q_ice = this.iceRunofftm1.getValue() * Math.exp(-1.0 / this.kIce.getValue()) + iceMelt * (1.0 - Math.exp(-1.0 / this.kIce.getValue()));
        double tot_q = q_ice + q_snow + q_rain;
        this.glacStorage.setValue(allIn - q_snow - q_rain);
        this.snowRunofftm1.setValue(q_snow);
        this.rainRunofftm1.setValue(q_rain);
        this.iceRunofftm1.setValue(q_ice);
        this.rainRunoff.setValue(q_rain);
        this.glacierRunoff.setValue(tot_q);
        this.dirQ.setValue(tot_q);
        this.iceRunoff.setValue(q_ice);
        this.snowTotSWE.setValue(snowStor);
        this.snowMelt_G.setValue(q_snow);
        double precip = this.precip.getValue();
    }

    public void cleanup() throws IOException {
    }
}

