/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import org.unijena.j2k.routing.PolygonRasterMap;

@JAMSComponentDescription(title="J2KRasterRouting", author="Christin Michel", description="Wandelt Rasterebene wieder in HRU-Aufl?sung um")
public class RasterToHRU
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.Entity information;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.Entity fuellstand;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage")
    public Attribute.Double hruID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD1 storage")
    public Attribute.Double actRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD2 storage")
    public Attribute.Double actRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG1 storage")
    public Attribute.Double actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage")
    public Attribute.Double actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD1 storage")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD2 storage")
    public Attribute.Double inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG1 storage")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage", defaultValue="0")
    public Attribute.Double totalToHRU;
    double value = 0.0;

    public double Raster_to_HRU(PolygonRasterMap map, double[][] fuellstand_raster, int[][] flgew1) {
        ArrayList<Point> list = map.rasterIDs;
        map.storage = 0.0;
        for (Point p : list) {
            if (flgew1[p.x][p.y] != -1) continue;
            map.storage += fuellstand_raster[p.x][p.y];
            this.value += fuellstand_raster[p.x][p.y];
            fuellstand_raster[p.x][p.y] = 0.0;
        }
        return map.storage;
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double ID = this.hruID.getValue();
        this.value = this.totalToHRU.getValue();
        double[][] RD1raster = null;
        double[][] RD2raster = null;
        double[][] RG1raster = null;
        double[][] RG2raster = null;
        int[][] actflgew1 = null;
        double[][] RD1_vraster = null;
        double[][] RD2_vraster = null;
        double[][] RG1_vraster = null;
        double[][] RG2_vraster = null;
        HashMap acthrulist = new HashMap();
        try {
            acthrulist = (HashMap)this.information.getObject("hrulist");
            RD1raster = (double[][])this.fuellstand.getObject("RD1_raster");
            RD2raster = (double[][])this.fuellstand.getObject("RD2_raster");
            RG1raster = (double[][])this.fuellstand.getObject("RG1_raster");
            RG2raster = (double[][])this.fuellstand.getObject("RG2_raster");
            actflgew1 = (int[][])this.information.getObject("flgew1");
            RD1_vraster = (double[][])this.information.getObject("RD1_vraster");
            RD2_vraster = (double[][])this.information.getObject("RD2_vraster");
            RG1_vraster = (double[][])this.information.getObject("RG1_vraster");
            RG2_vraster = (double[][])this.information.getObject("RG2_vraster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        PolygonRasterMap hruRasterMap = (PolygonRasterMap)acthrulist.get((int)ID);
        double RD1act = this.inRD1.getValue() + this.Raster_to_HRU(hruRasterMap, RD1raster, actflgew1);
        double RD2act = this.inRD2.getValue() + this.Raster_to_HRU(hruRasterMap, RD2raster, actflgew1);
        double RG1act = this.inRG1.getValue() + this.Raster_to_HRU(hruRasterMap, RG1raster, actflgew1);
        double RG2act = this.inRG2.getValue() + this.Raster_to_HRU(hruRasterMap, RG2raster, actflgew1);
        this.information.setObject("RD1_vraster", (Object)RD1_vraster);
        this.information.setObject("RD2_vraster", (Object)RD2_vraster);
        this.information.setObject("RG1_vraster", (Object)RG1_vraster);
        this.information.setObject("RG2_vraster", (Object)RG2_vraster);
        this.inRD1.setValue(RD1act);
        this.inRD2.setValue(RD2act);
        this.inRG1.setValue(RG1act);
        this.inRG2.setValue(RG2act);
        this.totalToHRU.setValue(this.value);
    }
}

