/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.awt.Point;
import java.util.ArrayList;

@JAMSComponentDescription(title="J2KKinematicWaveReachRouting", author="Christin Michel", description="")
public class KinematicWaveReachRouting
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.Entity information;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="")
    public Attribute.Entity fuellstand;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RG2 storage")
    public Attribute.Double catchmentSimRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time bin of simulation")
    public Attribute.Double timescale;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="spatial grid resolution")
    public Attribute.Double modelrastersize;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RD1 storage")
    public Attribute.Double catchmentRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RD2 storage")
    public Attribute.Double catchmentRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RG1 storage")
    public Attribute.Double catchmentRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RG2 storage")
    public Attribute.Double catchmentRG2;

    public double calcFlowVelocity(double A, double width, double slope, double rough, double secondsOfTimeStep) {
        double afv = 1.0;
        double veloc = 0.0;
        double rh = A / (width + 2.0 * (A / width));
        boolean cont = true;
        while (cont) {
            veloc = rough * Math.pow(rh, 0.6666666666666666) * Math.sqrt(slope);
            if (Math.abs(veloc - afv) > 0.001) {
                afv = veloc;
                rh = this.calcHydraulicRadius(afv, A, width);
                continue;
            }
            cont = false;
            afv = veloc;
        }
        return afv;
    }

    public double calcHydraulicRadius(double v, double q, double width) {
        double A = q / v;
        double rh = A / (width + 2.0 * (A / width));
        return rh;
    }

    public Point[][] Pfad(double[][] dgm, Point[][] routing, int actx, int acty, double zahl, double timestep, double[][] fliessrichtung, double[][] flow_velocity, int startx, int starty, double rastersize) {
        Point p = new Point();
        if (dgm[actx][acty] != -1.0 && zahl < timestep && actx > 0 && actx < fliessrichtung.length - 1 && acty > 0 && acty < fliessrichtung[0].length - 1) {
            zahl += rastersize / flow_velocity[actx][acty];
            if (fliessrichtung[actx][acty] == 1.0) {
                routing = this.Pfad(dgm, routing, actx + 1, acty, zahl, timestep, fliessrichtung, flow_velocity, startx, starty, rastersize);
            }
            if (fliessrichtung[actx][acty] == 2.0) {
                routing = this.Pfad(dgm, routing, actx + 1, acty + 1, zahl, timestep, fliessrichtung, flow_velocity, startx, starty, rastersize);
            }
            if (fliessrichtung[actx][acty] == 4.0) {
                routing = this.Pfad(dgm, routing, actx, acty + 1, zahl, timestep, fliessrichtung, flow_velocity, startx, starty, rastersize);
            }
            if (fliessrichtung[actx][acty] == 8.0) {
                routing = this.Pfad(dgm, routing, actx - 1, acty + 1, zahl, timestep, fliessrichtung, flow_velocity, startx, starty, rastersize);
            }
            if (fliessrichtung[actx][acty] == 16.0) {
                routing = this.Pfad(dgm, routing, actx - 1, acty, zahl, timestep, fliessrichtung, flow_velocity, startx, starty, rastersize);
            }
            if (fliessrichtung[actx][acty] == 32.0) {
                routing = this.Pfad(dgm, routing, actx - 1, acty - 1, zahl, timestep, fliessrichtung, flow_velocity, startx, starty, rastersize);
            }
            if (fliessrichtung[actx][acty] == 64.0) {
                routing = this.Pfad(dgm, routing, actx, acty - 1, zahl, timestep, fliessrichtung, flow_velocity, startx, starty, rastersize);
            }
            if (fliessrichtung[actx][acty] == 128.0) {
                routing = this.Pfad(dgm, routing, actx + 1, acty - 1, zahl, timestep, fliessrichtung, flow_velocity, startx, starty, rastersize);
            }
            if (fliessrichtung[actx][acty] == 0.0) {
                p.x = actx;
                p.y = acty;
                routing[startx][starty] = p;
            }
        } else {
            p.x = actx;
            p.y = acty;
            routing[startx][starty] = p;
        }
        return routing;
    }

    public Point[][] Pfad1(double[][] flgew, Point[][] routing, double[][] fliessrichtung, double[][] flow_velocity, double rastersize, double timestep) {
        for (int i = 1; i < flgew.length - 1; ++i) {
            for (int j = 1; j < flgew[0].length - 1; ++j) {
                if (flgew[i][j] == -1.0) continue;
                routing = this.Pfad(flgew, routing, i, j, 0.0, timestep, fliessrichtung, flow_velocity, i, j, rastersize);
            }
        }
        return routing;
    }

    public void init() throws Attribute.Entity.NoSuchAttributeException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        int laenge2;
        int j;
        double[][] RD1raster = null;
        double[][] RD2raster = null;
        double[][] RG1raster = null;
        double[][] RG2raster = null;
        double[][] fuellstand_reaches = null;
        double[][] Q_In = null;
        double[][] actfliessrichtung = null;
        double[][] actdgm = null;
        double[][] actflgew1 = null;
        double[][] flow_velocity = null;
        double[][] actreachinfo = null;
        double[][] acthangneigung = null;
        double timestep = this.timescale.getValue();
        if (timestep == 1.0) {
            timestep = 86400.0;
        }
        if (timestep == 2.0) {
            timestep = 3600.0;
        }
        int rastersize = 100;
        try {
            Q_In = (double[][])this.fuellstand.getObject("Qin_reaches");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            fuellstand_reaches = (double[][])this.fuellstand.getObject("fuellstand_reaches");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RD1raster = (double[][])this.fuellstand.getObject("RD1_raster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RD2raster = (double[][])this.fuellstand.getObject("RD2_raster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RG1raster = (double[][])this.fuellstand.getObject("RG1_raster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RG2raster = (double[][])this.fuellstand.getObject("RG2_raster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            actfliessrichtung = (double[][])this.information.getObject("fliessrichtung");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            actdgm = (double[][])this.information.getObject("dgm");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            acthangneigung = (double[][])this.information.getObject("hangneigung");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        ArrayList actreachlist = new ArrayList();
        try {
            actreachlist = (ArrayList)this.information.getObject("reachlist");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            actflgew1 = (double[][])this.information.getObject("flgew1");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            actreachinfo = (double[][])this.information.getObject("reachinfo");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Point p = new Point();
        double act_speicher = 0.0;
        flow_velocity = new double[actdgm.length][actdgm[0].length];
        boolean laenge3 = false;
        Point p1 = new Point();
        double S_start = 0.0;
        double Q_out = 0.0;
        double Q_in = 0.0;
        double A_start = 0.0;
        double A_end = 0.0;
        double S_end = 0.0;
        double q = 0.0;
        double Pegel_out = 0.0;
        int laenge1 = actreachlist.size();
        for (j = 0; j < laenge1; ++j) {
            laenge2 = ((ArrayList)actreachlist.get(j)).size();
            act_speicher = 0.0;
            for (int l = 1; l < laenge2; ++l) {
                p = (Point)((ArrayList)actreachlist.get(j)).get(l);
                act_speicher += fuellstand_reaches[p.x][p.y];
            }
            p = (Point)((ArrayList)actreachlist.get(j)).get(0);
            double A = act_speicher / (double)(rastersize * laenge2);
            double veloc = this.calcFlowVelocity(A, actreachinfo[2][p.x], actreachinfo[1][p.x], actreachinfo[3][p.x], timestep);
            for (int l = 1; l < laenge2; ++l) {
                p = (Point)((ArrayList)actreachlist.get(j)).get(l);
                flow_velocity[p.x][p.y] = veloc;
            }
        }
        Point[][] Routing = new Point[actdgm.length][actdgm[0].length];
        Routing = this.Pfad1(actflgew1, Routing, actfliessrichtung, flow_velocity, rastersize, timestep);
        for (j = 0; j < laenge1; ++j) {
            p1 = (Point)((ArrayList)actreachlist.get(j)).get(0);
            laenge2 = ((ArrayList)actreachlist.get(j)).size();
            for (int l = 1; l < laenge2; ++l) {
                p = (Point)((ArrayList)actreachlist.get(j)).get(l);
                Point next = Routing[p.x][p.y];
                Q_in = fuellstand_reaches[p.x][p.y];
                S_start = Q_In[p.x][p.y];
                Q_In[p.x][p.y] = 0.0;
                A_start = S_start / (actreachinfo[2][p1.x] * (double)rastersize * 1000.0);
                S_end = S_start + Q_in + q;
                A_end = S_end / (actreachinfo[2][p1.x] * (double)rastersize * 1000.0);
                Q_out = q + Q_in + (-A_start + A_end) / timestep;
                fuellstand_reaches[p.x][p.y] = S_end - Q_out;
                Q_In[next.x][next.y] = Q_In[next.x][next.y] + Q_out;
            }
        }
        Point pegel = new Point();
        for (int i = 0; i < actflgew1.length; ++i) {
            for (j = 0; j < actflgew1[0].length; ++j) {
                if (actflgew1[i][j] != 0.0) continue;
                pegel.x = i;
                pegel.y = j;
            }
        }
        Pegel_out = Q_In[pegel.x][pegel.y];
        Q_In[pegel.x][pegel.y] = 0.0;
        this.catchmentSimRunoff.setValue(Pegel_out);
        this.fuellstand.setObject("fuellstand_reaches", (Object)fuellstand_reaches);
        this.fuellstand.setObject("Qin_reaches", (Object)Q_In);
        this.catchmentRD1.setValue(7.0);
        this.catchmentRD2.setValue(7.0);
        this.catchmentRG1.setValue(7.0);
        this.catchmentRG2.setValue(7.0);
    }

    public void cleanup() {
    }
}

