/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessMultiRouting_h_cb", author="Peter Krause, Holm Kipka, Bjoern Pfennig, Manfred Fink", description="Passes the output of the entities as input to the respective reach or unit including")
public class J2KProcessMultiRouting_h_cb
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current hru entity")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of reservoir objects")
    public Attribute.EntityCollection reservoirs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD1 inflow")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD2 inflow")
    public Attribute.DoubleArray inRD2_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD2 inflow")
    public Attribute.DoubleArray outRD2_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG1 inflow")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG2 inflow")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar groundwater excess", defaultValue="0")
    public Attribute.Double inGWExcess;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD1 outflow")
    public Attribute.Double outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG1 outflow")
    public Attribute.Double outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG2 outflow")
    public Attribute.Double outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="An- bzw. Ausschalten des Moduls")
    public Attribute.Boolean cbModulAktiv;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="An- bzw. Ausschalten des Moduls")
    public Attribute.Double cbModulRD2out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="An- bzw. Ausschalten des Moduls")
    public Attribute.Double modulRD2out;
    double[][] fracOut;
    double[] percOut;
    boolean modulCBaktiv;

    public void init() {
        this.modulCBaktiv = this.cbModulAktiv.getValue();
    }

    public void run() {
        double RG1in;
        double RD1in;
        int a;
        Attribute.Entity entity = this.entities.getCurrent();
        Attribute.Entity[] toPolyArray = (Attribute.Entity[])entity.getObject("to_poly");
        Attribute.Entity[] toReachArray = (Attribute.Entity[])entity.getObject("to_reach");
        Attribute.Entity toReservoir = null;
        Double[] polyWeightsArray = (Double[])entity.getObject("to_poly_weights");
        Double[] reachWeightsArray = (Double[])entity.getObject("to_reach_weights");
        try {
            toReservoir = (Attribute.Entity)entity.getObject("to_reservoir");
        }
        catch (Attribute.Entity.NoSuchAttributeException e) {
            toReservoir = null;
        }
        double RD1out = this.outRD1.getValue();
        double[] RD2out = this.outRD2_h.getValue();
        double RG1out = this.outRG1.getValue();
        double RG2out = this.outRG2.getValue();
        this.modulRD2out.setValue(0.0);
        this.cbModulRD2out.setValue(0.0);
        boolean keinziel = false;
        double[] srcDepth = ((Attribute.DoubleArray)entity.getObject("depth_h")).getValue();
        int srcHors = srcDepth.length;
        if (toPolyArray.length > 0) {
            for (a = 0; a < toPolyArray.length; ++a) {
                if (toPolyArray[a] == null) continue;
                Attribute.Entity toPoly = toPolyArray[a];
                double polyWeight = polyWeightsArray[a];
                RD1in = toPoly.getDouble("inRD1");
                double[] recDepth = ((Attribute.DoubleArray)toPoly.getObject("depth_h")).getValue();
                int recHors = recDepth.length;
                double[] RD2in = new double[recHors];
                this.calcParts(srcDepth, recDepth);
                double[] RD2Array = ((Attribute.DoubleArray)toPoly.getObject("inRD2_h")).getValue();
                RG1in = toPoly.getDouble("inRG1");
                for (int j = 0; j < recHors; ++j) {
                    RD2in[j] = RD2Array[j];
                    for (int i = 0; i < srcHors; ++i) {
                        RD2in[j] = RD2in[j] + RD2out[i] * polyWeight * this.fracOut[i][j];
                        RG1in += RD2out[i] * polyWeight * this.percOut[i];
                    }
                }
                int n = recHors - 1;
                RD2in[n] = RD2in[n] + this.inGWExcess.getValue();
                if (recHors == 0) {
                    System.out.println("RecHors is null at entity " + entity.getObject("ID"));
                }
                double RG2in = toPoly.getDouble("inRG2");
                RG1in += RG1out * polyWeight;
                RG2in += RG2out * polyWeight;
                Attribute.DoubleArray rdA = (Attribute.DoubleArray)toPoly.getObject("inRD2_h");
                rdA.setValue(RD2in);
                toPoly.setDouble("inRD1", RD1in += RD1out * polyWeight);
                toPoly.setObject("inRD2_h", (Object)rdA);
                toPoly.setDouble("inRG1", RG1in);
                toPoly.setDouble("inRG2", RG2in);
                keinziel = true;
            }
        }
        if (toReachArray.length > 0) {
            Attribute.Entity toReach;
            double abflussCBReach_akt;
            if (this.modulCBaktiv && (abflussCBReach_akt = entity.getDouble("cbAbfussReach")) > 0.0) {
                double[] anteileKomponentenCB = (double[])entity.getObject("cbAnteileKomponenten");
                toReach = toReachArray[0];
                double RD1in2 = toReach.getDouble("inRD1");
                double RD2in = toReach.getDouble("inRD2");
                RG1in = toReach.getDouble("inRG1");
                toReach.setDouble("inRD1", RD1in2 += anteileKomponentenCB[0] * abflussCBReach_akt);
                toReach.setDouble("inRD2", RD2in += anteileKomponentenCB[1] * abflussCBReach_akt);
                this.cbModulRD2out.setValue(RD2in);
                toReach.setDouble("inRG1", RG1in += anteileKomponentenCB[2] * abflussCBReach_akt);
                entity.setDouble("cbAbfussReach", 0.0);
            }
            for (a = 0; a < toReachArray.length; ++a) {
                toReach = toReachArray[a];
                double reachWeight = reachWeightsArray[a];
                RD1in = toReach.getDouble("inRD1");
                double RD2in = toReach.getDouble("inRD2");
                RD2in = toReach.getDouble("inRD2");
                for (int h = 0; h < srcHors; ++h) {
                    RD2in += RD2out[h] * reachWeight;
                }
                double RG1in2 = toReach.getDouble("inRG1");
                double RG2in = toReach.getDouble("inRG2");
                toReach.setDouble("inRD1", RD1in += RD1out * reachWeight);
                toReach.setDouble("inRD2", RD2in += this.inGWExcess.getValue());
                this.modulRD2out.setValue(RD2in);
                toReach.setDouble("inRG1", RG1in2 += RG1out * reachWeight);
                toReach.setDouble("inRG2", RG2in += RG2out * reachWeight);
                keinziel = true;
            }
        }
        RD1out = 0.0;
        for (int i = 0; i < srcHors; ++i) {
            RD2out[i] = 0.0;
        }
        RG1out = 0.0;
        RG2out = 0.0;
        this.outRD1.setValue(RD1out);
        this.outRD2_h.setValue(RD2out);
        this.outRG1.setValue(RG1out);
        this.outRG2.setValue(RG2out);
        this.inGWExcess.setValue(0.0);
        if (!keinziel) {
            this.getModel().getRuntime().println("Current entity ID: " + (int)entity.getDouble("ID") + " has no receiver.");
        }
    }

    public void cleanup() {
    }

    private void calcParts(double[] depthSrc, double[] depthRec) {
        int i;
        int srcHorizons = depthSrc.length;
        int recHorizons = depthRec.length;
        double[] upBoundSrc = new double[srcHorizons];
        double[] lowBoundSrc = new double[srcHorizons];
        double low = 0.0;
        double up = 0.0;
        for (int i2 = 0; i2 < srcHorizons; ++i2) {
            upBoundSrc[i2] = up = (low += depthSrc[i2]) - depthSrc[i2];
            lowBoundSrc[i2] = low;
        }
        double[] upBoundRec = new double[recHorizons];
        double[] lowBoundRec = new double[recHorizons];
        low = 0.0;
        up = 0.0;
        for (i = 0; i < recHorizons; ++i) {
            upBoundRec[i] = up = (low += depthRec[i]) - depthRec[i];
            lowBoundRec[i] = low;
        }
        this.fracOut = new double[depthSrc.length][depthRec.length];
        this.percOut = new double[depthSrc.length];
        for (i = 0; i < depthSrc.length; ++i) {
            double sumFrac = 0.0;
            for (int j = 0; j < depthRec.length; ++j) {
                if (!(lowBoundSrc[i] > upBoundRec[j]) || !(upBoundSrc[i] < lowBoundRec[j])) continue;
                double relDepth = Math.min(lowBoundSrc[i], lowBoundRec[j]) - Math.max(upBoundSrc[i], upBoundRec[j]);
                double fracDepth = relDepth / depthSrc[i];
                sumFrac += fracDepth;
                this.fracOut[i][j] = fracDepth;
            }
            this.percOut[i] = 1.0 - sumFrac;
        }
    }
}

