/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessRouting", author="Peter Krause", description="Passes the output of the entities as input to the respective reach or unit")
public class J2KProcessMultiRouting
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current hru entity")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of reservoir objects")
    public Attribute.EntityCollection reservoirs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD1 inflow")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD2 inflow")
    public Attribute.Double inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG1 inflow")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG2 inflow")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar groundwater excess")
    public Attribute.Double inGWExcess;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD1 outflow")
    public Attribute.Double outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD2 outflow")
    public Attribute.Double outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG1 outflow")
    public Attribute.Double outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG2 outflow")
    public Attribute.Double outRG2;

    public void init() {
    }

    public void run() {
        double RG2in;
        double RG1in;
        double RD2in;
        double RD1in;
        int a;
        Attribute.Entity entity = this.entities.getCurrent();
        Attribute.Entity[] toPolyArray = (Attribute.Entity[])entity.getObject("to_poly");
        Attribute.Entity[] toReachArray = (Attribute.Entity[])entity.getObject("to_reach");
        Attribute.Entity toReservoir = null;
        Double[] polyWeightsArray = (Double[])entity.getObject("to_poly_weights");
        Double[] reachWeightsArray = (Double[])entity.getObject("to_reach_weights");
        try {
            toReservoir = (Attribute.Entity)entity.getObject("to_reservoir");
        }
        catch (Attribute.Entity.NoSuchAttributeException e) {
            toReservoir = null;
        }
        double RD1out = this.outRD1.getValue();
        double RD2out = this.outRD2.getValue();
        double RG1out = this.outRG1.getValue();
        double RG2out = this.outRG2.getValue();
        boolean keinziel = false;
        if (toPolyArray.length > 0) {
            for (a = 0; a < toPolyArray.length; ++a) {
                if (toPolyArray[a] == null) continue;
                Attribute.Entity toPoly = toPolyArray[a];
                double polyWeight = polyWeightsArray[a];
                RD1in = toPoly.getDouble("inRD1");
                RD2in = toPoly.getDouble("inRD2");
                RG1in = toPoly.getDouble("inRG1");
                RG2in = toPoly.getDouble("inRG2");
                RD2in += RD2out * polyWeight;
                toPoly.setDouble("inRD1", RD1in += RD1out * polyWeight);
                toPoly.setDouble("inRD2", RD2in += this.inGWExcess.getValue());
                toPoly.setDouble("inRG1", RG1in += RG1out * polyWeight);
                toPoly.setDouble("inRG2", RG2in += RG2out * polyWeight);
                keinziel = true;
            }
        }
        if (toReachArray.length > 0) {
            for (a = 0; a < toReachArray.length; ++a) {
                Attribute.Entity toReach = toReachArray[a];
                double reachWeight = reachWeightsArray[a];
                RD1in = toReach.getDouble("inRD1");
                RD2in = toReach.getDouble("inRD2");
                RG1in = toReach.getDouble("inRG1");
                RG2in = toReach.getDouble("inRG2");
                RD2in += RD2out * reachWeight;
                toReach.setDouble("inRD1", RD1in += RD1out * reachWeight);
                toReach.setDouble("inRD2", RD2in += this.inGWExcess.getValue());
                toReach.setDouble("inRG1", RG1in += RG1out * reachWeight);
                toReach.setDouble("inRG2", RG2in += RG2out * reachWeight);
                keinziel = true;
            }
        }
        RD1out = 0.0;
        RD2out = 0.0;
        RG1out = 0.0;
        RG2out = 0.0;
        this.outRD1.setValue(RD1out);
        this.outRD2.setValue(RD2out);
        this.outRG1.setValue(RG1out);
        this.outRG2.setValue(RG2out);
        this.inGWExcess.setValue(0.0);
        if (!keinziel) {
            this.getModel().getRuntime().println("Current entity ID: " + (int)entity.getDouble("ID") + " has no receiver.");
        }
    }

    public void cleanup() {
    }
}

