/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import org.unijena.j2k.routing.PolygonRasterMap;

@JAMSComponentDescription(title="J2KRasterRouting", author="Christin Michel", description="")
public class HruToRaster
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Reach statevar RD1 outflow")
    public Attribute.Double outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Reach statevar RD2 outflow")
    public Attribute.Double outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Reach statevar RG1 outflow")
    public Attribute.Double outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Reach statevar RG2 outflow")
    public Attribute.Double outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="test variable", defaultValue="0")
    public Attribute.Double totalToRaster;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage")
    public Attribute.Double hruID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.Entity information;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="")
    public Attribute.Entity fuellstand;
    double value;

    public void HRU_to_Raster(PolygonRasterMap map, double wert, double[][] fuellstand, double[][] verteilung) {
        ArrayList<Point> list = map.rasterIDs;
        double durchschnitt = wert / (double)list.size();
        for (Point p : list) {
            fuellstand[p.x][p.y] = durchschnitt;
            this.value += durchschnitt;
        }
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double ID = this.hruID.getValue();
        this.value = this.totalToRaster.getValue();
        double[][] RD1raster = null;
        double[][] RD2raster = null;
        double[][] RG1raster = null;
        double[][] RG2raster = null;
        double[][] RD1_vraster = null;
        double[][] RD2_vraster = null;
        double[][] RG1_vraster = null;
        double[][] RG2_vraster = null;
        HashMap acthrulist = new HashMap();
        try {
            acthrulist = (HashMap)this.information.getObject("hrulist");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RD1raster = (double[][])this.fuellstand.getObject("RD1_raster");
            RD2raster = (double[][])this.fuellstand.getObject("RD2_raster");
            RG1raster = (double[][])this.fuellstand.getObject("RG1_raster");
            RG2raster = (double[][])this.fuellstand.getObject("RG2_raster");
            RD1_vraster = (double[][])this.information.getObject("RD1_vraster");
            RD2_vraster = (double[][])this.information.getObject("RD1_vraster");
            RG1_vraster = (double[][])this.information.getObject("RD1_vraster");
            RG2_vraster = (double[][])this.information.getObject("RD1_vraster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        PolygonRasterMap hruRasterMap = (PolygonRasterMap)acthrulist.get((int)ID);
        double RD1out = this.outRD1.getValue();
        double RD2out = this.outRD2.getValue();
        double RG1out = this.outRG1.getValue();
        double RG2out = this.outRG2.getValue();
        this.outRD1.setValue(0.0);
        this.outRD2.setValue(0.0);
        this.outRG1.setValue(0.0);
        this.outRG2.setValue(0.0);
        this.HRU_to_Raster(hruRasterMap, RD1out, RD1raster, RD1_vraster);
        this.HRU_to_Raster(hruRasterMap, RD2out, RD2raster, RD2_vraster);
        this.HRU_to_Raster(hruRasterMap, RG1out, RG1raster, RG1_vraster);
        this.HRU_to_Raster(hruRasterMap, RG2out, RG2raster, RG2_vraster);
        this.totalToRaster.setValue(this.value);
    }
}

