/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.unijena.j2k.routing.PolygonRasterMap;

public class CreateGrid
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="spatial grid resolution")
    public Attribute.Double gridresolution;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time bin of simulation")
    public Attribute.Double timescale;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The current hru entity")
    public Attribute.Entity information;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The current hru entity")
    public Attribute.Entity fuellstand;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach statevar simulated Runoff")
    public Attribute.Double RD1_Weg_Koeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach statevar simulated Runoff")
    public Attribute.Double RD2_Weg_Koeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach statevar simulated Runoff")
    public Attribute.Double RG1_Weg_Koeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach statevar simulated Runoff")
    public Attribute.Double RG2_Weg_Koeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.String hruRasterFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.String dgmFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.String flgewFile;
    final int MAGIC_NUMBER = 123456;
    int externalGridCells = 0;

    public int getRasterSize(File path) {
        double cellsize = 0.0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(path));
            int datafound = 0;
            while (datafound < 1) {
                String line = reader.readLine();
                StringTokenizer st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (!tok.contains("cellsize")) continue;
                    cellsize = new Double(st.nextToken());
                    ++datafound;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        return (int)cellsize;
    }

    public double[][] readRasterFile(File path) {
        int ncols = 0;
        int nrows = 0;
        double nodatavalue = 0.0;
        double[][] grid = null;
        double lowest_value = Double.POSITIVE_INFINITY;
        try {
            StringTokenizer st;
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(path));
            int datafound = 0;
            while (datafound < 5) {
                line = reader.readLine();
                st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (tok.contains("ncols")) {
                        ncols = new Integer(st.nextToken());
                        ++datafound;
                    }
                    if (tok.contains("nrows")) {
                        nrows = new Integer(st.nextToken());
                        ++datafound;
                    }
                    if (tok.contains("xllcorner")) {
                        double x11corner = new Double(st.nextToken());
                        ++datafound;
                    }
                    if (tok.contains("yllcorner")) {
                        double y11corner = new Double(st.nextToken());
                        ++datafound;
                    }
                    if (!tok.contains("cellsize")) continue;
                    double cellsize = new Double(st.nextToken());
                    ++datafound;
                }
            }
            grid = new double[ncols][nrows];
            int x = 0;
            int y = 0;
            boolean firsttoken = true;
            block4: while ((line = reader.readLine()) != null) {
                st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    if (y >= nrows) {
                        System.out.println("error to many entrys");
                        continue block4;
                    }
                    String tok = st.nextToken();
                    if (firsttoken) {
                        firsttoken = false;
                        if (tok.contains("NODATA_value")) {
                            nodatavalue = new Double(st.nextToken());
                        }
                        if (!st.hasMoreTokens()) continue;
                        tok = st.nextToken();
                    }
                    grid[x][y] = new Double(tok);
                    if (Math.abs(grid[x][y] - nodatavalue) < 1.0E-4) {
                        grid[x][y] = -1.0;
                    }
                    if (grid[x][y] != -1.0 && grid[x][y] < lowest_value) {
                        lowest_value = grid[x][y];
                    }
                    if (++x < ncols) continue;
                    x = 0;
                    ++y;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        return grid;
    }

    public void Ausgabe(Object[][] fuellstand, String path) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(path));
            for (int spalte = 0; spalte < fuellstand[0].length; ++spalte) {
                for (int zeile = 0; zeile < fuellstand.length; ++zeile) {
                    writer.write(fuellstand[zeile][spalte] + " ");
                }
                writer.write("\n");
            }
            writer.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public double[][] calcSlope(double[][] dgm, int[][] fliessrichtung, int cellsize) {
        double[][] slope = new double[dgm.length][dgm[0].length];
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        for (int i = 0; i < dgm.length; ++i) {
            Arrays.fill(slope[i], -1.0);
            if (i == 0 || i == dgm.length - 1) continue;
            for (int j = 1; j < dgm[i].length - 1; ++j) {
                if (dgm[i][j] == -1.0) continue;
                int flr = fliessrichtung[i][j];
                if (flr == 1) {
                    c = cellsize;
                    a = dgm[i][j] - dgm[i + 1][j];
                    b = Math.sqrt(a * a + c * c);
                }
                if (flr == 2) {
                    c = Math.sqrt(2.0) * (double)cellsize;
                    a = dgm[i][j] - dgm[i + 1][j + 1];
                    b = Math.sqrt(a * a + c * c);
                }
                if (flr == 4) {
                    c = cellsize;
                    a = dgm[i][j] - dgm[i][j + 1];
                    b = Math.sqrt(a * a + c * c);
                }
                if (flr == 8) {
                    c = Math.sqrt(2.0) * (double)cellsize;
                    a = dgm[i][j] - dgm[i - 1][j + 1];
                    b = Math.sqrt(a * a + c * c);
                }
                if (flr == 16) {
                    c = cellsize;
                    a = dgm[i][j] - dgm[i - 1][j];
                    b = Math.sqrt(a * a + c * c);
                }
                if (flr == 32) {
                    c = Math.sqrt(2.0) * (double)cellsize;
                    a = dgm[i][j] - dgm[i - 1][j - 1];
                    b = Math.sqrt(a * a + c * c);
                }
                if (flr == 64) {
                    c = cellsize;
                    a = dgm[i][j] - dgm[i][j - 1];
                    b = Math.sqrt(a * a + c * c);
                }
                if (flr == 128) {
                    c = Math.sqrt(2.0) * (double)cellsize;
                    a = dgm[i][j] - dgm[i + 1][j - 1];
                    b = Math.sqrt(a * a + c * c);
                }
                double alpha = Math.asin(a / b);
                if ((alpha = 360.0 * alpha / (Math.PI * 2)) < 0.1) {
                    alpha = 0.1;
                }
                slope[i][j] = alpha;
            }
        }
        return slope;
    }

    public int[][] calculateFlowDirection(double[][] dgm) {
        int[][] fliessrichtung = new int[dgm.length][dgm[0].length];
        for (int i = 1; i < dgm.length - 1; ++i) {
            for (int j = 1; j < dgm[0].length - 1; ++j) {
                int count = 10000;
                if (dgm[i][j + 1] != -1.0 && dgm[i][j + 1] < (double)count) {
                    count = (int)dgm[i][j + 1];
                    fliessrichtung[i][j] = 4;
                }
                if (dgm[i + 1][j + 1] != -1.0 && dgm[i + 1][j + 1] < (double)count) {
                    count = (int)dgm[i + 1][j + 1];
                    fliessrichtung[i][j] = 2;
                }
                if (dgm[i + 1][j] != -1.0 && dgm[i + 1][j] < (double)count) {
                    count = (int)dgm[i + 1][j];
                    fliessrichtung[i][j] = 1;
                }
                if (dgm[i + 1][j - 1] != -1.0 && dgm[i + 1][j - 1] < (double)count) {
                    count = (int)dgm[i + 1][j - 1];
                    fliessrichtung[i][j] = 128;
                }
                if (dgm[i][j - 1] != -1.0 && dgm[i][j - 1] < (double)count) {
                    count = (int)dgm[i][j - 1];
                    fliessrichtung[i][j] = 64;
                }
                if (dgm[i - 1][j - 1] != -1.0 && dgm[i - 1][j - 1] < (double)count) {
                    count = (int)dgm[i - 1][j - 1];
                    fliessrichtung[i][j] = 32;
                }
                if (dgm[i - 1][j] != -1.0 && dgm[i - 1][j] < (double)count) {
                    count = (int)dgm[i - 1][j];
                    fliessrichtung[i][j] = 16;
                }
                if (dgm[i - 1][j + 1] == -1.0 || !(dgm[i - 1][j + 1] < (double)count)) continue;
                count = (int)dgm[i - 1][j + 1];
                fliessrichtung[i][j] = 8;
            }
        }
        return fliessrichtung;
    }

    public int[][][] fliessgewaesser(int i, int j, int ID, int[][][] fliess) {
        int l;
        int k;
        boolean count = false;
        int richtung = 0;
        int x = 0;
        int y = 0;
        for (k = -1; k < 2; ++k) {
            for (l = -1; l < 2; ++l) {
                if (k + l == 0 || k + l == 2 || k + l == -2 || fliess[1][i][j] != ID || fliess[1][i + k][j + l] != ID) continue;
                if (k == 1 && l == 0) {
                    richtung = 1;
                }
                if (k == 0 && l == 1) {
                    richtung = 4;
                }
                if (k == -1 && l == 0) {
                    richtung = 16;
                }
                if (k == 0 && l == -1) {
                    richtung = 64;
                }
                x = i + k;
                y = j + l;
                fliess[0][i][j] = richtung;
                fliess[1][i][j] = -1;
                fliess = this.fliessgewaesser(x, y, ID, fliess);
                k = 5;
                l = 5;
            }
        }
        for (k = -1; k < 2; ++k) {
            for (l = -1; l < 2; ++l) {
                if (k == 0 && l == 0 || k + l == 1 || k + l == -1 || fliess[1][i][j] != ID || fliess[1][i + k][j + l] != ID) continue;
                if (k == 1 && l == 1) {
                    richtung = 2;
                }
                if (k == -1 && l == 1) {
                    richtung = 8;
                }
                if (k == -1 && l == -1) {
                    richtung = 32;
                }
                if (k == 1 && l == -1) {
                    richtung = 128;
                }
                x = i + k;
                y = j + l;
                fliess[0][i][j] = richtung;
                fliess[1][i][j] = -1;
                fliess = this.fliessgewaesser(x, y, ID, fliess);
                k = 5;
                l = 5;
            }
        }
        for (k = -1; k < 2; ++k) {
            for (l = -1; l < 2; ++l) {
                if (k == 0 && l == 0 || fliess[1][i + k][j + l] == -1 || fliess[1][i][j] != ID) continue;
                if (k == 1 && l == 0) {
                    richtung = 1;
                }
                if (k == 1 && l == 1) {
                    richtung = 2;
                }
                if (k == 0 && l == 1) {
                    richtung = 4;
                }
                if (k == -1 && l == 1) {
                    richtung = 8;
                }
                if (k == -1 && l == 0) {
                    richtung = 16;
                }
                if (k == -1 && l == -1) {
                    richtung = 32;
                }
                if (k == 0 && l == -1) {
                    richtung = 64;
                }
                if (k == 1 && l == -1) {
                    richtung = 128;
                }
                x = i + k;
                y = j + l;
                fliess[0][i][j] = richtung;
                fliess[1][i][j] = -1;
                k = 5;
                l = 5;
            }
        }
        return fliess;
    }

    public int[][] flgew(double[][] dgm, int[][] fliessrichtung, int[][] flgew, int[][] flgew1, int[][] hruraster) {
        int j;
        int i;
        int[][][] fliess = new int[2][fliessrichtung.length][fliessrichtung[0].length];
        int count = 1;
        int anzahl = 0;
        for (int i2 = 0; i2 < fliessrichtung.length; ++i2) {
            for (int j2 = 0; j2 < fliessrichtung[0].length; ++j2) {
                fliess[0][i2][j2] = fliessrichtung[i2][j2];
                fliess[1][i2][j2] = flgew[i2][j2];
            }
        }
        int zahl = 1;
        while (zahl != 0) {
            zahl = 0;
            for (i = 1; i < fliessrichtung.length - 1; ++i) {
                for (j = 1; j < fliessrichtung[0].length - 1; ++j) {
                    if (fliess[1][i][j] == -1 || fliess[1][i][j] == 123456) continue;
                    count = 0;
                    if (fliess[1][i + 1][j] == -1) {
                        ++count;
                    }
                    if (fliess[1][i - 1][j] == -1) {
                        ++count;
                    }
                    if (fliess[1][i][j + 1] == -1) {
                        ++count;
                    }
                    if (fliess[1][i][j - 1] == -1) {
                        ++count;
                    }
                    if (fliess[1][i + 1][j + 1] == -1) {
                        ++count;
                    }
                    if (fliess[1][i + 1][j - 1] == -1) {
                        ++count;
                    }
                    if (fliess[1][i - 1][j + 1] == -1) {
                        ++count;
                    }
                    if (fliess[1][i - 1][j - 1] == -1) {
                        ++count;
                    }
                    if (count == 7) {
                        fliess = this.fliessgewaesser(i, j, fliess[1][i][j], fliess);
                        ++zahl;
                        ++anzahl;
                    }
                    if (count == 6 && fliess[1][i + 1][j + 1] != -1 && fliess[1][i][j + 1] != -1) {
                        fliess = this.fliessgewaesser(i, j, fliess[1][i][j], fliess);
                        ++zahl;
                        ++anzahl;
                    }
                    if (count == 6 && fliess[1][i + 1][j + 1] != -1 && fliess[1][i + 1][j] != -1) {
                        fliess = this.fliessgewaesser(i, j, fliess[1][i][j], fliess);
                        ++zahl;
                        ++anzahl;
                    }
                    if (count == 6 && fliess[1][i + 1][j] != -1 && fliess[1][i + 1][j - 1] != -1) {
                        fliess = this.fliessgewaesser(i, j, fliess[1][i][j], fliess);
                        ++zahl;
                        ++anzahl;
                    }
                    if (count == 6 && fliess[1][i + 1][j - 1] != -1 && fliess[1][i][j - 1] != -1) {
                        fliess = this.fliessgewaesser(i, j, fliess[1][i][j], fliess);
                        ++zahl;
                        ++anzahl;
                    }
                    if (count == 6 && fliess[1][i - 1][j - 1] != -1 && fliess[1][i][j - 1] != -1) {
                        fliess = this.fliessgewaesser(i, j, fliess[1][i][j], fliess);
                        ++zahl;
                        ++anzahl;
                    }
                    if (count == 6 && fliess[1][i - 1][j] != -1 && fliess[1][i - 1][j - 1] != -1) {
                        fliess = this.fliessgewaesser(i, j, fliess[1][i][j], fliess);
                        ++zahl;
                        ++anzahl;
                    }
                    if (count == 6 && fliess[1][i - 1][j + 1] != -1 && fliess[1][i - 1][j] != -1) {
                        fliess = this.fliessgewaesser(i, j, fliess[1][i][j], fliess);
                        ++zahl;
                        ++anzahl;
                    }
                    if (count != 6 || fliess[1][i - 1][j + 1] == -1 || fliess[1][i][j + 1] == -1) continue;
                    fliess = this.fliessgewaesser(i, j, fliess[1][i][j], fliess);
                    ++zahl;
                    ++anzahl;
                }
            }
        }
        for (i = 0; i < fliessrichtung.length; ++i) {
            for (j = 0; j < fliessrichtung[0].length; ++j) {
                fliessrichtung[i][j] = fliess[0][i][j];
                flgew[i][j] = fliess[1][i][j];
            }
        }
        for (i = 1; i < fliessrichtung.length - 1; ++i) {
            for (j = 1; j < fliessrichtung[0].length - 1; ++j) {
                if (flgew1[i][j] == -1) continue;
                if (flgew1[i + 1][j] == -1) {
                    fliessrichtung[i + 1][j] = 16;
                }
                if (flgew1[i - 1][j] == -1) {
                    fliessrichtung[i - 1][j] = 1;
                }
                if (flgew1[i][j + 1] == -1) {
                    fliessrichtung[i][j + 1] = 64;
                }
                if (flgew1[i][j - 1] != -1) continue;
                fliessrichtung[i][j - 1] = 4;
            }
        }
        return fliessrichtung;
    }

    private double[][] calculateSlopeLength(double[][] Hangneigung, double kalibrierung, double zeitintervall, double cellsize) {
        double[][] Weg = new double[Hangneigung.length][Hangneigung[0].length];
        for (int i = 0; i < Weg.length; ++i) {
            for (int j = 0; j < Weg[0].length; ++j) {
                if (Hangneigung[i][j] == -1.0) {
                    Weg[i][j] = -1.0;
                    continue;
                }
                double alpha = Hangneigung[i][j] * 2.0 * Math.PI / 360.0;
                Weg[i][j] = 9.9 * Math.sin(alpha) * kalibrierung * zeitintervall / cellsize;
            }
        }
        return Weg;
    }

    private Point[][] calculateFlowPath(double[][] dgm, Point[][] routing, int actx, int acty, double zahl, int[][] fliessrichtung, double[][] weg, int[][] flgew, int startx, int starty, double aufloesung) {
        Point p = new Point();
        if (dgm[actx][acty] == -1.0) {
            p.x = startx;
            p.y = starty;
            routing[startx][starty] = p;
            ++this.externalGridCells;
        }
        if (flgew[actx][acty] == -1 && (zahl < 1.0 || actx == startx && acty == starty) && actx > 0 && actx < fliessrichtung.length - 1 && acty > 0 && acty < fliessrichtung[0].length - 1) {
            zahl += 1.0 / weg[actx][acty];
            if (fliessrichtung[actx][acty] == 1) {
                routing = this.calculateFlowPath(dgm, routing, actx + 1, acty, zahl, fliessrichtung, weg, flgew, startx, starty, aufloesung);
            }
            if (fliessrichtung[actx][acty] == 2) {
                routing = this.calculateFlowPath(dgm, routing, actx + 1, acty + 1, zahl, fliessrichtung, weg, flgew, startx, starty, aufloesung);
            }
            if (fliessrichtung[actx][acty] == 4) {
                routing = this.calculateFlowPath(dgm, routing, actx, acty + 1, zahl, fliessrichtung, weg, flgew, startx, starty, aufloesung);
            }
            if (fliessrichtung[actx][acty] == 8) {
                routing = this.calculateFlowPath(dgm, routing, actx - 1, acty + 1, zahl, fliessrichtung, weg, flgew, startx, starty, aufloesung);
            }
            if (fliessrichtung[actx][acty] == 16) {
                routing = this.calculateFlowPath(dgm, routing, actx - 1, acty, zahl, fliessrichtung, weg, flgew, startx, starty, aufloesung);
            }
            if (fliessrichtung[actx][acty] == 32) {
                routing = this.calculateFlowPath(dgm, routing, actx - 1, acty - 1, zahl, fliessrichtung, weg, flgew, startx, starty, aufloesung);
            }
            if (fliessrichtung[actx][acty] == 64) {
                routing = this.calculateFlowPath(dgm, routing, actx, acty - 1, zahl, fliessrichtung, weg, flgew, startx, starty, aufloesung);
            }
            if (fliessrichtung[actx][acty] == 128) {
                routing = this.calculateFlowPath(dgm, routing, actx + 1, acty - 1, zahl, fliessrichtung, weg, flgew, startx, starty, aufloesung);
            }
            if (fliessrichtung[actx][acty] == 0) {
                p.x = actx;
                p.y = acty;
                routing[startx][starty] = p;
            }
        } else {
            p.x = actx;
            p.y = acty;
            routing[startx][starty] = p;
        }
        return routing;
    }

    private Point[][] calculateFlowPath1(double[][] dgm, int[][] fliessrichtung, double[][] weg, int[][] flgew, double aufloesung) {
        Point[][] routing = new Point[dgm.length][dgm[0].length];
        for (int i = 1; i < weg.length - 1; ++i) {
            for (int j = 1; j < weg[0].length - 1; ++j) {
                if (dgm[i][j] == -1.0) continue;
                routing = this.calculateFlowPath(dgm, routing, i, j, 0.0, fliessrichtung, weg, flgew, i, j, aufloesung);
            }
        }
        return routing;
    }

    private int[][] mapRasterToPolygon(int[][] raster, PolygonRasterMap map, int zeile, int spalte, int type) {
        if (raster[zeile][spalte] == map.polygonID || raster[zeile][spalte] == 123456) {
            map.add(new Point(zeile, spalte));
            raster[zeile][spalte] = -1;
            if (zeile > 1 && spalte > 1 && zeile < raster.length - 1 && spalte < raster[0].length - 1) {
                raster = this.mapRasterToPolygon(raster, map, zeile - 1, spalte, type);
                raster = this.mapRasterToPolygon(raster, map, zeile, spalte - 1, type);
                raster = this.mapRasterToPolygon(raster, map, zeile, spalte + 1, type);
                raster = this.mapRasterToPolygon(raster, map, zeile + 1, spalte, type);
                if (type == 2) {
                    raster = this.mapRasterToPolygon(raster, map, zeile - 1, spalte - 1, type);
                    raster = this.mapRasterToPolygon(raster, map, zeile + 1, spalte - 1, type);
                    raster = this.mapRasterToPolygon(raster, map, zeile - 1, spalte + 1, type);
                    raster = this.mapRasterToPolygon(raster, map, zeile + 1, spalte + 1, type);
                }
            }
        }
        return raster;
    }

    private int[][] quickSort(int[][] liste, int untereGrenze, int obereGrenze) {
        int links = untereGrenze;
        int rechts = obereGrenze;
        int pivot = liste[0][(untereGrenze + obereGrenze) / 2];
        while (true) {
            if (liste[0][links] < pivot) {
                ++links;
                continue;
            }
            while (pivot < liste[0][rechts]) {
                --rechts;
            }
            if (links <= rechts) {
                int tmp = liste[0][links];
                liste[0][links] = liste[0][rechts];
                liste[0][rechts] = tmp;
                tmp = liste[1][links];
                liste[1][links] = liste[1][rechts];
                liste[1][rechts] = tmp;
                tmp = liste[2][links];
                liste[2][links] = liste[2][rechts];
                liste[2][rechts] = tmp;
                ++links;
                --rechts;
            }
            if (links > rechts) break;
        }
        if (untereGrenze < rechts) {
            liste = this.quickSort(liste, untereGrenze, rechts);
        }
        if (links < obereGrenze) {
            liste = this.quickSort(liste, links, obereGrenze);
        }
        return liste;
    }

    private int[][] sortDGM(int[][] dgm_sort, double[][] dgm) {
        int count = 0;
        for (int i = 1; i < dgm.length - 1; ++i) {
            for (int j = 1; j < dgm[0].length - 1; ++j) {
                if (dgm[i][j] == -1.0) continue;
                dgm_sort[0][count] = (int)dgm[i][j];
                dgm_sort[1][count] = i;
                dgm_sort[2][count] = j;
                ++count;
            }
        }
        dgm_sort = this.quickSort(dgm_sort, 0, count - 1);
        return dgm_sort;
    }

    public void runInit() {
        int j;
        int i;
        int j2;
        int i2;
        int rastersize = this.getRasterSize(new File(this.getModel().getWorkspaceDirectory(), this.dgmFile.getValue()));
        double[][] hruraster_start = this.readRasterFile(new File(this.getModel().getWorkspaceDirectory(), this.hruRasterFile.getValue()));
        double[][] dgm_start = this.readRasterFile(new File(this.getModel().getWorkspaceDirectory(), this.dgmFile.getValue()));
        double[][] flgew_start = this.readRasterFile(new File(this.getModel().getWorkspaceDirectory(), this.flgewFile.getValue()));
        double aufloesung = this.gridresolution.getValue();
        double zeitschritt = this.timescale.getValue();
        if (zeitschritt == 1.0) {
            zeitschritt = 86400.0;
        }
        if (zeitschritt == 2.0) {
            zeitschritt = 3600.0;
        }
        rastersize = (int)((double)rastersize * aufloesung);
        int[] orgDGMSize = new int[]{dgm_start.length, dgm_start[0].length};
        int[] DGMSize = new int[]{(int)((double)orgDGMSize[0] / aufloesung), (int)((double)orgDGMSize[1] / aufloesung)};
        double[][] dgm = new double[DGMSize[0]][DGMSize[1]];
        int[][] hruraster = new int[DGMSize[0]][DGMSize[1]];
        for (int i3 = 0; i3 < DGMSize[0]; ++i3) {
            for (int j3 = 0; j3 < DGMSize[1]; ++j3) {
                dgm[(int)((double)i3 / aufloesung)][(int)((double)j3 / aufloesung)] = dgm[(int)((double)i3 / aufloesung)][(int)((double)j3 / aufloesung)] + dgm_start[i3][j3];
            }
        }
        int[][] flgew = new int[DGMSize[0]][DGMSize[1]];
        int[][] flgew1 = new int[DGMSize[0]][DGMSize[1]];
        int[][] flgew2 = new int[DGMSize[0]][DGMSize[1]];
        for (i2 = 0; i2 < DGMSize[0]; ++i2) {
            for (j2 = 0; j2 < DGMSize[1]; ++j2) {
                flgew[i2][j2] = -1;
            }
        }
        for (i2 = 0; i2 < DGMSize[0]; ++i2) {
            for (j2 = 0; j2 < DGMSize[1]; ++j2) {
                int k = 0;
                while ((double)k < aufloesung) {
                    int l = 0;
                    while ((double)l < aufloesung) {
                        if (flgew_start[(int)((double)i2 * aufloesung + (double)k)][(int)((double)j2 * aufloesung + (double)l)] != -1.0) {
                            if (flgew_start[(int)((double)i2 * aufloesung + (double)k)][(int)((double)j2 * aufloesung + (double)l)] == 123456.0) {
                                flgew[i2][j2] = 123456;
                                k = (int)aufloesung + 1;
                                l = (int)aufloesung + 1;
                            } else {
                                flgew[i2][j2] = (int)flgew_start[(int)((double)i2 * aufloesung + (double)k)][(int)((double)j2 * aufloesung + (double)l)];
                            }
                        }
                        ++l;
                    }
                    ++k;
                }
                flgew1[i2][j2] = flgew[i2][j2];
                flgew2[i2][j2] = flgew[i2][j2];
            }
        }
        for (i2 = 0; i2 < DGMSize[0]; ++i2) {
            for (j2 = 0; j2 < DGMSize[1]; ++j2) {
                dgm[i2][j2] = dgm[i2][j2] / (aufloesung * aufloesung);
                if (dgm[i2][j2] > -1.0 && dgm[i2][j2] < 0.1) {
                    dgm[i2][j2] = -1.0;
                }
                if (!((double)i2 * aufloesung < (double)hruraster_start.length) || !((double)j2 * aufloesung < (double)hruraster_start[0].length)) continue;
                hruraster[i2][j2] = (int)hruraster_start[(int)((double)i2 * aufloesung)][(int)((double)j2 * aufloesung)];
            }
        }
        int[][] fliessrichtung = this.calculateFlowDirection(dgm);
        HashMap<Integer, PolygonRasterMap> reachList = new HashMap<Integer, PolygonRasterMap>();
        int count = 0;
        int zahl = 1;
        while (zahl != 0) {
            zahl = 0;
            for (i = 0; i < DGMSize[0]; ++i) {
                for (j = 0; j < DGMSize[1]; ++j) {
                    if (flgew2[i][j] == -1 || flgew2[i][j] == 123456) continue;
                    zahl = 1;
                    PolygonRasterMap rasterReachMap = new PolygonRasterMap(flgew2[i][j]);
                    count = 0;
                    if (flgew2[i + 1][j] == -1) {
                        ++count;
                    }
                    if (flgew2[i - 1][j] == -1) {
                        ++count;
                    }
                    if (flgew2[i][j + 1] == -1) {
                        ++count;
                    }
                    if (flgew2[i][j - 1] == -1) {
                        ++count;
                    }
                    if (flgew2[i + 1][j + 1] == -1) {
                        ++count;
                    }
                    if (flgew2[i + 1][j - 1] == -1) {
                        ++count;
                    }
                    if (flgew2[i - 1][j + 1] == -1) {
                        ++count;
                    }
                    if (flgew2[i - 1][j - 1] == -1) {
                        ++count;
                    }
                    if (count == 7) {
                        flgew2 = this.mapRasterToPolygon(flgew2, rasterReachMap, i, j, 2);
                        ++zahl;
                        reachList.put(rasterReachMap.polygonID, rasterReachMap);
                    }
                    if (count == 6 && flgew2[i + 1][j + 1] != -1 && flgew2[i][j + 1] != -1) {
                        flgew2 = this.mapRasterToPolygon(flgew2, rasterReachMap, i, j, 2);
                        ++zahl;
                        reachList.put(rasterReachMap.polygonID, rasterReachMap);
                    }
                    if (count == 6 && flgew2[i + 1][j + 1] != -1 && flgew2[i + 1][j] != -1) {
                        flgew2 = this.mapRasterToPolygon(flgew2, rasterReachMap, i, j, 2);
                        ++zahl;
                        reachList.put(rasterReachMap.polygonID, rasterReachMap);
                    }
                    if (count == 6 && flgew2[i + 1][j] != -1 && flgew2[i + 1][j - 1] != -1) {
                        flgew2 = this.mapRasterToPolygon(flgew2, rasterReachMap, i, j, 2);
                        ++zahl;
                        reachList.put(rasterReachMap.polygonID, rasterReachMap);
                    }
                    if (count == 6 && flgew2[i + 1][j - 1] != -1 && flgew2[i][j - 1] != -1) {
                        flgew2 = this.mapRasterToPolygon(flgew2, rasterReachMap, i, j, 2);
                        ++zahl;
                        reachList.put(rasterReachMap.polygonID, rasterReachMap);
                    }
                    if (count == 6 && flgew2[i - 1][j - 1] != -1 && flgew2[i][j - 1] != -1) {
                        flgew2 = this.mapRasterToPolygon(flgew2, rasterReachMap, i, j, 2);
                        ++zahl;
                        reachList.put(rasterReachMap.polygonID, rasterReachMap);
                    }
                    if (count == 6 && flgew2[i - 1][j] != -1 && flgew2[i - 1][j - 1] != -1) {
                        flgew2 = this.mapRasterToPolygon(flgew2, rasterReachMap, i, j, 2);
                        ++zahl;
                        reachList.put(rasterReachMap.polygonID, rasterReachMap);
                    }
                    if (count == 6 && flgew2[i - 1][j + 1] != -1 && flgew2[i - 1][j] != -1) {
                        flgew2 = this.mapRasterToPolygon(flgew2, rasterReachMap, i, j, 2);
                        ++zahl;
                        reachList.put(rasterReachMap.polygonID, rasterReachMap);
                    }
                    if (count != 6 || flgew2[i - 1][j + 1] == -1 || flgew2[i][j + 1] == -1) continue;
                    flgew2 = this.mapRasterToPolygon(flgew2, rasterReachMap, i, j, 2);
                    ++zahl;
                    reachList.put(rasterReachMap.polygonID, rasterReachMap);
                }
            }
        }
        fliessrichtung = this.flgew(dgm, fliessrichtung, flgew, flgew1, hruraster);
        for (i = 0; i < fliessrichtung.length; ++i) {
            for (j = 0; j < fliessrichtung[0].length; ++j) {
                if (flgew1[i][j] == -1) continue;
                flgew1[i][j] = fliessrichtung[i][j];
            }
        }
        for (i = 0; i < flgew.length; ++i) {
            for (j = 0; j < flgew[0].length; ++j) {
                if (flgew[i][j] != 123456) continue;
                flgew1[i][j] = 0;
                ((PolygonRasterMap)reachList.values().iterator().next()).add(new Point(i, j));
                flgew1[i - 1][j - 1] = 2;
                flgew1[i - 1][j] = 1;
                flgew1[i - 1][j + 1] = 128;
                flgew1[i][j - 1] = 4;
                flgew1[i][j + 1] = 64;
                flgew1[i + 1][j - 1] = 8;
                flgew1[i + 1][j] = 16;
                flgew1[i + 1][j + 1] = 32;
                fliessrichtung[i][j] = 0;
                fliessrichtung[i - 1][j - 1] = 2;
                fliessrichtung[i - 1][j] = 1;
                fliessrichtung[i - 1][j + 1] = 128;
                fliessrichtung[i][j - 1] = 4;
                fliessrichtung[i][j + 1] = 64;
                fliessrichtung[i + 1][j - 1] = 8;
                fliessrichtung[i + 1][j] = 16;
                fliessrichtung[i + 1][j + 1] = 32;
                i = flgew.length;
                j = flgew[0].length;
            }
        }
        double[][] hangneigung = this.calcSlope(dgm, fliessrichtung, rastersize);
        HashMap<Integer, PolygonRasterMap> hruList = new HashMap<Integer, PolygonRasterMap>();
        count = 0;
        for (int i4 = 0; i4 < hruraster.length; ++i4) {
            for (int j4 = 0; j4 < hruraster[0].length; ++j4) {
                if (hruraster[i4][j4] == -1) continue;
                PolygonRasterMap rasterToHRUMap = new PolygonRasterMap(hruraster[i4][j4]);
                hruraster = this.mapRasterToPolygon(hruraster, rasterToHRUMap, i4, j4, 1);
                hruList.put(rasterToHRUMap.polygonID, rasterToHRUMap);
                ++count;
            }
        }
        int[][] dgm_sort = new int[3][dgm.length * dgm[0].length];
        dgm_sort = this.sortDGM(dgm_sort, dgm);
        double[][] Fuellstand_Reaches = new double[dgm.length][dgm[0].length];
        double[][] Qin_Reaches = new double[dgm.length][dgm[0].length];
        double RD1_Koeff = this.RD1_Weg_Koeff.getValue();
        double RD2_Koeff = this.RD2_Weg_Koeff.getValue();
        double RG1_Koeff = this.RG1_Weg_Koeff.getValue();
        double RG2_Koeff = this.RG2_Weg_Koeff.getValue();
        double[][] slopeLength = this.calculateSlopeLength(hangneigung, RD1_Koeff, zeitschritt, rastersize);
        Object[][] RoutingRD1 = this.calculateFlowPath1(dgm, fliessrichtung, slopeLength, flgew, aufloesung);
        slopeLength = this.calculateSlopeLength(hangneigung, RD2_Koeff, zeitschritt, rastersize);
        Object[][] RoutingRD2 = this.calculateFlowPath1(dgm, fliessrichtung, slopeLength, flgew, aufloesung);
        slopeLength = this.calculateSlopeLength(hangneigung, RG1_Koeff, zeitschritt, rastersize);
        Object[][] RoutingRG1 = this.calculateFlowPath1(dgm, fliessrichtung, slopeLength, flgew, aufloesung);
        slopeLength = this.calculateSlopeLength(hangneigung, RG2_Koeff, zeitschritt, rastersize);
        Object[][] RoutingRG2 = this.calculateFlowPath1(dgm, fliessrichtung, slopeLength, flgew, aufloesung);
        this.Ausgabe(RoutingRD1, "E:/ModelData/flgewRD1.txt");
        this.Ausgabe(RoutingRD2, "E:/ModelData/flgewRD2.txt");
        this.Ausgabe(RoutingRG1, "E:/ModelData/flgewRG1.txt");
        this.Ausgabe(RoutingRG2, "E:/ModelData/flgewRG2.txt");
        double[][] RD1_vraster = new double[hruraster.length][hruraster[0].length];
        double[][] RD2_vraster = new double[hruraster.length][hruraster[0].length];
        double[][] RG1_vraster = new double[hruraster.length][hruraster[0].length];
        double[][] RG2_vraster = new double[hruraster.length][hruraster[0].length];
        double[][] reachinfo = new double[4][reachList.size() + 100];
        this.information.setObject("hruraster", (Object)hruraster);
        this.information.setObject("fliessrichtung", (Object)fliessrichtung);
        this.information.setObject("dgm", (Object)dgm);
        this.information.setObject("flgew", (Object)flgew);
        this.information.setObject("flgew1", (Object)flgew1);
        this.information.setObject("routingRD1", (Object)RoutingRD1);
        this.information.setObject("routingRD2", (Object)RoutingRD2);
        this.information.setObject("routingRG1", (Object)RoutingRG1);
        this.information.setObject("routingRG2", (Object)RoutingRG2);
        this.information.setObject("hangneigung", (Object)hangneigung);
        this.information.setObject("dgm_sort", (Object)dgm_sort);
        this.information.setObject("hrulist", hruList);
        this.information.setObject("reachlist", reachList);
        this.information.setObject("RD1_vraster", (Object)RD1_vraster);
        this.information.setObject("RD2_vraster", (Object)RD2_vraster);
        this.information.setObject("RG1_vraster", (Object)RG1_vraster);
        this.information.setObject("RG2_vraster", (Object)RG2_vraster);
        this.information.setObject("reachinfo", (Object)reachinfo);
        double[][] RD1_raster = new double[hruraster.length][hruraster[0].length];
        double[][] RD1_reach = new double[reachList.size()][2];
        double[][] RD2_raster = new double[hruraster.length][hruraster[0].length];
        double[][] RD2_reach = new double[reachList.size()][2];
        double[][] RG1_raster = new double[hruraster.length][hruraster[0].length];
        double[][] RG1_reach = new double[reachList.size()][2];
        double[][] RG2_raster = new double[hruraster.length][hruraster[0].length];
        double[][] RG2_reach = new double[reachList.size()][2];
        this.fuellstand.setObject("RD1_raster", (Object)RD1_raster);
        this.fuellstand.setObject("RD2_raster", (Object)RD2_raster);
        this.fuellstand.setObject("RG1_raster", (Object)RG1_raster);
        this.fuellstand.setObject("RG2_raster", (Object)RG2_raster);
        this.fuellstand.setObject("RD1_reach", (Object)RD1_reach);
        this.fuellstand.setObject("RD2_reach", (Object)RD2_reach);
        this.fuellstand.setObject("RG1_reach", (Object)RG1_reach);
        this.fuellstand.setObject("RG2_reach", (Object)RG2_reach);
        this.fuellstand.setObject("fuellstand_reaches", (Object)Fuellstand_Reaches);
        this.fuellstand.setObject("Qin_reaches", (Object)Qin_Reaches);
        System.out.println("External Points: " + this.externalGridCells);
    }

    public void run() {
        this.runInit();
    }

    public void cleanup() {
    }
}

