/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.statistics.IDW;

@JAMSComponentDescription(title="CalcIDWeights", author="Peter Krause", description="Calculates inverse distance weights for the regionalisation procedure")
public class CalcIDWeights
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity x-coordinate")
    public Attribute.Double entityX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity y-coordinate")
    public Attribute.Double entityY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station's x coordinates")
    public Attribute.DoubleArray statX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station's y coordinates")
    public Attribute.DoubleArray statY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Power of IDW function")
    public Attribute.Double pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="weights for IDW part of regionalisation")
    public Attribute.DoubleArray statIDWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="position array to determine best weights")
    public Attribute.IntegerArray statOrder;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Doug Boyle's famous function")
    public Attribute.Boolean equalWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculation with geographical coordinates LL")
    public Attribute.Boolean latLong;
    IDW idw = new IDW();

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double[] weights = this.statIDWeights.getValue();
        int[] wA = this.statOrder.getValue();
        int n = this.statX.getValue().length;
        if (weights == null || weights.length != n) {
            weights = new double[n];
        }
        if (wA == null || wA.length != n) {
            wA = new int[n];
        }
        if (this.equalWeights == null || !this.equalWeights.getValue()) {
            if (this.latLong == null || !this.latLong.getValue()) {
                this.idw.init(this.statX.getValue(), this.statY.getValue(), null, (int)this.pidw.getValue(), IDW.Projection.ANY);
            } else {
                this.idw.init(this.statX.getValue(), this.statY.getValue(), null, (int)this.pidw.getValue(), IDW.Projection.LATLON);
            }
            this.idw.getIDW(this.entityX.getValue(), this.entityY.getValue(), null, 0);
            System.arraycopy(this.idw.getWeights(), 0, weights, 0, n);
            System.arraycopy(this.idw.getWeightOrder(), 0, wA, 0, n);
        } else if (this.equalWeights.getValue()) {
            for (int i = 0; i < n; ++i) {
                weights[i] = 1.0 / (double)n;
                wA[i] = i;
            }
        }
        this.statIDWeights.setValue(weights);
        this.statOrder.setValue(wA);
    }

    public void cleanup() throws Attribute.Entity.NoSuchAttributeException {
        int nstat = this.statIDWeights.getValue().length;
        double[] sw = new double[nstat];
        for (int i = 0; i < nstat; ++i) {
            sw[i] = 0.0;
        }
        this.statIDWeights.setValue(sw);
    }
}

