/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class CalcDailyNetRadiation_1
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable relative humidity")
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable solar radiation")
    public Attribute.Double extRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable solar radiation")
    public Attribute.Double solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable albedo")
    public Attribute.Double albedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute elevation")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily net radiation [MJ/m\u00b2]")
    public Attribute.Double netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily shortwave radiation [MJ/m\u00b2]", defaultValue="0")
    public Attribute.Double swRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily longwave radiation [MJ/m\u00b2]", defaultValue="0")
    public Attribute.Double lwRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily net radiation for refET [MJ/m\u00b2]", defaultValue="0")
    public Attribute.Double refETNetRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Use caching of regionalised data?")
    public Attribute.Boolean dataCaching;

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double elev = this.elevation.getValue();
        double temp = this.tmean.getValue();
        double rh = this.rhum.getValue();
        double sR = this.solRad.getValue();
        double alb = this.albedo.getValue();
        double extraTerrestialRad = this.extRad.getValue();
        double sat_vapour_pressure = ClimatologicalVariables.calc_saturationVapourPressure(temp);
        double act_vapour_pressure = ClimatologicalVariables.calc_vapourPressure(rh, sat_vapour_pressure);
        double clearSkyRad = SolarRadiationCalculationMethods.calc_ClearSkySolarRadiation(elev, extraTerrestialRad);
        double netSWRadiation = SolarRadiationCalculationMethods.calc_NetShortwaveRadiation(alb, sR);
        double netRefETSWRadiation = SolarRadiationCalculationMethods.calc_NetShortwaveRadiation(0.23, sR);
        double netLWRadiation = DailySolarRadiationCalculationMethods.calc_DailyNetLongwaveRadiation(temp, act_vapour_pressure, sR, clearSkyRad, false);
        double nR_norm = SolarRadiationCalculationMethods.calc_NetRadiation(netSWRadiation, netLWRadiation);
        double nR_refET = SolarRadiationCalculationMethods.calc_NetRadiation(netRefETSWRadiation, netLWRadiation);
        this.netRad.setValue(nR_norm);
        this.refETNetRad.setValue(nR_refET);
        this.swRad.setValue(netSWRadiation);
        this.lwRad.setValue(netLWRadiation);
    }

    public void cleanup() throws IOException {
    }
}

