/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.potET;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;

@JAMSComponentDescription(title="CalcDailyETP_PenmanMonteith", author="Peter Krause", description="Calculates potential ETP after Penman-Monteith")
public class PenmanMonteith_1
extends JAMSComponent {
    public final double CP = 0.001031;
    public final double RSS = 150.0;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable wind")
    public Attribute.Double wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable relative humidity")
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable net radiation")
    public Attribute.Double netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable rsc0")
    public Attribute.Double actRsc0;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute elevation")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable LAI")
    public Attribute.Double actLAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable effective height")
    public Attribute.Double actEffH;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="potential ET [mm/ timeUnit]")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actual ET [mm/ timeUnit]")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="rs")
    public Attribute.Double rs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="ra")
    public Attribute.Double ra;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Use caching of regionalised data?")
    public Attribute.Boolean dataCaching;

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double netRad = this.netRad.getValue();
        double temperature = this.tmean.getValue();
        double rhum = this.rhum.getValue();
        double wind = this.wind.getValue();
        double rsc0 = this.actRsc0.getValue();
        double LAI = this.actLAI.getValue();
        double effHeight = this.actEffH.getValue();
        double elevation = this.elevation.getValue();
        double area = this.area.getValue();
        double abs_temp = ClimatologicalVariables.calc_absTemp(temperature, "degC");
        double delta_s = ClimatologicalVariables.calc_slopeOfSaturationPressureCurve(temperature);
        double pz = ClimatologicalVariables.calc_atmosphericPressure(elevation, abs_temp);
        double est = ClimatologicalVariables.calc_saturationVapourPressure(temperature);
        double ea = ClimatologicalVariables.calc_vapourPressure(rhum, est);
        double latH = ClimatologicalVariables.calc_latentHeatOfVaporization(temperature);
        double psy = ClimatologicalVariables.calc_psyConst(pz, latH);
        double rs = this.calcRs(LAI, rsc0, 150.0);
        double ra = PenmanMonteith_1.calcRa(effHeight, wind);
        double G = this.calc_groundHeatFlux(netRad);
        double vT = ClimatologicalVariables.calc_VirtualTemperature(abs_temp, pz, ea);
        double pa = ClimatologicalVariables.calc_AirDensityAtConstantPressure(vT, pz);
        double tempFactor = 0.0;
        double pET = 0.0;
        double aET = 0.0;
        if (this.tempRes.getValue().equals("d")) {
            tempFactor = 86400.0;
        } else if (this.tempRes.getValue().equals("h")) {
            tempFactor = 3600.0;
        } else if (this.tempRes.getValue().equals("m")) {
            tempFactor = 86400.0;
        }
        double Letp = this.calcETAllen(delta_s, netRad, G, pa, 0.001031, est, ea, ra, rs, psy, tempFactor);
        pET = Letp / latH;
        aET = 0.0;
        pET *= area;
        if (this.time != null && this.tempRes.getValue().equals("m")) {
            int daysInMonth = this.time.getActualMaximum(5);
            pET *= (double)daysInMonth;
        }
        if (pET < 0.0) {
            pET = 0.0;
        }
        this.potET.setValue(pET);
        this.ra.setValue(ra);
        this.rs.setValue(rs);
        this.actET.setValue(aET);
    }

    public void cleanup() throws IOException {
    }

    private double calcETAllen(double ds, double netRad, double G, double pa, double CP, double est, double ea, double ra, double rs, double psy, double tempFactor) {
        double Letp = (ds * (netRad - G) + pa * CP * (est - ea) / ra * tempFactor) / (ds + psy * (1.0 + rs / ra));
        return Letp;
    }

    private double calc_groundHeatFlux(double netRad) {
        double g = 0.1 * netRad;
        return g;
    }

    private static double calcRa(double eff_height, double wind_speed) {
        if (wind_speed <= 0.0) {
            wind_speed = 0.5;
        }
        double ra = eff_height < 10.0 ? 9.5 / wind_speed * Math.pow(Math.log(2.0 / (0.1 * eff_height)), 2.0) : 20.0 / (Math.pow(0.41, 2.0) * wind_speed);
        return ra;
    }

    private double calcRs(double LAI, double rsc, double rss) {
        double A = Math.pow(0.7, LAI);
        double rs = 1.0 / ((1.0 - A) / rsc + A / rss);
        return rs;
    }
}

