/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import jams.tools.JAMSTools;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

@JAMSComponentDescription(title="StationDataWriter", author="Peter Krause", description="Writes standard ASCII timeseries data files")
public class StationDataWriter
extends JAMSComponent {
    public static final String EMPTY_CHAR = "";
    public static final String SEPARATOR = "\t";
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time interval")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="the data values")
    public Attribute.DoubleArray values;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the station names")
    public Attribute.StringArray statNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the station Ids")
    public Attribute.IntegerArray statId;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the station elevation")
    public Attribute.DoubleArray statElev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the station x-coordinates")
    public Attribute.DoubleArray statX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the station y-coordinates")
    public Attribute.DoubleArray statY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="data set description [type min max unit]")
    public Attribute.String dataSetDesc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution", defaultValue="")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="missing data value")
    public Attribute.Double missDataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output data precision")
    public Attribute.Integer precision;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Data store description")
    public Attribute.String xmlDSD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="write file with input header", defaultValue="true")
    public Attribute.String withInputHeader;
    private GenericDataWriter writer;
    private DateFormat dateFormat;

    public void init() {
        this.getModel().getRuntime().println(" start init " + this.fileName.getValue() + ".. ", 2);
        Date dt = new Date();
        int tu = this.timeInterval.getTimeUnit();
        String timeFormat = "%1$tY-%1$tm-%1$td %1$tH:%1$tM";
        if (tu == 11) {
            timeFormat = "%1$td.%1$tm.%1$tY %1$tH:%1$tM";
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        } else if (tu == 6) {
            timeFormat = "%1$td.%1$tm.%1$tY";
            this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        } else if (tu == 2) {
            timeFormat = "%1$tm/%1$tY";
            this.dateFormat = new SimpleDateFormat("MM/yyyy");
        } else if (tu == 1) {
            timeFormat = "%1$tY";
            this.dateFormat = new SimpleDateFormat("yyyy");
        }
        this.dateFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        this.writer = new GenericDataWriter(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspace().getOutputDataDirectory().getPath(), (String)this.fileName.getValue()));
        String inputHeader = this.withInputHeader.getValue();
        if (inputHeader != null && inputHeader.equalsIgnoreCase("true")) {
            int i;
            this.writer.writeLine("#Calculated input data, generated: " + dt);
            this.writer.writeLine("@dataValueAttribs");
            this.writer.writeLine(this.dataSetDesc.getValue());
            this.writer.writeLine("@dataSetAttribs");
            this.writer.writeLine("missingDataVal\t" + this.missDataValue.getValue());
            this.writer.writeLine("dataStart\t" + this.timeInterval.getStart().toString(this.dateFormat));
            this.writer.writeLine("dataEnd\t" + this.timeInterval.getEnd().toString(this.dateFormat));
            this.writer.writeLine("tres\t" + this.tempRes);
            this.writer.writeLine("@statAttribVal");
            this.writer.addColumn("name");
            for (i = 0; i < this.statNames.getValue().length; ++i) {
                this.writer.addColumn(this.statNames.getValue()[i]);
            }
            this.writer.writeHeader();
            this.writer.write("ID");
            for (i = 0; i < this.statId.getValue().length; ++i) {
                this.writer.write(SEPARATOR + this.statId.getValue()[i]);
            }
            this.writer.writeLine(EMPTY_CHAR);
            this.writer.write("elevation");
            for (i = 0; i < this.statElev.getValue().length; ++i) {
                this.writer.write(SEPARATOR + this.statElev.getValue()[i]);
            }
            this.writer.writeLine(EMPTY_CHAR);
            this.writer.write("x");
            for (i = 0; i < this.statX.getValue().length; ++i) {
                this.writer.write(SEPARATOR + this.statX.getValue()[i]);
            }
            this.writer.writeLine(EMPTY_CHAR);
            this.writer.write("y");
            for (i = 0; i < this.statY.getValue().length; ++i) {
                this.writer.write(SEPARATOR + this.statY.getValue()[i]);
            }
            this.writer.writeLine(EMPTY_CHAR);
            this.writer.write("dataColumn");
            for (i = 0; i < this.statX.getValue().length; ++i) {
                int col = i + 1;
                this.writer.write(SEPARATOR + col);
            }
            this.writer.writeLine(EMPTY_CHAR);
            this.writer.writeLine("@dataVal");
        } else {
            int i;
            int cols = this.statNames.getValue().length + 1;
            String[] hdr = new String[cols];
            hdr[0] = "date";
            for (i = 1; i < cols; ++i) {
                hdr[i] = this.statNames.getValue()[i - 1];
            }
            this.statNames.setValue(hdr);
            for (i = 0; i < this.statNames.getValue().length; ++i) {
                this.writer.addColumn(this.statNames.getValue()[i]);
            }
            this.writer.writeHeader();
        }
        this.getModel().getRuntime().println(" end init " + this.fileName.getValue() + ".. ", 2);
    }

    public void run() {
        this.writer.addData((Object)this.time.toString(this.dateFormat));
        for (int i = 0; i < this.values.getValue().length; ++i) {
            this.writer.addData(this.values.getValue()[i], this.precision.getValue());
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().println(jre.getMessage());
        }
        double[] n = null;
        this.values.setValue(n);
    }

    public void cleanup() {
        try {
            this.writer.writer.flush();
            this.writer.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringTokenizer st = new StringTokenizer(this.dataSetDesc.getValue(), " ");
        String dispName = st.nextToken();
        GenericDataWriter xmlWri = new GenericDataWriter(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspace().getOutputDataDirectory().getPath(), (String)this.xmlDSD.getValue()));
        xmlWri.writeLine("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?>");
        xmlWri.writeLine("<j2ktsdatastore>");
        xmlWri.writeLine("<parsetime value=\"false\" />");
        xmlWri.writeLine("<dumptimeformat value=\"yyyy-MM-dd HH:mm\" />");
        xmlWri.writeLine("<displayname>" + dispName + "</displayname>");
        xmlWri.writeLine("</j2ktsdatastore>");
        try {
            xmlWri.writer.flush();
            xmlWri.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

