/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.data.EntityEnumerator;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import jams.tools.JAMSTools;

public class StandardEntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="EntitySet")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.String header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file attribute names")
    public Attribute.String attributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity attribute name for weight [attName | none]")
    public Attribute.String weight;
    private GenericDataWriter writer;
    private boolean headerWritten;

    public void init() {
        this.writer = new GenericDataWriter(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.fileName.getValue()));
        this.writer.addComment("J2K model output" + this.header.getValue());
        this.writer.addComment("");
    }

    public void run() {
        int i;
        EntityEnumerator ee = this.entities.getEntityEnumerator();
        if (!this.headerWritten) {
            this.writer.addColumn("date/time");
            Object ob = this.entities.getCurrent().getObject(this.attributeName.getValue());
            int length = 0;
            if (ob.getClass().getName().contains("DoubleArray")) {
                length = ((Attribute.DoubleArray)this.entities.getCurrent().getObject(this.attributeName.getValue())).getValue().length;
            }
            ee.reset();
            boolean cont = true;
            while (cont) {
                for (i = 0; i < length; ++i) {
                    this.writer.addColumn("HRU_" + (int)this.entities.getCurrent().getId() + "[" + i + "]");
                }
                if (length == 0) {
                    this.writer.addColumn("HRU_" + (int)this.entities.getCurrent().getId());
                }
                if (ee.hasNext()) {
                    ee.next();
                    cont = true;
                    continue;
                }
                cont = false;
            }
            this.writer.writeHeader();
            this.headerWritten = true;
        }
        this.writer.addData((Object)this.time);
        ee.reset();
        boolean cont = true;
        while (cont) {
            double weight;
            Object ob = this.entities.getCurrent().getObject(this.attributeName.getValue());
            if (ob.getClass().getName().contains("DoubleArray")) {
                double[] da = ((Attribute.DoubleArray)this.entities.getCurrent().getObject(this.attributeName.getValue())).getValue();
                for (i = 0; i < da.length; ++i) {
                    double val = 0.0;
                    if (this.weight.getValue().equals("none")) {
                        val = da[i];
                    } else {
                        weight = ((Attribute.Double)this.entities.getCurrent().getObject(this.weight.getValue())).getValue();
                        val = da[i] / weight;
                    }
                    this.writer.addData((Object)("" + val));
                }
            } else {
                double val = 0.0;
                double da = ((Attribute.Double)this.entities.getCurrent().getObject(this.attributeName.getValue())).getValue();
                if (this.weight.getValue().equals("none")) {
                    val = da;
                } else {
                    weight = ((Attribute.Double)this.entities.getCurrent().getObject(this.weight.getValue())).getValue();
                    val = da / weight;
                }
                this.writer.addData((Object)("" + val));
            }
            if (ee.hasNext()) {
                ee.next();
                cont = true;
                continue;
            }
            cont = false;
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Throwable)jre);
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

