/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.JAMSTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.unijena.j2k.J2KFunctions;

public class MultiEntityReaderBS
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU parameter file name")
    public Attribute.String hruFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach parameter file name")
    public Attribute.String reachFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter file name for topological linkage with receiver entities")
    public Attribute.String to_hru_FileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter file name for weighting of receiver entity")
    public Attribute.String bfl_FileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects with their topology")
    public Attribute.EntityCollection topology;

    public void init() {
        this.hrus.setEntities(J2KFunctions.readParas(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.hruFileName.getValue()), this.getModel()));
        this.reaches.setEntities(J2KFunctions.readParas(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.reachFileName.getValue()), this.getModel()));
        this.createTopology();
        this.getModel().getRuntime().println("Create ordered hru-list", 2);
        this.createOrderedList(this.hrus, "to_poly");
        this.getModel().getRuntime().println("Create ordered reach-list", 2);
        this.createOrderedList(this.reaches, "to_reach");
        this.getModel().getRuntime().println("Entities read successfull!", 2);
    }

    private void createTopology() {
        HashMap<Double, Attribute.Entity> hruMap = new HashMap<Double, Attribute.Entity>();
        HashMap<Double, Attribute.Entity> reachMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity e : this.hrus.getEntities()) {
            hruMap.put(e.getDouble("ID"), e);
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            reachMap.put(e.getDouble("ID"), e);
        }
        Attribute.Entity nullEntity = this.getModel().getRuntime().getDataFactory().createEntity();
        reachMap.put(new Double(0.0), nullEntity);
        try {
            BufferedReader reader1 = new BufferedReader(new FileReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.to_hru_FileName.getValue()));
            BufferedReader reader2 = new BufferedReader(new FileReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.bfl_FileName.getValue()));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader1.readLine();
            }
            String t = "#";
            while (t.startsWith("#")) {
                t = reader2.readLine();
            }
            while (s != null && !s.startsWith("#")) {
                Attribute.Entity e;
                StringTokenizer tokenizer_to_hru = new StringTokenizer(s, "\t");
                double eID = Double.parseDouble(tokenizer_to_hru.nextToken());
                double eBFl = Double.parseDouble(tokenizer_to_hru.nextToken());
                String recIDs = tokenizer_to_hru.nextToken();
                e = (Attribute.Entity)hruMap.get(eID);
                e.setDouble("BFl", eBFl);
                StringTokenizer tokenizer_weights = new StringTokenizer(t, "\t");
                double eID2 = Double.parseDouble(tokenizer_weights.nextToken());
                double eBFl2 = Double.parseDouble(tokenizer_weights.nextToken());
                String recWeights = tokenizer_weights.nextToken();
                if (eID != eID2) {
                    this.getModel().getRuntime().sendHalt("One of tables topologie_to_hru or topologie_bfl is missorted");
                }
                ArrayList<Attribute.Entity> receiverPolys = new ArrayList<Attribute.Entity>();
                ArrayList<Attribute.Entity> receiverReaches = new ArrayList<Attribute.Entity>();
                ArrayList<Double> receiverPolysWeights = new ArrayList<Double>();
                ArrayList<Double> receiverReachesWeights = new ArrayList<Double>();
                ArrayList receiverArea = new ArrayList();
                StringTokenizer sTok = new StringTokenizer(recIDs, ",");
                StringTokenizer tTok = new StringTokenizer(recWeights, ",");
                boolean tschuessnull = false;
                double sumWeight = 1.0;
                while (sTok.hasMoreTokens() && !tschuessnull) {
                    String stringID = sTok.nextToken();
                    double doubleID = Double.parseDouble(stringID);
                    String stringWeight = tTok.nextToken();
                    double doubleWeight = Double.parseDouble(stringWeight);
                    sumWeight = Math.round((sumWeight - doubleWeight) * 10000.0) / 10000L;
                    if (doubleID == 0.0 && doubleWeight != 0.0 || doubleID != 0.0 && doubleWeight == 0.0) {
                        this.getModel().getRuntime().sendHalt("No. of receivers and their weights in HRU " + eID + " do not match!");
                    }
                    if (doubleID > 0.0) {
                        Attribute.Entity f = (Attribute.Entity)hruMap.get(doubleID);
                        receiverPolys.add(f);
                        receiverPolysWeights.add(doubleWeight);
                    }
                    if (doubleID < 0.0) {
                        double reachID = doubleID * -1.0;
                        Attribute.Entity r = (Attribute.Entity)reachMap.get(reachID);
                        receiverReaches.add(r);
                        receiverReachesWeights.add(doubleWeight);
                    }
                    if (doubleID != 0.0) continue;
                    tschuessnull = true;
                }
                if ((sumWeight = Math.abs(sumWeight)) >= 0.001) {
                    System.out.println("Error in processing entity with ID " + eID);
                    this.getModel().getRuntime().sendHalt("Sum of weights is not equal 1! Process entity:" + eID);
                }
                Attribute.Entity[] to_poly_Array = receiverPolys.toArray(new Attribute.Entity[receiverPolys.size()]);
                Attribute.Entity[] to_reach_Array = receiverReaches.toArray(new Attribute.Entity[receiverReaches.size()]);
                Double[] to_poly_weights_Array = receiverPolysWeights.toArray(new Double[receiverPolysWeights.size()]);
                Double[] to_reach_weights_Array = receiverReachesWeights.toArray(new Double[receiverReachesWeights.size()]);
                Double[] to_poly_bfl_Array = receiverArea.toArray(new Double[receiverPolysWeights.size()]);
                e.setObject("to_poly", (Object)to_poly_Array);
                e.setObject("to_reach", (Object)to_reach_Array);
                e.setObject("to_poly_weights", (Object)to_poly_weights_Array);
                e.setObject("to_reach_weights", (Object)to_reach_weights_Array);
                e.setObject("bfl_zirkel_betrag", (Object)to_poly_bfl_Array);
                sumWeight = 1.0;
                s = reader1.readLine();
                t = reader2.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            e.setObject("to_reach", reachMap.get(e.getDouble("to-reach")));
        }
    }

    protected void createOrderedList(Attribute.EntityCollection col, String asso) {
        int i;
        Attribute.Entity f;
        Attribute.Entity[] e_ziel_to_poly;
        Iterator entityIterator;
        ArrayList<Attribute.Entity> newList = new ArrayList<Attribute.Entity>();
        HashMap<Object, Integer> depthMap = new HashMap<Object, Integer>();
        HashMap<Object, Integer> circleMap = new HashMap<Object, Integer>();
        boolean mapChanged = true;
        boolean mapChanged2 = true;
        boolean gefunden = false;
        boolean zirkel = false;
        boolean unaufloesbar = false;
        int arrayfeld_min = 0;
        double bfl_zirkel = 0.0;
        double bfl_zirkel_temp = 0.0;
        double bfl_zirkel_min = 0.0;
        double umgelenkt_gesamt = 0.0;
        if (asso.toString().equals("to_poly")) {
            Attribute.Entity e;
            Iterator entityIterator3;
            entityIterator = col.getEntities().iterator();
            while (entityIterator.hasNext()) {
                mapChanged = true;
                entityIterator3 = col.getEntities().iterator();
                while (entityIterator3.hasNext()) {
                    circleMap.put(entityIterator3.next(), new Integer(0));
                }
                e = (Attribute.Entity)entityIterator.next();
                circleMap.put(e, new Integer(1));
                System.out.println("Untersuche HRU " + e.getDouble("ID") + " auf Zirkelbezuege");
                while (mapChanged) {
                    mapChanged = false;
                    Iterator entityIterator2 = col.getEntities().iterator();
                    while (entityIterator2.hasNext()) {
                        bfl_zirkel = 0.0;
                        Attribute.Entity e_ziel = (Attribute.Entity)entityIterator2.next();
                        if ((Integer)circleMap.get(e_ziel) != 1) continue;
                        mapChanged = true;
                        circleMap.put(e_ziel, new Integer(2));
                        e_ziel_to_poly = (Attribute.Entity[])e_ziel.getObject("to_poly");
                        if (e_ziel_to_poly.length <= 0) continue;
                        for (int i2 = 0; i2 < e_ziel_to_poly.length; ++i2) {
                            f = e_ziel_to_poly[i2];
                            if (f == null) continue;
                            if (e.getDouble("ID") == f.getDouble("ID")) {
                                zirkel = true;
                                Double[] e_ziel_to_poly_weights = (Double[])e_ziel.getObject("to_poly_weights");
                                bfl_zirkel = e_ziel.getDouble("BFl") * e_ziel_to_poly_weights[i2];
                                bfl_zirkel_min = bfl_zirkel_temp += bfl_zirkel;
                                Double[] e_ziel_to_poly_bfl = (Double[])e_ziel.getObject("bfl_zirkel_betrag");
                                e_ziel_to_poly_bfl[i2] = bfl_zirkel;
                                e_ziel.setObject("bfl_zirkel_betrag", (Object)e_ziel_to_poly_bfl);
                                continue;
                            }
                            if ((Integer)circleMap.get(f) != 0) continue;
                            circleMap.put(f, new Integer(1));
                        }
                    }
                }
            }
            if (zirkel) {
                while (mapChanged2) {
                    mapChanged2 = false;
                    e = null;
                    Attribute.Entity e_ziel_temp = null;
                    for (Attribute.Entity e_temp : col.getEntities()) {
                        Double[] e_temp_to_poly_bfl = (Double[])e_temp.getObject("bfl_zirkel_betrag");
                        if (e_temp_to_poly_bfl.length <= 0) continue;
                        for (int i3 = 0; i3 < e_temp_to_poly_bfl.length; ++i3) {
                            if (e_temp_to_poly_bfl[i3] == null || !((bfl_zirkel = e_temp_to_poly_bfl[i3].doubleValue()) > 0.0) || !(bfl_zirkel <= bfl_zirkel_min)) continue;
                            bfl_zirkel_min = bfl_zirkel;
                            Attribute.Entity[] e_temp_to_poly = (Attribute.Entity[])e_temp.getObject("to_poly");
                            e = e_temp_to_poly[i3];
                            e_ziel_temp = e_temp;
                            arrayfeld_min = i3;
                            mapChanged2 = true;
                        }
                    }
                    if (e == null) continue;
                    entityIterator3 = col.getEntities().iterator();
                    while (entityIterator3.hasNext()) {
                        circleMap.put(entityIterator3.next(), new Integer(0));
                    }
                    mapChanged = true;
                    gefunden = false;
                    circleMap.put(e, new Integer(1));
                    bfl_zirkel_min = bfl_zirkel_temp;
                    Double[] e_ziel_temp_to_poly_bfl = (Double[])e_ziel_temp.getObject("bfl_zirkel_betrag");
                    e_ziel_temp_to_poly_bfl[arrayfeld_min] = null;
                    e_ziel_temp.setObject("bfl_zirkel_betrag", (Object)e_ziel_temp_to_poly_bfl);
                    while (mapChanged && !gefunden) {
                        mapChanged = false;
                        for (Attribute.Entity e_ziel : col.getEntities()) {
                            int i4;
                            if ((Integer)circleMap.get(e_ziel) != 1) continue;
                            circleMap.put(e_ziel, new Integer(2));
                            mapChanged = true;
                            Attribute.Entity[] e_ziel_to_reach = (Attribute.Entity[])e_ziel.getObject("to_reach");
                            Attribute.Entity[] e_ziel_to_poly2 = (Attribute.Entity[])e_ziel.getObject("to_poly");
                            int arraylaenge_poly = 0;
                            for (i4 = 0; i4 < e_ziel_to_poly2.length; ++i4) {
                                if (e_ziel_to_poly2[i4] == null) continue;
                                ++arraylaenge_poly;
                            }
                            if (e_ziel.getDouble("ID") == e_ziel_temp.getDouble("ID")) {
                                gefunden = true;
                                if (arraylaenge_poly + e_ziel_to_reach.length <= 1) continue;
                                Double[] e_ziel_to_poly_weights = (Double[])e_ziel.getObject("to_poly_weights");
                                Double[] e_ziel_to_reach_weights = (Double[])e_ziel.getObject("to_reach_weights");
                                double e_ziel_to_poly_id = e_ziel_to_poly2[arrayfeld_min].getDouble("ID");
                                if (e_ziel_to_reach.length > 0) {
                                    e_ziel_to_reach_weights[0] = e_ziel_to_reach_weights[0] + e_ziel_to_poly_weights[arrayfeld_min];
                                    e_ziel.setObject("to_reach_weights", (Object)e_ziel_to_reach_weights);
                                    double e_ziel_to_reach_id = e_ziel_to_reach[0].getDouble("ID");
                                    System.out.println("HRU " + e_ziel.getDouble("ID") + ": Unterbrechung der Fliessbeziehung zu HRU " + e_ziel_to_poly_id + ". Umleitung in das Fliessgewaessersegment -" + e_ziel_to_reach_id + "; Beitragende Flaeche: " + (double)Math.round(e_ziel.getDouble("BFl") * e_ziel_to_poly_weights[arrayfeld_min] / 1000.0) / 1000.0 + " qkm");
                                } else if (arraylaenge_poly > 1) {
                                    int i5;
                                    int anzahl = 0;
                                    for (i5 = 0; i5 < e_ziel_to_poly2.length; ++i5) {
                                        if (e_ziel_to_poly2[i5] == null || i5 == arrayfeld_min) continue;
                                        ++anzahl;
                                    }
                                    for (i5 = 0; i5 < e_ziel_to_poly2.length; ++i5) {
                                        if (e_ziel_to_poly2[i5] == null || i5 == arrayfeld_min) continue;
                                        e_ziel_to_poly_weights[i5] = e_ziel_to_poly_weights[i5] + e_ziel_to_poly_weights[arrayfeld_min] / (double)anzahl;
                                    }
                                    System.out.println("HRU " + e_ziel.getDouble("ID") + ": Unterbrechung der Fliessbeziehung zu HRU " + e_ziel_to_poly_id + ". Verteilung des Wassers auf alle anderen Fliessbeziehungen der HRU; Beitragende Flaeche: " + (double)Math.round(e_ziel.getDouble("BFl") * e_ziel_to_poly_weights[arrayfeld_min] / 1000.0) / 1000.0 + " qkm");
                                }
                                umgelenkt_gesamt += e_ziel.getDouble("BFl") * e_ziel_to_poly_weights[arrayfeld_min];
                                e_ziel_to_poly2[arrayfeld_min] = null;
                                e_ziel_to_poly_weights[arrayfeld_min] = null;
                                e_ziel.setObject("to_poly", (Object)e_ziel_to_poly2);
                                e_ziel.setObject("to_poly_weights", (Object)e_ziel_to_poly_weights);
                                continue;
                            }
                            if (arraylaenge_poly <= 0) continue;
                            for (i4 = 0; i4 < e_ziel_to_poly2.length; ++i4) {
                                f = e_ziel_to_poly2[i4];
                                if (f == null || (Integer)circleMap.get(f) != 0) continue;
                                circleMap.put(f, new Integer(1));
                            }
                        }
                    }
                }
            }
        }
        mapChanged = true;
        entityIterator = col.getEntities().iterator();
        while (entityIterator.hasNext()) {
            depthMap.put(entityIterator.next(), new Integer(0));
        }
        while (mapChanged) {
            mapChanged = false;
            for (Attribute.Entity e : col.getEntities()) {
                Integer fDepth;
                Integer eDepth = (Integer)depthMap.get(e);
                if (asso.toString().equals("to_poly") && (e_ziel_to_poly = (Attribute.Entity[])e.getObject(asso)).length > 0) {
                    for (int i6 = 0; i6 < e_ziel_to_poly.length; ++i6) {
                        f = e_ziel_to_poly[i6];
                        if (f == null || (fDepth = (Integer)depthMap.get(f)) > eDepth) continue;
                        depthMap.put(f, new Integer(eDepth + 1));
                        mapChanged = true;
                    }
                }
                if (!asso.toString().equals("to_reach")) continue;
                Attribute.Entity eff = (Attribute.Entity)e.getObject(asso);
                if (eff.isEmpty()) {
                    eff = null;
                }
                if (eff == null || (fDepth = (Integer)depthMap.get(eff)) > eDepth) continue;
                depthMap.put(eff, new Integer(eDepth + 1));
                mapChanged = true;
            }
        }
        int maxDepth = 0;
        for (Attribute.Entity e : col.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(e));
        }
        ArrayList alList = new ArrayList();
        for (i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (Attribute.Entity e : col.getEntities()) {
            int depth = (Integer)depthMap.get(e);
            ((ArrayList)alList.get(depth)).add(e);
        }
        for (i = 0; i <= maxDepth; ++i) {
            for (Attribute.Entity e : (ArrayList)alList.get(i)) {
                newList.add(e);
            }
        }
        col.setEntities(newList);
    }
}

