/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;

public class J2KTopologyCreator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Collection of reservoir objects")
    public Attribute.EntityCollection reservoirs;

    public void init() {
        this.createTopology();
        this.getModel().getRuntime().println("Create ordered hru-list", 1);
        this.createOrderedList(this.hrus, "to_poly");
        this.getModel().getRuntime().println("Create ordered reach-list", 1);
        this.createOrderedList(this.reaches, "to_reach");
        this.getModel().getRuntime().println("Entities read successfull!", 1);
    }

    protected boolean cycleCheck(Attribute.Entity node, Stack<Attribute.Entity> searchStack, HashSet<Attribute.Double> closedList, HashSet<Attribute.Double> visitedList) {
        if (searchStack.indexOf(node) != -1) {
            int index = searchStack.indexOf(node);
            String cyc_output = new String();
            for (int i = index; i < searchStack.size(); ++i) {
                cyc_output = cyc_output + ((Attribute.Entity)searchStack.get(i)).getDouble("ID") + " ";
            }
            this.getModel().getRuntime().println("Found circle with ids:" + cyc_output);
            return true;
        }
        if (closedList.contains(node.getObject("ID"))) {
            return false;
        }
        visitedList.add((Attribute.Double)node.getObject("ID"));
        Attribute.Entity child_node = (Attribute.Entity)node.getObject("to_poly");
        if (child_node != null) {
            searchStack.push(node);
            boolean result = this.cycleCheck(child_node, searchStack, closedList, visitedList);
            searchStack.pop();
            return result;
        }
        return false;
    }

    protected boolean cycleCheck() {
        HashSet<Attribute.Double> closedList = new HashSet<Attribute.Double>();
        HashSet<Attribute.Double> visitedList = new HashSet<Attribute.Double>();
        this.getModel().getRuntime().println("Cycle checking...");
        Iterator hruIterator = this.hrus.getEntities().iterator();
        boolean result = false;
        while (hruIterator.hasNext()) {
            Attribute.Entity start_node = (Attribute.Entity)hruIterator.next();
            if (closedList.contains(start_node.getObject("ID"))) continue;
            if (this.cycleCheck(start_node, new Stack<Attribute.Entity>(), closedList, visitedList)) {
                result = true;
            }
            closedList.addAll(visitedList);
            visitedList.clear();
        }
        return result;
    }

    protected void createTopology() {
        HashMap<Double, Attribute.Entity> hruMap = new HashMap<Double, Attribute.Entity>();
        HashMap<Double, Attribute.Entity> reachMap = new HashMap<Double, Attribute.Entity>();
        HashMap<Double, Attribute.Entity> reservoirMap = null;
        if (this.reservoirs != null) {
            reservoirMap = new HashMap<Double, Attribute.Entity>();
        }
        for (Attribute.Entity e : this.hrus.getEntities()) {
            hruMap.put(e.getDouble("ID"), e);
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            reachMap.put(e.getDouble("ID"), e);
        }
        if (this.reservoirs != null) {
            for (Attribute.Entity e : this.reservoirs.getEntities()) {
                reservoirMap.put(e.getDouble("ID"), e);
            }
        }
        for (Attribute.Entity e : this.hrus.getEntities()) {
            e.setObject("to_poly", hruMap.get(e.getDouble("to_poly")));
            e.setObject("to_reach", reachMap.get(e.getDouble("to_reach")));
            if (this.reservoirs == null) continue;
            try {
                e.setObject("to_reservoir", reservoirMap.get(e.getDouble("to_reservoir")));
            }
            catch (Attribute.Entity.NoSuchAttributeException ex) {
                ex.printStackTrace();
            }
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            e.setObject("to_reach", reachMap.get(e.getDouble("to-reach")));
            if (this.reservoirs == null) continue;
            try {
                e.setObject("to_reservoir", reservoirMap.get(e.getDouble("to-reservoir")));
            }
            catch (Attribute.Entity.NoSuchAttributeException ex) {
                ex.printStackTrace();
            }
        }
        if (this.getModel().getRuntime().getDebugLevel() >= 3) {
            if (this.cycleCheck()) {
                this.getModel().getRuntime().println("HRUs --> cycle found ... :( ");
            } else {
                this.getModel().getRuntime().println("HRUs --> no cycle found");
            }
        }
    }

    protected void createOrderedList(Attribute.EntityCollection col, String asso) {
        int i;
        ArrayList<Attribute.Entity> newList = new ArrayList<Attribute.Entity>();
        HashMap<Object, Integer> depthMap = new HashMap<Object, Integer>();
        boolean mapChanged = true;
        Iterator hruIterator = col.getEntities().iterator();
        while (hruIterator.hasNext()) {
            depthMap.put(hruIterator.next(), new Integer(0));
        }
        int numHRUs = col.getEntities().size();
        int maxDepth = 0;
        while (mapChanged) {
            mapChanged = false;
            for (Attribute.Entity e : col.getEntities()) {
                Attribute.Entity f = (Attribute.Entity)e.getObject(asso);
                if (f == null) continue;
                Integer eDepth = (Integer)depthMap.get(e);
                Integer fDepth = (Integer)depthMap.get(f);
                if (fDepth > eDepth) continue;
                depthMap.put(f, new Integer(fDepth + 1));
                mapChanged = true;
            }
        }
        maxDepth = 0;
        for (Attribute.Entity e : col.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(e));
        }
        ArrayList alList = new ArrayList();
        for (i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (Attribute.Entity e : col.getEntities()) {
            int depth = (Integer)depthMap.get(e);
            ((ArrayList)alList.get(depth)).add(e);
        }
        for (i = 0; i <= maxDepth; ++i) {
            for (Attribute.Entity e : (ArrayList)alList.get(i)) {
                newList.add(e);
            }
        }
        col.setEntities(newList);
    }
}

