/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.data.EntityEnumerator;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import jams.tools.JAMSTools;

public class FullSetEntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="EntitySet")
    public Attribute.EntityCollection entitySet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.String header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file attribute names")
    public Attribute.String attributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity attribute name for weight [attName | none]")
    public Attribute.String weight;
    private GenericDataWriter writer;
    private boolean headerWritten;

    public void init() {
        this.writer = new GenericDataWriter(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.fileName.getValue()));
        this.writer.addComment("J2K model output" + this.header.getValue());
        this.writer.addComment("");
        this.headerWritten = false;
    }

    public void run() {
        Attribute.Entity entity;
        if (!this.headerWritten) {
            this.writer.addColumn("date/time");
            EntityEnumerator enumerator = this.entitySet.getEntityEnumerator();
            boolean firstIteration = true;
            while (firstIteration || enumerator.hasNext()) {
                entity = null;
                if (firstIteration) {
                    entity = this.entitySet.getCurrent();
                    firstIteration = false;
                } else {
                    entity = enumerator.next();
                }
                Object ob = entity.getObject(this.attributeName.getValue());
                int length = 0;
                length = ob.getClass().getName().contains("DoubleArray") ? ((Attribute.DoubleArray)entity.getObject(this.attributeName.getValue())).getValue().length : 0;
                for (int i = 0; i < length; ++i) {
                    this.writer.addColumn("HRU_" + (int)entity.getDouble("ID") + "[" + i + "]");
                }
                if (length != 0) continue;
                this.writer.addColumn("HRU_" + (int)entity.getDouble("ID"));
            }
            this.writer.writeHeader();
            this.headerWritten = true;
        }
        this.writer.addData((Object)this.time);
        this.entitySet.getEntityEnumerator().reset();
        boolean firstIteration = true;
        EntityEnumerator enumerator = this.entitySet.getEntityEnumerator();
        while (firstIteration || enumerator.hasNext()) {
            double val;
            Object ob;
            entity = null;
            if (firstIteration) {
                entity = this.entitySet.getCurrent();
                firstIteration = false;
            } else {
                entity = enumerator.next();
            }
            double weightVal = 1.0;
            if (!this.weight.getValue().equals("none")) {
                weightVal = ((Attribute.Double)entity.getObject(this.weight.getValue())).getValue();
            }
            if ((ob = entity.getObject(this.attributeName.getValue())).getClass().getName().contains("DoubleArray")) {
                double[] da = ((Attribute.DoubleArray)entity.getObject(this.attributeName.getValue())).getValue();
                for (int i = 0; i < da.length; ++i) {
                    val = da[i] / weightVal;
                    this.writer.addData((Object)("" + val));
                }
                continue;
            }
            double da = ((Attribute.Double)entity.getObject(this.attributeName.getValue())).getValue();
            val = da / weightVal;
            this.writer.addData((Object)("" + val));
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Throwable)jre);
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

