/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

@JAMSComponentDescription(title="EntitySubset", author="Sven Kralisch", description="Create an ordered subset from an entity list, using a given attribute value for identification. The subset can be ordered according to another attribute.", date="2020-09-03", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class EntitySubset
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of entities")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute name for filtering")
    public Attribute.String filterAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="value for filtering")
    public Attribute.Double filterValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute name for sorting")
    public Attribute.String sortAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="List of filtered entities")
    public Attribute.EntityCollection filteredEntities;

    public void init() {
        ArrayList<Attribute.Entity> filteredList = new ArrayList<Attribute.Entity>();
        for (Attribute.Entity e : this.entities.getEntities()) {
            double d = e.getDouble(this.filterAttribute.getValue());
            if (d != this.filterValue.getValue()) continue;
            filteredList.add(e);
        }
        Collections.sort(filteredList, new Comparator<Attribute.Entity>(){

            @Override
            public int compare(Attribute.Entity o1, Attribute.Entity o2) {
                double d2;
                double d1 = o1.getDouble(EntitySubset.this.sortAttribute.getValue());
                if (d1 < (d2 = o2.getDouble(EntitySubset.this.sortAttribute.getValue()))) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            }
        });
        this.filteredEntities.setEntities(filteredList);
    }
}

