/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.statistics.IDW;

@JAMSComponentDescription(title="RainCorrectionRichter2", author="Peter Krause", description="Applies correction according to RICHTER 1985 for measured daily precip sums,this module allows the consideration of the station location and shelter")
public class RainCorrectionRichter2
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the precip values")
    public Attribute.DoubleArray precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temperature for the correction function")
    public Attribute.DoubleArray temperature;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="corrected precip values")
    public Attribute.DoubleArray rcorr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of temperature station elevations")
    public Attribute.DoubleArray tempElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of temperature station's x coordinate")
    public Attribute.DoubleArray tempXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of temperature station's y coordinate")
    public Attribute.DoubleArray tempYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Regression coefficients for temperature")
    public Attribute.DoubleArray tempRegCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of precip station elevations")
    public Attribute.DoubleArray rainElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of precip station's x coordinate")
    public Attribute.DoubleArray rainXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of precip station's y coordinate")
    public Attribute.DoubleArray rainYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of temperature station for IDW")
    public Attribute.Integer tempNIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="power for IDW function")
    public Attribute.Double pIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="regression threshold")
    public Attribute.Double regThres;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="snow_trs")
    public Attribute.Double snow_trs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="snow_trans")
    public Attribute.Double snow_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Use caching of regionalised data?")
    public Attribute.Boolean dataCaching;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Station shelter [1 - no protection; 2 - gentle protection; 3 - moderate protection; 4 - strong protection]")
    public Attribute.IntegerArray protection;
    IDW idw = new IDW();

    public void run() {
        double[] precip = this.precip.getValue();
        double[] temperature = this.temperature.getValue();
        int n = precip.length;
        double[] rcorr = this.rcorr.getValue();
        if (rcorr == null || rcorr.length != n) {
            rcorr = new double[n];
        }
        double[] rainElev = this.rainElevation.getValue();
        double[] rainX = this.rainXCoord.getValue();
        double[] rainY = this.rainYCoord.getValue();
        double rsq = this.tempRegCoeff.getValue()[2];
        double grad = this.tempRegCoeff.getValue()[1];
        this.idw.init(this.tempXCoord.getValue(), this.tempYCoord.getValue(), this.tempElevation.getValue(), (int)this.pIDW.getValue(), IDW.Projection.ANY);
        for (int r = 0; r < n; ++r) {
            double rainTemp = 0.0;
            rainTemp = rsq > this.regThres.getValue() ? this.idw.getElevationCorrectedIDW(rainX[r], rainY[r], rainElev[r], grad, temperature, this.tempNIDW.getValue()) : this.idw.getIDW(rainX[r], rainY[r], temperature, this.tempNIDW.getValue());
            double pSnow = (this.snow_trs.getValue() + this.snow_trans.getValue() - rainTemp) / (2.0 * this.snow_trans.getValue());
            if (pSnow > 1.0) {
                pSnow = 1.0;
            } else if (pSnow < 0.0) {
                pSnow = 0.0;
            }
            double rain = (1.0 - pSnow) * precip[r];
            double snow = pSnow * precip[r];
            double as = 0.0;
            double bs = 0.0;
            double ls = 0.0;
            double ar = 0.0;
            double br = 0.0;
            double lr = 0.0;
            switch (this.protection.getValue()[r]) {
                case 1: {
                    lr = 0.642;
                    ar = 0.1801;
                    br = -0.608;
                    ls = 1.102;
                    as = 0.6774;
                    bs = -0.204;
                    break;
                }
                case 2: {
                    lr = 0.492;
                    ar = 0.1421;
                    br = -0.505;
                    ls = 0.938;
                    as = 0.5424;
                    bs = -0.211;
                    break;
                }
                case 3: {
                    lr = 0.304;
                    ar = 0.1029;
                    br = -0.519;
                    ls = 0.516;
                    as = 0.5424;
                    bs = -0.211;
                    break;
                }
                case 4: {
                    lr = 0.27;
                    ar = 0.0584;
                    br = -0.693;
                    ls = 0.326;
                    as = 0.1008;
                    bs = -0.022;
                    break;
                }
                default: {
                    this.getModel().getRuntime().sendInfoMsg("Wrong protection type for rain station");
                }
            }
            if (snow > 0.0) {
                if (snow <= 0.1) {
                    snow += snow * ls;
                } else {
                    double relSnow = as * Math.pow(snow, bs);
                    snow += snow * relSnow;
                }
            }
            if (rain > 0.0) {
                if (rain < 0.1) {
                    rain += rain * lr;
                } else {
                    double relRain = ar * Math.pow(rain, br);
                    rain += rain * relRain;
                }
            }
            double wetErr = precip[r] < 0.1 ? 0.0 : (this.time.get(2) >= 4 & this.time.get(2) < 10 ? (precip[r] >= 9.0 ? 0.47 : 0.08 * Math.log(precip[r]) + 0.225) : (precip[r] >= 9.0 ? 0.3 : 0.05 * Math.log(precip[r]) + 0.13));
            rcorr[r] = precip[r] == JAMS.getMissingDataValue() ? JAMS.getMissingDataValue() : rain + snow + wetErr;
        }
        this.rcorr.setValue(rcorr);
    }
}

