/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.Component;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import java.util.Random;
import java.util.StringTokenizer;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class RandomParaSampler
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of parameter identifiers to be sampled")
    public Attribute.String parameterIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of parameter value bounaries corresponding to parameter identifiers")
    public Attribute.String boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of samples to be taken")
    public Attribute.Integer sampleCount;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="efficiency methods")
    public Attribute.String effMethodNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="efficiency values")
    public Attribute.Double[] effValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Flag for dis/enabling this sampler")
    public Attribute.Boolean enable;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ)
    public Attribute.String paraFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ)
    public Attribute.String attribFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The model time interval")
    public Attribute.TimeInterval modelTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.String attribHeader;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Output file attribute")
    public Attribute.DoubleArray targetValue;
    Attribute.Double[] parameters;
    String[] parameterNames;
    double[] lowBound;
    double[] upBound;
    int currentCount;
    Random generator;
    GenericDataWriter paraWriter;
    GenericDataWriter attribWriter;
    double[][] valueArray;
    int timeStepCounter = 0;
    int runCounter = 0;
    int timeSteps = 0;

    public void init() {
        super.init();
        if (this.enable.getValue()) {
            String key;
            StringTokenizer tok = new StringTokenizer(this.parameterIDs.getValue(), ";");
            this.parameters = new Attribute.Double[tok.countTokens()];
            this.parameterNames = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                this.parameterNames[i] = key = tok.nextToken();
                this.parameters[i] = (Attribute.Double)this.getModel().getRuntime().getDataHandles().get(key);
                if (this.parameters[i] == null) {
                    System.out.println("Problem in Sampler: parameter: " + key + "does not exist!");
                }
                ++i;
            }
            tok = new StringTokenizer(this.boundaries.getValue(), ";");
            int n = tok.countTokens();
            this.lowBound = new double[n];
            this.upBound = new double[n];
            if (n != i) {
                this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": Different number of parameterIDs and boundaries!");
            }
            i = 0;
            while (tok.hasMoreTokens()) {
                key = tok.nextToken();
                key = key.substring(1, key.length() - 1);
                StringTokenizer boundTok = new StringTokenizer(key, ">");
                this.lowBound[i] = Double.parseDouble(boundTok.nextToken());
                this.upBound[i] = Double.parseDouble(boundTok.nextToken());
                if (this.upBound[i] <= this.lowBound[i]) {
                    this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": upBound must be higher than lowBound!");
                }
                ++i;
            }
            i = 0;
            tok = new StringTokenizer(this.effMethodNames.getValue(), ";");
            String[] effNames = new String[tok.countTokens()];
            i = 0;
            while (tok.hasMoreTokens()) {
                effNames[i] = key = tok.nextToken();
                ++i;
            }
            this.paraWriter = new GenericDataWriter(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.paraFileName.getValue());
            this.paraWriter.addColumn("Run");
            for (int j = 0; j < this.parameters.length; ++j) {
                this.paraWriter.addColumn(this.parameterNames[j]);
            }
            for (int e = 0; e < effNames.length; ++e) {
                this.paraWriter.addColumn(effNames[e]);
            }
            this.paraWriter.writeHeader();
            this.attribWriter = new GenericDataWriter(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.attribFileName.getValue());
            this.attribWriter.addComment("J2K model output");
            this.attribWriter.addComment("");
            this.attribWriter.addColumn("date/time");
            for (int s = 0; s < this.sampleCount.getValue(); ++s) {
                int counter = s + 1;
                this.attribWriter.addColumn(this.attribHeader.getValue() + "_run_" + counter);
            }
            this.attribWriter.writeHeader();
            this.timeSteps = (int)this.modelTimeInterval.getNumberOfTimesteps();
            this.valueArray = new double[this.sampleCount.getValue()][this.timeSteps];
            this.timeStepCounter = 0;
            this.runCounter = 0;
        }
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        if (!this.enable.getValue()) {
            this.singleRun();
        } else {
            this.resetValues();
            while (this.hasNext()) {
                this.updateValues();
                this.singleRun();
                this.paraWriter.addData((Object)this.currentCount);
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.paraWriter.addData((Object)this.parameters[i].getValue());
                }
                for (int e = 0; e < this.effValues.length; ++e) {
                    this.paraWriter.addData((Object)this.effValues[e].getValue());
                }
                try {
                    this.paraWriter.writeData();
                    this.paraWriter.flush();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                this.valueArray[this.runCounter] = this.targetValue.getValue();
                ++this.runCounter;
            }
            this.runEnumerator.reset();
            while (this.runEnumerator.hasNext() && this.doRun) {
                Component component = this.runEnumerator.next();
            }
        }
    }

    public void cleanup() {
        if (this.enable.getValue()) {
            Attribute.Calendar timeStamp = this.modelTimeInterval.getStart();
            for (int t = 0; t < this.timeSteps; ++t) {
                this.attribWriter.addData((Object)timeStamp.toString());
                timeStamp.add(this.modelTimeInterval.getTimeUnit(), 1);
                for (int r = 0; r < this.sampleCount.getValue(); ++r) {
                    this.attribWriter.addData((Object)this.valueArray[r][t]);
                }
                try {
                    this.attribWriter.writeData();
                    continue;
                }
                catch (RuntimeException jre) {
                    this.getModel().getRuntime().println(jre.getMessage());
                }
            }
            this.attribWriter.close();
            this.paraWriter.close();
        }
    }

    private void updateValues() {
        int count = this.currentCount + 1;
        this.getModel().getRuntime().println("Run No. " + count + " of " + this.sampleCount.getValue());
        double[] sample = this.randomSampler(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].setValue(sample[i]);
            this.getModel().getRuntime().println("Para: " + this.parameterNames[i] + " = " + sample[i]);
        }
        ++this.currentCount;
    }

    private double[] randomSampler(int nSamples) {
        double[] sample = new double[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            double d = this.generator.nextDouble();
            sample[i] = this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]);
        }
        return sample;
    }

    private void resetValues() {
        this.generator = new Random(System.currentTimeMillis());
        for (int i = 0; i < this.parameters.length; ++i) {
            double d = this.generator.nextDouble();
            this.parameters[i].setValue(this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]));
        }
        this.currentCount = 0;
    }

    private void singleRun() {
        Component comp;
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendHalt(e.toString());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.initAll();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendHalt(e.toString());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendHalt(e.toString());
            }
        }
    }

    private boolean hasNext() {
        return this.currentCount < this.sampleCount.getValue();
    }
}

