/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="LinearTestModel", author="Peter Krause", description="A linear regression model, which can be used to test optimizer and efficiency calculation")
public class LinearTestModel
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="known intercept")
    public Attribute.Double paraAgoal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="known gradient")
    public Attribute.Double paraBgoal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="known intercept")
    public Attribute.Double paraCgoal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="known gradient")
    public Attribute.Double paraDgoal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="unknown intercept")
    public Attribute.Double paraA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="unknown gradient")
    public Attribute.Double paraB;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="unknown intercept")
    public Attribute.Double paraC;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="unknown gradient")
    public Attribute.Double paraD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="model output y")
    public Attribute.DoubleArray yVal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="real output y")
    public Attribute.DoubleArray yValKnown;

    public void run() {
        double a = this.paraA.getValue();
        double b = this.paraB.getValue();
        double c = this.paraC.getValue();
        double d = this.paraD.getValue();
        double aFin = this.paraAgoal.getValue();
        double bFin = this.paraBgoal.getValue();
        double cFin = this.paraCgoal.getValue();
        double dFin = this.paraDgoal.getValue();
        double[] x = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] y = new double[x.length];
        double[] yFin = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = a * Math.pow(x[i], 4.0) + b * Math.pow(x[i], 3.0) + c * x[i] + d;
            yFin[i] = aFin * Math.pow(x[i], 4.0) + bFin * Math.pow(x[i], 3.0) + cFin * x[i] + dFin;
        }
        this.yVal.setValue(y);
        this.yValKnown.setValue(yFin);
    }
}

