/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.images;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.imageio.ImageIO;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.ows.Layer;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wms.WebMapServer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.gce.grassraster.GrassCoverageReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.MapContent;
import org.geotools.map.WMSCoverageReader;
import org.geotools.map.WMSLayer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.jgrasstools.gears.io.grasslegacy.map.color.ColorRule;
import org.jgrasstools.gears.io.grasslegacy.map.color.GrassColorTable;
import org.jgrasstools.gears.io.rasterreader.OmsRasterReader;
import org.jgrasstools.gears.libs.monitor.DummyProgressMonitor;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.SldUtilities;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.jgrasstools.gears.utils.images.PaperFormat;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.style.ColorMap;

public class ImageGenerator {
    public boolean doLegacyGrass = false;
    private String wmsURL = null;
    private List<String> featurePaths = new ArrayList<String>();
    private List<String> featureFilter = new ArrayList<String>();
    private List<String> coveragePaths = new ArrayList<String>();
    private List<GridGeometry2D> coverageRegions = new ArrayList<GridGeometry2D>();
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private IJGTProgressMonitor monitor = new DummyProgressMonitor();
    private List<org.geotools.map.Layer> layers = new ArrayList<org.geotools.map.Layer>();
    private List<org.geotools.map.Layer> synchronizedLayers = null;
    private MapContent content;
    private StreamingRenderer renderer;

    public ImageGenerator(IJGTProgressMonitor monitor) {
        if (monitor != null) {
            this.monitor = monitor;
        }
    }

    public void setDoLegacyGrass(boolean doLegacyGrass) {
        this.doLegacyGrass = doLegacyGrass;
    }

    public void addCoveragePath(String coveragePath) {
        if (!this.coveragePaths.contains(coveragePath)) {
            this.coveragePaths.add(coveragePath);
        }
    }

    public void addCoverageRegion(GridGeometry2D coverageRegion) {
        if (!this.coverageRegions.contains(coverageRegion)) {
            this.coverageRegions.add(coverageRegion);
        }
    }

    public void setWMS(String wmsURL) {
        this.wmsURL = wmsURL;
    }

    public void addFeaturePath(String featurePath, String filter) {
        if (!this.featurePaths.contains(featurePath)) {
            this.featurePaths.add(featurePath);
            if (filter == null) {
                filter = "";
            }
            this.featureFilter.add(filter);
        }
    }

    public ReferencedEnvelope setLayers() throws Exception {
        GridCoverageLayer layer;
        Style style;
        File styleFile;
        ReferencedEnvelope maxExtent = null;
        if (this.wmsURL != null) {
            String[] split = this.wmsURL.split("#");
            WebMapServer server = new WebMapServer(new URL(split[0]));
            WMSCoverageReader reader = new WMSLayer(server, this.getWMSLayer(server, split[1])).getReader();
            RasterSymbolizer sym = this.sf.getDefaultRasterSymbolizer();
            Style style2 = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
            GridReaderLayer layer2 = new GridReaderLayer((GridCoverage2DReader)reader, style2);
            this.layers.add((org.geotools.map.Layer)layer2);
            GeneralEnvelope originalEnvelope = reader.getOriginalEnvelope();
            if (originalEnvelope != null) {
                if (maxExtent == null) {
                    maxExtent = new ReferencedEnvelope(originalEnvelope.getCoordinateReferenceSystem());
                }
                this.expandToIncludeEnvelope(maxExtent, (org.opengis.geometry.Envelope)originalEnvelope);
            }
        }
        this.monitor.beginTask("Reading raster maps...", this.coveragePaths.size());
        for (int r = 0; r < this.coveragePaths.size(); ++r) {
            String coveragePath = this.coveragePaths.get(r);
            GridGeometry2D region = null;
            if (this.coverageRegions != null && this.coverageRegions.size() == this.coveragePaths.size()) {
                region = this.coverageRegions.get(r);
            }
            File file = new File(coveragePath);
            GridCoverage2D raster = null;
            AbstractGridCoverage2DReader reader = null;
            try {
                try {
                    AbstractGridFormat format = GridFormatFinder.findFormat((Object)file);
                    reader = format.getReader((Object)file);
                    if (reader instanceof GrassCoverageReader) {
                        reader = null;
                    }
                }
                catch (Exception format) {
                    // empty catch block
                }
                if (reader == null) {
                    if (region == null) {
                        raster = OmsRasterReader.readRaster(coveragePath);
                    } else {
                        RegionMap regionMap = CoverageUtilities.gridGeometry2RegionParamsMap(region);
                        double n = regionMap.getNorth();
                        double s = regionMap.getSouth();
                        double w = regionMap.getWest();
                        double e = regionMap.getEast();
                        double xres = regionMap.getXres();
                        double yres = regionMap.getYres();
                        OmsRasterReader rreader = new OmsRasterReader();
                        rreader.file = coveragePath;
                        rreader.pNorth = n;
                        rreader.pSouth = s;
                        rreader.pWest = w;
                        rreader.pEast = e;
                        rreader.pXres = xres;
                        rreader.pYres = yres;
                        rreader.doLegacyGrass = this.doLegacyGrass;
                        rreader.process();
                        raster = rreader.outRaster;
                    }
                }
            }
            catch (Exception e) {
                this.monitor.errorMessage(e.getLocalizedMessage());
                this.monitor.errorMessage("Trying to find other coverage source...");
                AbstractGridFormat format = GridFormatFinder.findFormat((Object)file);
                reader = format.getReader((Object)file);
            }
            styleFile = FileUtilities.substituteExtention(file, "sld");
            if (styleFile.exists()) {
                style = SldUtilities.getStyleFromFile(styleFile);
            } else if (CoverageUtilities.isGrass(coveragePath)) {
                style = this.getGrassStyle(coveragePath);
            } else {
                RasterSymbolizer sym = this.sf.getDefaultRasterSymbolizer();
                style = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
            }
            if (raster != null) {
                layer = new GridCoverageLayer(raster, style);
                this.layers.add((org.geotools.map.Layer)layer);
                org.opengis.geometry.Envelope envelope = raster.getEnvelope();
                if (maxExtent == null) {
                    maxExtent = new ReferencedEnvelope(envelope.getCoordinateReferenceSystem());
                }
                this.expandToIncludeEnvelope(maxExtent, envelope);
            }
            if (reader != null) {
                layer = new GridReaderLayer((GridCoverage2DReader)reader, style);
                this.layers.add((org.geotools.map.Layer)layer);
                GeneralEnvelope envelope = reader.getOriginalEnvelope();
                if (maxExtent == null) {
                    maxExtent = new ReferencedEnvelope(envelope.getCoordinateReferenceSystem());
                }
                this.expandToIncludeEnvelope(maxExtent, (org.opengis.geometry.Envelope)envelope);
            }
            this.monitor.worked(1);
        }
        this.monitor.done();
        this.monitor.beginTask("Reading vector maps...", this.featurePaths.size());
        for (int i = 0; i < this.featurePaths.size(); ++i) {
            String featurePath = this.featurePaths.get(i);
            String filter = this.featureFilter.get(i);
            FileDataStore store = FileDataStoreFinder.getDataStore((File)new File(featurePath));
            SimpleFeatureSource featureSource = store.getFeatureSource();
            SimpleFeatureCollection featureCollection = filter.length() == 0 ? featureSource.getFeatures() : featureSource.getFeatures(ECQL.toFilter((String)filter));
            styleFile = FileUtilities.substituteExtention(new File(featurePath), "sld");
            style = styleFile.exists() ? SldUtilities.getStyleFromFile(styleFile) : SLD.createSimpleStyle((FeatureType)featureSource.getSchema());
            layer = new FeatureLayer((FeatureCollection)featureCollection, style);
            this.layers.add((org.geotools.map.Layer)layer);
            if (maxExtent == null) {
                maxExtent = new ReferencedEnvelope(((SimpleFeatureType)featureCollection.getSchema()).getCoordinateReferenceSystem());
            }
            this.expandToIncludeEnvelope(maxExtent, (org.opengis.geometry.Envelope)featureCollection.getBounds());
            this.monitor.worked(1);
        }
        this.synchronizedLayers = Collections.synchronizedList(this.layers);
        this.monitor.done();
        return maxExtent;
    }

    private void expandToIncludeEnvelope(ReferencedEnvelope maxExtent, org.opengis.geometry.Envelope envelope) {
        ReferencedEnvelope tmpExtent = new ReferencedEnvelope(envelope.getCoordinateReferenceSystem());
        DirectPosition ll = envelope.getLowerCorner();
        double[] coordinate = ll.getCoordinate();
        tmpExtent.expandToInclude(new Coordinate(coordinate[0], coordinate[1]));
        DirectPosition ur = envelope.getUpperCorner();
        coordinate = ur.getCoordinate();
        tmpExtent.expandToInclude(new Coordinate(coordinate[0], coordinate[1]));
        try {
            ReferencedEnvelope transformed = tmpExtent.transform(maxExtent.getCoordinateReferenceSystem(), true);
            maxExtent.expandToInclude((Envelope)transformed);
        }
        catch (FactoryException | TransformException e) {
            e.printStackTrace();
        }
    }

    private Layer getWMSLayer(WebMapServer server, String layerName) {
        for (Layer layer : server.getCapabilities().getLayerList()) {
            if (!layerName.equals(layer.getName())) continue;
            return layer;
        }
        throw new IllegalArgumentException("Could not find layer " + layerName);
    }

    private synchronized void checkMapContent() {
        if (this.content == null) {
            this.content = new MapContent();
            this.content.setTitle("dump");
            for (org.geotools.map.Layer layer : this.layers) {
                this.content.addLayer(layer);
            }
            this.renderer = new StreamingRenderer();
            this.renderer.setMapContent(this.content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage drawImage(ReferencedEnvelope ref, int imageWidth, int imageHeight, double buffer) {
        this.checkMapContent();
        if (buffer > 0.0) {
            ref.expandBy(buffer, buffer);
        }
        Rectangle2D.Double refRect = new Rectangle2D.Double(ref.getMinX(), ref.getMinY(), ref.getWidth(), ref.getHeight());
        Rectangle2D.Double imageRect = new Rectangle2D.Double(0.0, 0.0, imageWidth, imageHeight);
        GeometryUtilities.scaleToRatio(imageRect, refRect, false);
        ReferencedEnvelope newRef = new ReferencedEnvelope((Rectangle2D)refRect, ref.getCoordinateReferenceSystem());
        Rectangle imageBounds = new Rectangle(0, 0, imageWidth, imageHeight);
        BufferedImage dumpImage = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g2d = dumpImage.createGraphics();
        g2d.fillRect(0, 0, imageWidth, imageHeight);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        StreamingRenderer streamingRenderer = this.renderer;
        synchronized (streamingRenderer) {
            this.renderer.paint(g2d, imageBounds, newRef);
        }
        return dumpImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage drawImageWithNewMapContent(ReferencedEnvelope ref, int imageWidth, int imageHeight, double buffer) {
        double delta;
        double envH;
        double envW;
        MapContent content = new MapContent();
        content.setTitle("dump");
        List<org.geotools.map.Layer> list = this.synchronizedLayers;
        synchronized (list) {
            for (org.geotools.map.Layer layer : this.synchronizedLayers) {
                content.addLayer(layer);
            }
        }
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(content);
        if (buffer > 0.0) {
            ref = new ReferencedEnvelope(ref);
            ref.expandBy(buffer, buffer);
        }
        if ((envW = ref.getWidth()) < (envH = ref.getHeight())) {
            double newEnvW = envH * (double)imageWidth / (double)imageHeight;
            delta = newEnvW - envW;
            ref.expandBy(delta / 2.0, 0.0);
        } else {
            double newEnvH = envW * (double)imageHeight / (double)imageWidth;
            delta = newEnvH - envH;
            ref.expandBy(0.0, delta / 2.0);
        }
        Rectangle imageBounds = new Rectangle(0, 0, imageWidth, imageHeight);
        BufferedImage dumpImage = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g2d = dumpImage.createGraphics();
        g2d.fillRect(0, 0, imageWidth, imageHeight);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderer.paint(g2d, imageBounds, ref);
        return dumpImage;
    }

    public void dispose() {
        if (this.content != null) {
            this.content.dispose();
        }
    }

    public void dumpPngImage(String imagePath, ReferencedEnvelope bounds, int imageWidth, int imageHeight, double buffer, int[] rgbCheck) throws IOException {
        BufferedImage dumpImage = this.drawImageWithNewMapContent(bounds, imageWidth, imageHeight, buffer);
        boolean dumpIt = true;
        if (rgbCheck != null) {
            boolean bl = dumpIt = !this.isAllOfCheckColor(rgbCheck, dumpImage);
        }
        if (dumpIt) {
            ImageIO.write((RenderedImage)dumpImage, "png", new File(imagePath));
        }
    }

    public void dumpJpgImage(String imagePath, ReferencedEnvelope bounds, int imageWidth, int imageHeight, double buffer, int[] rgbCheck) throws IOException {
        BufferedImage dumpImage = this.drawImageWithNewMapContent(bounds, imageWidth, imageHeight, buffer);
        boolean dumpIt = true;
        if (rgbCheck != null) {
            boolean bl = dumpIt = !this.isAllOfCheckColor(rgbCheck, dumpImage);
        }
        if (dumpIt) {
            ImageIO.write((RenderedImage)dumpImage, "jpg", new File(imagePath));
        }
    }

    public BufferedImage getImageWithCheck(ReferencedEnvelope bounds, int imageWidth, int imageHeight, double buffer, int[] rgbCheck) throws IOException {
        BufferedImage dumpImage = this.drawImageWithNewMapContent(bounds, imageWidth, imageHeight, buffer);
        boolean dumpIt = true;
        if (rgbCheck != null) {
            boolean bl = dumpIt = !this.isAllOfCheckColor(rgbCheck, dumpImage);
        }
        if (dumpIt) {
            return dumpImage;
        }
        return null;
    }

    private boolean isAllOfCheckColor(int[] rgbCheck, BufferedImage dumpImage) {
        WritableRaster raster = dumpImage.getRaster();
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                int[] value = raster.getPixel(i, j, (int[])null);
                if (value[0] == rgbCheck[0] && value[1] == rgbCheck[1] && value[2] == rgbCheck[2]) continue;
                return false;
            }
        }
        return true;
    }

    public void dumpPngImageForScaleAndPaper(String imagePath, ReferencedEnvelope bounds, double scale, PaperFormat paperFormat, Double dpi, BufferedImage legend, int legendX, int legendY, String scalePrefix, float scaleSize, int scaleX, int scaleY) throws IOException {
        Graphics2D graphics;
        if (dpi == null) {
            dpi = 72.0;
        }
        Coordinate centre = bounds.centre();
        double boundsXExtension = (double)paperFormat.width() / 1000.0 * scale;
        double boundsYExtension = (double)paperFormat.height() / 1000.0 * scale;
        Coordinate ll = new Coordinate(centre.x - boundsXExtension / 2.0, centre.y - boundsYExtension / 2.0);
        Coordinate ur = new Coordinate(centre.x + boundsXExtension / 2.0, centre.y + boundsYExtension / 2.0);
        Envelope tmpEnv = new Envelope(ll, ur);
        bounds = new ReferencedEnvelope(tmpEnv, bounds.getCoordinateReferenceSystem());
        int imageWidth = (int)((double)paperFormat.width() / 25.4 * dpi);
        int imageHeight = (int)((double)paperFormat.height() / 25.4 * dpi);
        BufferedImage dumpImage = this.drawImage(bounds, imageWidth, imageHeight, 0.0);
        if (legend != null) {
            graphics = (Graphics2D)dumpImage.getGraphics();
            graphics.drawImage(legend, null, legendX, legendY);
        }
        if (scalePrefix != null) {
            graphics = (Graphics2D)dumpImage.getGraphics();
            Font scaleFont = graphics.getFont().deriveFont(scaleSize);
            graphics.setFont(scaleFont);
            FontMetrics fontMetrics = graphics.getFontMetrics(scaleFont);
            String scaleString = scalePrefix + "1:" + (int)scale;
            Rectangle2D stringBounds = fontMetrics.getStringBounds(scaleString, graphics);
            double width = stringBounds.getWidth();
            double height = stringBounds.getHeight();
            graphics.setColor(Color.white);
            double border = 5.0;
            graphics.fillRect(scaleX, (int)((double)scaleY - height + 2.0 * border), (int)(width + 3.0 * border), (int)(height + 2.0 * border));
            graphics.setColor(Color.black);
            graphics.drawString(scaleString, scaleX + 5, scaleY);
        }
        ImageIO.write((RenderedImage)dumpImage, "png", new File(imagePath));
    }

    private Style getGrassStyle(String path) throws Exception {
        ArrayList<String> valuesList = new ArrayList<String>();
        ArrayList<Color> colorsList = new ArrayList<Color>();
        StyleBuilder sB = new StyleBuilder(this.sf);
        RasterSymbolizer rasterSym = this.sf.createRasterSymbolizer();
        File grassFile = new File(path);
        String mapName = grassFile.getName();
        String mapsetPath = grassFile.getParentFile().getParent();
        GrassColorTable ctable = new GrassColorTable(mapsetPath, mapName, null);
        Enumeration<ColorRule> rules = ctable.getColorRules();
        while (rules.hasMoreElements()) {
            String to;
            ColorRule element = rules.nextElement();
            float fromValue = element.getLowCategoryValue();
            float toValue = element.getLowCategoryValue() + element.getCategoryRange();
            byte[] lowcatcol = element.getColor(fromValue);
            byte[] highcatcol = element.getColor(toValue);
            Color fromColor = new Color(lowcatcol[0] & 0xFF, lowcatcol[1] & 0xFF, lowcatcol[2] & 0xFF);
            Color toColor = new Color(highcatcol[0] & 0xFF, highcatcol[1] & 0xFF, highcatcol[2] & 0xFF);
            String from = String.valueOf(fromValue);
            if (!valuesList.contains(from)) {
                valuesList.add(from);
                colorsList.add(fromColor);
            }
            if (valuesList.contains(to = String.valueOf(toValue))) continue;
            valuesList.add(to);
            colorsList.add(toColor);
        }
        org.geotools.styling.ColorMap colorMap = this.sf.createColorMap();
        if (valuesList.size() > 1) {
            for (int i = 0; i < valuesList.size(); ++i) {
                String fromValueStr = (String)valuesList.get(i);
                Color fromColor = (Color)colorsList.get(i);
                Expression fromColorExpr = sB.colorExpression(new Color(fromColor.getRed(), fromColor.getGreen(), fromColor.getBlue(), 255));
                Expression fromExpr = sB.literalExpression(Double.parseDouble(fromValueStr));
                ColorMapEntry entry = this.sf.createColorMapEntry();
                entry.setQuantity(fromExpr);
                entry.setColor(fromColorExpr);
                colorMap.addColorMapEntry(entry);
            }
        } else if (valuesList.size() == 1) {
            String fromValueStr = (String)valuesList.get(0);
            Color fromColor = (Color)colorsList.get(0);
            Expression fromColorExpr = sB.colorExpression(new Color(fromColor.getRed(), fromColor.getGreen(), fromColor.getBlue(), 255));
            Expression fromExpr = sB.literalExpression(Double.parseDouble(fromValueStr));
            ColorMapEntry entry = this.sf.createColorMapEntry();
            entry.setQuantity(fromExpr);
            entry.setColor(fromColorExpr);
            colorMap.addColorMapEntry(entry);
            colorMap.addColorMapEntry(entry);
        } else {
            throw new IllegalArgumentException();
        }
        rasterSym.setColorMap((ColorMap)colorMap);
        int alpha = ctable.getAlpha();
        rasterSym.setOpacity(sB.literalExpression((double)alpha / 255.0));
        Style newStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSym});
        return newStyle;
    }
}

