/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.geometry;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import com.vividsolutions.jts.noding.IntersectionAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.jgrasstools.gears.libs.monitor.DummyProgressMonitor;
import org.jgrasstools.gears.utils.geometry.GeometryType;
import org.jgrasstools.gears.utils.math.NumericsUtilities;
import org.jgrasstools.gears.utils.sorting.QuickSortAlgorithm;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.operation.MathTransform;

public class GeometryUtilities {
    public static Geometry[] TYPE_GEOMETRY = new Geometry[0];
    public static Polygon[] TYPE_POLYGON = new Polygon[0];
    public static MultiPolygon[] TYPE_MULTIPOLYGON = new MultiPolygon[0];
    public static LineString[] TYPE_LINESTRING = new LineString[0];
    public static MultiLineString[] TYPE_MULTILINESTRING = new MultiLineString[0];
    public static Point[] TYPE_POINT = new Point[0];
    public static MultiPoint[] TYPE_MULTIPOINT = new MultiPoint[0];
    private static GeometryFactory geomFactory;
    private static PrecisionModel precModel;

    public static PrecisionModel basicPrecisionModel() {
        return GeometryUtilities.pm();
    }

    public static GeometryFactory gf() {
        if (geomFactory == null) {
            geomFactory = new GeometryFactory(GeometryUtilities.pm());
        }
        return geomFactory;
    }

    public static PrecisionModel pm() {
        if (precModel == null) {
            precModel = new PrecisionModel(PrecisionModel.FLOATING);
        }
        return precModel;
    }

    public static Polygon createSimplePolygon(Coordinate[] coords) {
        LinearRing linearRing = GeometryUtilities.gf().createLinearRing(coords);
        return GeometryUtilities.gf().createPolygon(linearRing, null);
    }

    public static Polygon createDummyPolygon() {
        Coordinate[] c = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(1.0, 0.0), new Coordinate(0.0, 0.0)};
        LinearRing linearRing = GeometryUtilities.gf().createLinearRing(c);
        return GeometryUtilities.gf().createPolygon(linearRing, null);
    }

    public static LineString createDummyLine() {
        Coordinate[] c = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(1.0, 0.0)};
        LineString lineString = GeometryUtilities.gf().createLineString(c);
        return lineString;
    }

    public static Point createDummyPoint() {
        Point point = GeometryUtilities.gf().createPoint(new Coordinate(0.0, 0.0));
        return point;
    }

    public static Polygon createPolygonFromEnvelope(Envelope env) {
        Coordinate[] c = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
        LinearRing linearRing = GeometryUtilities.gf().createLinearRing(c);
        return GeometryUtilities.gf().createPolygon(linearRing, null);
    }

    public static List<Geometry> extractSubGeometries(Geometry geometry) {
        ArrayList<Geometry> geometriesList = new ArrayList<Geometry>();
        int numGeometries = geometry.getNumGeometries();
        for (int i = 0; i < numGeometries; ++i) {
            Geometry geometryN = geometry.getGeometryN(i);
            geometriesList.add(geometryN);
        }
        return geometriesList;
    }

    public static double angleBetween(LineSegment l1, LineSegment l2) {
        double azimuth2;
        double azimuth1 = GeometryUtilities.azimuth(l1.p0, l1.p1);
        if (azimuth1 < (azimuth2 = GeometryUtilities.azimuth(l2.p0, l2.p1))) {
            return azimuth2 - azimuth1;
        }
        return 360.0 - azimuth1 + azimuth2;
    }

    public static double azimuth(Coordinate c1, Coordinate c2) {
        if (c1.x == c2.x) {
            if (c1.y == c2.y) {
                return Double.NaN;
            }
            if (c1.y < c2.y) {
                return 0.0;
            }
            if (c1.y > c2.y) {
                return 180.0;
            }
        }
        if (c1.y == c2.y) {
            if (c1.x < c2.x) {
                return 90.0;
            }
            if (c1.x > c2.x) {
                return 270.0;
            }
        }
        if (c1.x < c2.x && c1.y < c2.y) {
            double tanA = (c2.x - c1.x) / (c2.y - c1.y);
            double atan = Math.atan(tanA);
            return Math.toDegrees(atan);
        }
        if (c1.x < c2.x && c1.y > c2.y) {
            double tanA = (c1.y - c2.y) / (c2.x - c1.x);
            double atan = Math.atan(tanA);
            return Math.toDegrees(atan) + 90.0;
        }
        if (c1.x > c2.x && c1.y > c2.y) {
            double tanA = (c1.x - c2.x) / (c1.y - c2.y);
            double atan = Math.atan(tanA);
            return Math.toDegrees(atan) + 180.0;
        }
        if (c1.x > c2.x && c1.y < c2.y) {
            double tanA = (c2.y - c1.y) / (c1.x - c2.x);
            double atan = Math.atan(tanA);
            return Math.toDegrees(atan) + 270.0;
        }
        return Double.NaN;
    }

    public static GeometryType getGeometryType(Geometry geometry) {
        if (geometry instanceof LineString) {
            return GeometryType.LINE;
        }
        if (geometry instanceof MultiLineString) {
            return GeometryType.MULTILINE;
        }
        if (geometry instanceof Point) {
            return GeometryType.POINT;
        }
        if (geometry instanceof MultiPoint) {
            return GeometryType.MULTIPOINT;
        }
        if (geometry instanceof Polygon) {
            return GeometryType.POLYGON;
        }
        if (geometry instanceof MultiPolygon) {
            return GeometryType.MULTIPOLYGON;
        }
        if (geometry instanceof GeometryCollection) {
            return GeometryType.GEOMETRYCOLLECTION;
        }
        return null;
    }

    public static GeometryType getGeometryType(org.opengis.feature.type.GeometryType geometryType) {
        Class binding = geometryType.getBinding();
        if (binding == LineString.class) {
            return GeometryType.LINE;
        }
        if (binding == MultiLineString.class) {
            return GeometryType.MULTILINE;
        }
        if (binding == Point.class) {
            return GeometryType.POINT;
        }
        if (binding == MultiPoint.class) {
            return GeometryType.MULTIPOINT;
        }
        if (binding == Polygon.class) {
            return GeometryType.POLYGON;
        }
        if (binding == MultiPolygon.class) {
            return GeometryType.MULTIPOLYGON;
        }
        return null;
    }

    public static boolean isLine(Geometry geometry) {
        return geometry instanceof LineString || geometry instanceof MultiLineString;
    }

    public static boolean isLine(GeometryDescriptor geometryDescriptor) {
        org.opengis.feature.type.GeometryType type = geometryDescriptor.getType();
        Class binding = type.getBinding();
        return binding == MultiLineString.class || binding == LineString.class;
    }

    public static boolean isPolygon(Geometry geometry) {
        return geometry instanceof Polygon || geometry instanceof MultiPolygon;
    }

    public static boolean isPolygon(GeometryDescriptor geometryDescriptor) {
        org.opengis.feature.type.GeometryType type = geometryDescriptor.getType();
        Class binding = type.getBinding();
        return binding == MultiPolygon.class || binding == Polygon.class;
    }

    public static boolean isPoint(Geometry geometry) {
        return geometry instanceof Point || geometry instanceof MultiPoint;
    }

    public static boolean isPoint(GeometryDescriptor geometryDescriptor) {
        org.opengis.feature.type.GeometryType type = geometryDescriptor.getType();
        Class binding = type.getBinding();
        return binding == MultiPoint.class || binding == Point.class;
    }

    public static double getPolygonArea(int[] x, int[] y, int N) {
        double area = 0.0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            area += (double)(x[i] * y[j]);
            area -= (double)(y[i] * x[j]);
        }
        return (area /= 2.0) < 0.0 ? -area : area;
    }

    public static double distance3d(Coordinate c1, Coordinate c2, GeodeticCalculator geodeticCalculator) {
        double projectedDistance;
        if (Double.isNaN(c1.z) || Double.isNaN(c2.z)) {
            throw new IllegalArgumentException("Missing elevation information in the supplied coordinates.");
        }
        double deltaElev = Math.abs(c1.z - c2.z);
        if (geodeticCalculator != null) {
            geodeticCalculator.setStartingGeographicPoint(c1.x, c1.y);
            geodeticCalculator.setDestinationGeographicPoint(c2.x, c2.y);
            projectedDistance = geodeticCalculator.getOrthodromicDistance();
        } else {
            projectedDistance = c1.distance(c2);
        }
        double distance = NumericsUtilities.pythagoras(projectedDistance, deltaElev);
        return distance;
    }

    public static void sortHorizontal(Coordinate[] coordinates) {
        int i;
        QuickSortAlgorithm sorter = new QuickSortAlgorithm(new DummyProgressMonitor());
        double[] x = new double[coordinates.length];
        double[] y = new double[coordinates.length];
        for (i = 0; i < x.length; ++i) {
            x[i] = coordinates[i].x;
            y[i] = coordinates[i].y;
        }
        sorter.sort(x, y);
        for (i = 0; i < x.length; ++i) {
            coordinates[i].x = x[i];
            coordinates[i].y = y[i];
        }
    }

    public static Polygon lines2Polygon(boolean checkValid, LineString ... lines) {
        ArrayList<Object> coordinatesList = new ArrayList<Object>();
        ArrayList<LineString> linesList = new ArrayList<LineString>();
        for (LineString tmpLine : lines) {
            linesList.add(tmpLine);
        }
        LineString currentLine = (LineString)linesList.get(0);
        linesList.remove(0);
        while (linesList.size() > 0) {
            Coordinate[] coordinates = currentLine.getCoordinates();
            List<Coordinate> tmpList = Arrays.asList(coordinates);
            coordinatesList.addAll(tmpList);
            Point thePoint = currentLine.getEndPoint();
            double minDistance = Double.MAX_VALUE;
            LineString minDistanceLine = null;
            boolean needFlip = false;
            for (LineString tmpLine : linesList) {
                Point tmpEndPoint;
                Point tmpStartPoint = tmpLine.getStartPoint();
                double distance = thePoint.distance((Geometry)tmpStartPoint);
                if (distance < minDistance) {
                    minDistance = distance;
                    minDistanceLine = tmpLine;
                    needFlip = false;
                }
                if (!((distance = thePoint.distance((Geometry)(tmpEndPoint = tmpLine.getEndPoint()))) < minDistance)) continue;
                minDistance = distance;
                minDistanceLine = tmpLine;
                needFlip = true;
            }
            linesList.remove(minDistanceLine);
            if (needFlip) {
                minDistanceLine = (LineString)minDistanceLine.reverse();
            }
            currentLine = minDistanceLine;
        }
        Coordinate[] coordinates = currentLine.getCoordinates();
        List<Coordinate> tmpList = Arrays.asList(coordinates);
        coordinatesList.addAll(tmpList);
        coordinatesList.add(coordinatesList.get(0));
        LinearRing linearRing = GeometryUtilities.gf().createLinearRing(coordinatesList.toArray(new Coordinate[0]));
        Polygon polygon = GeometryUtilities.gf().createPolygon(linearRing, null);
        if (checkValid && !polygon.isValid()) {
            return null;
        }
        return polygon;
    }

    public static List<Coordinate> getCoordinatesAtInterval(LineString line, double interval, boolean keepExisting, double startFrom, double endAt) {
        if (interval <= 0.0) {
            throw new IllegalArgumentException("Interval needs to be > 0.");
        }
        double length = line.getLength();
        if (startFrom < 0.0) {
            startFrom = 0.0;
        }
        if (endAt < 0.0) {
            endAt = length;
        }
        ArrayList<Coordinate> coordinatesList = new ArrayList<Coordinate>();
        LengthIndexedLine indexedLine = new LengthIndexedLine((Geometry)line);
        Coordinate[] existingCoordinates = null;
        double[] indexOfExisting = null;
        if (keepExisting) {
            existingCoordinates = line.getCoordinates();
            indexOfExisting = new double[existingCoordinates.length];
            int i = 0;
            for (Coordinate coordinate : existingCoordinates) {
                double indexOf;
                indexOfExisting[i] = indexOf = indexedLine.indexOf(coordinate);
                ++i;
            }
        }
        double runningLength = startFrom;
        int currentIndexOfexisting = 1;
        while (runningLength < endAt) {
            if (keepExisting && currentIndexOfexisting < indexOfExisting.length - 1 && runningLength > indexOfExisting[currentIndexOfexisting]) {
                coordinatesList.add(existingCoordinates[currentIndexOfexisting]);
                ++currentIndexOfexisting;
                continue;
            }
            Coordinate extractedPoint = indexedLine.extractPoint(runningLength);
            coordinatesList.add(extractedPoint);
            runningLength += interval;
        }
        Coordinate extractedPoint = indexedLine.extractPoint(endAt);
        coordinatesList.add(extractedPoint);
        return coordinatesList;
    }

    public static List<LineString> getSectionsFromCoordinates(List<Coordinate> coordinates, double width) {
        if (coordinates.size() < 3) {
            throw new IllegalArgumentException("This method works only on lines with at least 3 coordinates.");
        }
        double halfWidth = width / 2.0;
        ArrayList<LineString> linesList = new ArrayList<LineString>();
        Coordinate centerCoordinate = coordinates.get(0);
        LineSegment l1 = new LineSegment(centerCoordinate, coordinates.get(1));
        Coordinate leftCoordinate = l1.pointAlongOffset(0.0, halfWidth);
        Coordinate rightCoordinate = l1.pointAlongOffset(0.0, -halfWidth);
        LineString lineString = geomFactory.createLineString(new Coordinate[]{leftCoordinate, centerCoordinate, rightCoordinate});
        linesList.add(lineString);
        for (int i = 1; i < coordinates.size() - 1; ++i) {
            Coordinate previous = coordinates.get(i - 1);
            Coordinate current = coordinates.get(i);
            Coordinate after = coordinates.get(i + 1);
            double firstAngle = GeometryUtilities.azimuth(current, previous);
            double secondAngle = GeometryUtilities.azimuth(current, after);
            double a1 = Math.min(firstAngle, secondAngle);
            double a2 = Math.max(firstAngle, secondAngle);
            double centerAngle = a1 + (a2 - a1) / 2.0;
            AffineTransformation rotationInstance = AffineTransformation.rotationInstance((double)(-Math.toRadians(centerAngle)), (double)current.x, (double)current.y);
            LineString vertical = geomFactory.createLineString(new Coordinate[]{new Coordinate(current.x, current.y + halfWidth), current, new Coordinate(current.x, current.y - halfWidth)});
            Geometry transformed = rotationInstance.transform((Geometry)vertical);
            linesList.add((LineString)transformed);
        }
        centerCoordinate = coordinates.get(coordinates.size() - 1);
        LineSegment l2 = new LineSegment(centerCoordinate, coordinates.get(coordinates.size() - 2));
        leftCoordinate = l2.pointAlongOffset(0.0, halfWidth);
        rightCoordinate = l2.pointAlongOffset(0.0, -halfWidth);
        lineString = geomFactory.createLineString(new Coordinate[]{leftCoordinate, centerCoordinate, rightCoordinate});
        linesList.add(lineString);
        return linesList;
    }

    public static List<LineString> getSectionsAtInterval(LineString line, double interval, double width, double startFrom, double endAt) {
        LineString lineString;
        Coordinate rightCoordinate;
        Coordinate leftCoordinate;
        Coordinate centerCoordinate;
        if (interval <= 0.0) {
            throw new IllegalArgumentException("Interval needs to be > 0.");
        }
        double length = line.getLength();
        if (startFrom < 0.0) {
            startFrom = 0.0;
        }
        if (endAt < 0.0) {
            endAt = length;
        }
        double halfWidth = width / 2.0;
        ArrayList<LineString> linesList = new ArrayList<LineString>();
        LengthIndexedLine indexedLine = new LengthIndexedLine((Geometry)line);
        for (double runningLength = startFrom; runningLength < endAt; runningLength += interval) {
            centerCoordinate = indexedLine.extractPoint(runningLength);
            leftCoordinate = indexedLine.extractPoint(runningLength, -halfWidth);
            rightCoordinate = indexedLine.extractPoint(runningLength, halfWidth);
            lineString = geomFactory.createLineString(new Coordinate[]{leftCoordinate, centerCoordinate, rightCoordinate});
            linesList.add(lineString);
        }
        centerCoordinate = indexedLine.extractPoint(endAt);
        leftCoordinate = indexedLine.extractPoint(endAt, -halfWidth);
        rightCoordinate = indexedLine.extractPoint(endAt, halfWidth);
        lineString = geomFactory.createLineString(new Coordinate[]{leftCoordinate, centerCoordinate, rightCoordinate});
        linesList.add(lineString);
        return linesList;
    }

    public static STRtree geometriesToSRTree(List<Geometry> geometries) {
        STRtree tree = new STRtree();
        for (Geometry geometry : geometries) {
            tree.insert(geometry.getEnvelopeInternal(), (Object)geometry);
        }
        return tree;
    }

    public static Quadtree geometriesToQuadTree(List<Geometry> geometries) {
        Quadtree tree = new Quadtree();
        for (Geometry geometry : geometries) {
            tree.insert(geometry.getEnvelopeInternal(), (Object)geometry);
        }
        return tree;
    }

    public static List<Polygon> splitPolygon(Polygon polygon, LineString line) {
        IntersectionAdder _intersector = new IntersectionAdder((LineIntersector)new RobustLineIntersector());
        MCIndexNoder mci = new MCIndexNoder();
        mci.setSegmentIntersector((SegmentIntersector)_intersector);
        NodedSegmentString pSeg = new NodedSegmentString(polygon.getCoordinates(), null);
        NodedSegmentString lSeg = new NodedSegmentString(line.getCoordinates(), null);
        ArrayList<NodedSegmentString> nodesSegmentStringList = new ArrayList<NodedSegmentString>();
        nodesSegmentStringList.add(pSeg);
        nodesSegmentStringList.add(lSeg);
        mci.computeNodes(nodesSegmentStringList);
        Polygonizer polygonizer = new Polygonizer();
        ArrayList<LineString> lsList = new ArrayList<LineString>();
        for (Object o : mci.getMonotoneChains()) {
            MonotoneChain mtc = (MonotoneChain)o;
            LineString l = GeometryUtilities.gf().createLineString(mtc.getCoordinates());
            lsList.add(l);
        }
        Geometry nodedLineStrings = (Geometry)lsList.get(0);
        for (int i = 1; i < lsList.size(); ++i) {
            nodedLineStrings = nodedLineStrings.union((Geometry)lsList.get(i));
        }
        polygonizer.add(nodedLineStrings);
        Collection polygons = polygonizer.getPolygons();
        ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
        PointLocator pl = new PointLocator();
        for (Polygon p : polygons) {
            if (pl.locate(p.getInteriorPoint().getCoordinate(), (Geometry)p) != 0) continue;
            newPolygons.add(p);
        }
        return newPolygons;
    }

    public static void scaleToRatio(Rectangle2D fixed, Rectangle2D toScale, boolean doShrink) {
        double origWidth = fixed.getWidth();
        double origHeight = fixed.getHeight();
        double toAdaptWidth = toScale.getWidth();
        double toAdaptHeight = toScale.getHeight();
        double scaleWidth = 0.0;
        double scaleHeight = 0.0;
        scaleWidth = toAdaptWidth / origWidth;
        scaleHeight = toAdaptHeight / origHeight;
        double scaleFactor = doShrink ? Math.min(scaleWidth, scaleHeight) : Math.max(scaleWidth, scaleHeight);
        double newWidth = origWidth * scaleFactor;
        double newHeight = origHeight * scaleFactor;
        double dw = (toAdaptWidth - newWidth) / 2.0;
        double dh = (toAdaptHeight - newHeight) / 2.0;
        double newX = toScale.getX() + dw;
        double newY = toScale.getY() + dh;
        double newW = toAdaptWidth - 2.0 * dw;
        double newH = toAdaptHeight - 2.0 * dh;
        toScale.setRect(newX, newY, newW, newH);
    }

    public static double[] getPlaneCoefficientsFrom3Points(Coordinate c1, Coordinate c2, Coordinate c3) {
        double a = (c2.y - c1.y) * (c3.z - c1.z) - (c3.y - c1.y) * (c2.z - c1.z);
        double b = (c2.z - c1.z) * (c3.x - c1.x) - (c3.z - c1.z) * (c2.x - c1.x);
        double c = (c2.x - c1.x) * (c3.y - c1.y) - (c3.x - c1.x) * (c2.y - c1.y);
        double d = -1.0 * (a * c1.x + b * c1.y + c * c1.z);
        return new double[]{a, b, c, d};
    }

    public static Coordinate getLineWithPlaneIntersection(Coordinate lC1, Coordinate lC2, Coordinate pC1, Coordinate pC2, Coordinate pC3) {
        double[] p = GeometryUtilities.getPlaneCoefficientsFrom3Points(pC1, pC2, pC3);
        double denominator = p[0] * (lC1.x - lC2.x) + p[1] * (lC1.y - lC2.y) + p[2] * (lC1.z - lC2.z);
        if (denominator == 0.0) {
            return null;
        }
        double u = (p[0] * lC1.x + p[1] * lC1.y + p[2] * lC1.z + p[3]) / denominator;
        double x = lC1.x + (lC2.x - lC1.x) * u;
        double y = lC1.y + (lC2.y - lC1.y) * u;
        double z = lC1.z + (lC2.z - lC1.z) * u;
        return new Coordinate(x, y, z);
    }

    public static double getAngleBetweenLinePlane(Coordinate a, Coordinate d, Coordinate b, Coordinate c) {
        double[] rAD = new double[]{d.x - a.x, d.y - a.y, d.z - a.z};
        double[] rDB = new double[]{b.x - d.x, b.y - d.y, b.z - d.z};
        double[] rDC = new double[]{c.x - d.x, c.y - d.y, c.z - d.z};
        double[] n = new double[]{rDB[1] * rDC[2] - rDC[1] * rDB[2], -1.0 * (rDB[0] * rDC[2] - rDC[0] * rDB[2]), rDB[0] * rDC[1] - rDC[0] * rDB[1]};
        double cosNum = n[0] * rAD[0] + n[1] * rAD[1] + n[2] * rAD[2];
        double cosDen = Math.sqrt(n[0] * n[0] + n[1] * n[1] + n[2] * n[2]) * Math.sqrt(rAD[0] * rAD[0] + rAD[1] * rAD[1] + rAD[2] * rAD[2]);
        double cos90MinAlpha = Math.abs(cosNum / cosDen);
        double alpha = 90.0 - Math.toDegrees(Math.acos(cos90MinAlpha));
        return alpha;
    }

    public static double getShortestDistanceFromTriangle(Coordinate c, Coordinate pC1, Coordinate pC2, Coordinate pC3) {
        double[] p = GeometryUtilities.getPlaneCoefficientsFrom3Points(pC1, pC2, pC3);
        double result = (p[0] * c.x + p[1] * c.y + p[2] * c.z + p[3]) / Math.sqrt(p[0] * p[0] + p[1] * p[1] + p[2] * p[2]);
        return result;
    }

    public static double getAngleInTriangle(double a, double b, double c) {
        double angle = Math.acos((a * a + b * b - c * c) / (2.0 * a * b));
        return angle;
    }

    public static double angleBetween3D(Coordinate c1, Coordinate c2, Coordinate c3) {
        double a = GeometryUtilities.distance3d(c2, c1, null);
        double b = GeometryUtilities.distance3d(c2, c3, null);
        double c = GeometryUtilities.distance3d(c1, c3, null);
        double angleInTriangle = GeometryUtilities.getAngleInTriangle(a, b, c);
        double degrees = Math.toDegrees(angleInTriangle);
        return degrees;
    }

    public static int getTriangleWindingRule(Coordinate A, Coordinate B, Coordinate C) {
        double[] rBA = new double[]{B.x - A.x, B.y - A.y, B.z - A.z};
        double[] rCA = new double[]{C.x - A.x, C.y - A.y, C.z - A.z};
        double[] crossProduct = new double[]{rBA[1] * rCA[2] - rBA[2] * rCA[1], -1.0 * (rBA[0] * rCA[2] - rBA[2] * rCA[0]), rBA[0] * rCA[1] - rBA[1] * rCA[0]};
        return crossProduct[2] > 0.0 ? 1 : -1;
    }

    public static Coordinate getTriangleCentroid(Coordinate A, Coordinate B, Coordinate C) {
        double cx = (A.x + B.x + C.x) / 3.0;
        double cy = (A.y + B.y + C.y) / 3.0;
        double cz = (A.z + B.z + C.z) / 3.0;
        return new Coordinate(cx, cy, cz);
    }

    public static Geometry scaleToUnitaryArea(Geometry polygon) throws Exception {
        double area = polygon.getArea();
        double scale = Math.sqrt(1.0 / area);
        AffineTransform scaleAT = new AffineTransform();
        scaleAT.scale(scale, scale);
        AffineTransform2D scaleTransform = new AffineTransform2D(scaleAT);
        polygon = JTS.transform((Geometry)polygon, (MathTransform)scaleTransform);
        return polygon;
    }
}

