/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.files;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class FilesFinder {
    private List<File> filesList = new ArrayList<File>();
    private final File file;
    private final String regex;

    public FilesFinder(File file, String regex) {
        this.file = file;
        this.regex = regex;
    }

    public List<File> getFilesList() {
        return this.filesList;
    }

    public List<File> process() {
        if (this.file == null || !this.file.exists() || !this.file.canRead()) {
            throw new IllegalArgumentException("Directory not readable.");
        }
        if (!this.file.isDirectory() && this.file.getName().matches(".*" + this.regex + ".*")) {
            this.filesList.add(this.file);
            return this.filesList;
        }
        this.addToList(this.file);
        return this.filesList;
    }

    private void addToList(File folder) {
        File[] filesArray;
        for (File file : filesArray = folder.listFiles()) {
            if (file.getName().matches(".*" + this.regex + ".*") && !file.isDirectory()) {
                this.filesList.add(file);
            }
            if (!file.isDirectory()) continue;
            this.addToList(file);
        }
    }
}

