/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.colors;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.jgrasstools.gears.utils.SldUtilities;
import org.jgrasstools.gears.utils.colors.ColorTables;
import org.jgrasstools.gears.utils.colors.DefaultTables;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.jgrasstools.gears.utils.math.NumericsUtilities;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ColorMap;

public class RasterStyleUtilities {
    private static StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);

    public static void dumpRasterStyle(String path, double min, double max, double[] values, Color[] colors, double opacity) throws Exception {
        String styleStr = RasterStyleUtilities.createRasterStyleString(min, max, values, colors, opacity);
        FileUtilities.writeFile(styleStr, new File(path));
    }

    private static String createRasterStyleString(double min, double max, double[] values, Color[] colors, double opacity) throws Exception {
        Style newStyle = RasterStyleUtilities.createRasterStyle(min, max, values, colors, opacity);
        String styleStr = SldUtilities.styleToString(newStyle);
        return styleStr;
    }

    private static Style createRasterStyle(double min, double max, double[] values, Color[] colors, double opacity) {
        StyleBuilder sB = new StyleBuilder(sf);
        RasterSymbolizer rasterSym = sf.createRasterSymbolizer();
        int colorsNum = colors.length;
        boolean hasAllValues = false;
        if (values != null) {
            hasAllValues = true;
        }
        double interval = (max - min) / (double)(colorsNum - 1);
        double runningValue = min;
        org.geotools.styling.ColorMap colorMap = sf.createColorMap();
        Expression whiteColorExpr = sB.colorExpression(Color.white);
        Expression novalExpr = sB.literalExpression(-9999);
        Expression zeroOpacityExpr = sB.literalExpression(0);
        ColorMapEntry novalueEntry = sf.createColorMapEntry();
        novalueEntry.setQuantity(novalExpr);
        novalueEntry.setColor(whiteColorExpr);
        novalueEntry.setOpacity(zeroOpacityExpr);
        colorMap.addColorMapEntry(novalueEntry);
        for (int i = 0; i < colors.length - 1; ++i) {
            ColorMapEntry entry;
            double end;
            double start;
            Color fromColor = colors[i];
            Color toColor = colors[i + 1];
            if (hasAllValues) {
                start = values[i];
                end = values[i + 1];
            } else {
                start = runningValue;
                end = runningValue += interval;
            }
            Expression opacityExpr = sB.literalExpression(opacity);
            if (i == 0) {
                Expression fromColorExpr = sB.colorExpression(fromColor);
                Expression fromExpr = sB.literalExpression(start);
                entry = sf.createColorMapEntry();
                entry.setQuantity(fromExpr);
                entry.setColor(fromColorExpr);
                entry.setOpacity(opacityExpr);
                colorMap.addColorMapEntry(entry);
            }
            if (NumericsUtilities.dEq(start, end)) continue;
            Expression toColorExpr = sB.colorExpression(toColor);
            Expression toExpr = sB.literalExpression(end);
            entry = sf.createColorMapEntry();
            entry.setQuantity(toExpr);
            entry.setOpacity(opacityExpr);
            entry.setColor(toColorExpr);
            colorMap.addColorMapEntry(entry);
        }
        rasterSym.setColorMap((ColorMap)colorMap);
        rasterSym.setOpacity(sB.literalExpression(opacity));
        Style newStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSym});
        return newStyle;
    }

    public static String createStyleForColortable(String colorTableName, double min, double max, double[] values, double opacity) throws Exception {
        ArrayList<Color> colorList = new ArrayList<Color>();
        String tableString = new DefaultTables().getTableString(colorTableName);
        if (tableString == null) {
            return null;
        }
        String[] split = tableString.split("\n");
        ArrayList<Double> newValues = null;
        for (String line : split) {
            int b1;
            int g1;
            int r1;
            if (line.startsWith("#")) continue;
            String[] lineSplit = line.trim().split("\\s+");
            if (lineSplit.length == 3) {
                int r = Integer.parseInt(lineSplit[0]);
                int g = Integer.parseInt(lineSplit[1]);
                int b = Integer.parseInt(lineSplit[2]);
                colorList.add(new Color(r, g, b));
                continue;
            }
            if (lineSplit.length == 8) {
                if (newValues == null) {
                    newValues = new ArrayList<Double>();
                }
                double v1 = Double.parseDouble(lineSplit[0]);
                r1 = Integer.parseInt(lineSplit[1]);
                g1 = Integer.parseInt(lineSplit[2]);
                b1 = Integer.parseInt(lineSplit[3]);
                colorList.add(new Color(r1, g1, b1));
                newValues.add(v1);
                double v2 = Double.parseDouble(lineSplit[4]);
                int r2 = Integer.parseInt(lineSplit[5]);
                int g2 = Integer.parseInt(lineSplit[6]);
                int b2 = Integer.parseInt(lineSplit[7]);
                colorList.add(new Color(r2, g2, b2));
                newValues.add(v2);
                continue;
            }
            if (lineSplit.length != 4) continue;
            if (newValues == null) {
                newValues = new ArrayList();
            }
            double v1 = Double.parseDouble(lineSplit[0]);
            r1 = Integer.parseInt(lineSplit[1]);
            g1 = Integer.parseInt(lineSplit[2]);
            b1 = Integer.parseInt(lineSplit[3]);
            colorList.add(new Color(r1, g1, b1));
            newValues.add(v1);
        }
        Color[] colorsArray = colorList.toArray(new Color[0]);
        if (newValues != null) {
            values = new double[newValues.size()];
            for (int i = 0; i < newValues.size(); ++i) {
                values[i] = (Double)newValues.get(i);
            }
        }
        return RasterStyleUtilities.createRasterStyleString(min, max, values, colorsArray, opacity);
    }

    public static void main(String[] args) throws Exception {
        double[] values = new double[]{0.0, 360.0};
        String createStyleForColortable = RasterStyleUtilities.createStyleForColortable(ColorTables.extrainbow.name(), 73.835, 144.889, null, 0.8);
        System.out.println(createStyleForColortable);
    }
}

