/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.joda.time.DateTime;

public class CompressionUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFolder(String srcFolder, String destZipFile, boolean addBaseFolder) throws IOException {
        if (new File(srcFolder).isDirectory()) {
            DeflaterOutputStream zip = null;
            FileOutputStream fileWriter = null;
            try {
                fileWriter = new FileOutputStream(destZipFile);
                zip = new ZipOutputStream(fileWriter);
                CompressionUtilities.addFolderToZip("", srcFolder, (ZipOutputStream)zip, addBaseFolder);
            }
            finally {
                if (zip != null) {
                    zip.flush();
                    ((ZipOutputStream)zip).close();
                }
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
        } else {
            throw new IOException(srcFolder + " is not a folder.");
        }
    }

    public static void main(String[] args) throws IOException {
        String zip = "/home/moovida/TMP/AAAAAAA/geopaparazzi_giovanni.zip";
        String outFolder = "/home/moovida/TMP/AAAAAAA/";
        CompressionUtilities.unzipFolder(zip, outFolder, true);
    }

    public static String unzipFolder(String zipFile, String destFolder, boolean addTimeStamp) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> zipEnum = zf.entries();
        String firstName = null;
        String newFirstName = null;
        while (zipEnum.hasMoreElements()) {
            int firstSlash;
            ZipEntry item = zipEnum.nextElement();
            String itemName = item.getName();
            if (firstName == null && (firstSlash = itemName.indexOf(47)) != -1) {
                newFirstName = firstName = itemName.substring(0, firstSlash);
                File baseFile = new File(destFolder + File.separator + firstName);
                if (baseFile.exists()) {
                    if (addTimeStamp) {
                        newFirstName = firstName + "_" + new DateTime().toString(JGTConstants.dateTimeFormatterYYYYMMDDHHMMSScompact);
                    } else {
                        throw new IOException("Not overwriting existing: " + baseFile);
                    }
                }
            }
            if (firstName == null) {
                throw new IOException();
            }
            itemName = itemName.replaceFirst(firstName, newFirstName);
            if (item.isDirectory()) {
                File newdir = new File(destFolder + File.separator + itemName);
                if (newdir.mkdir()) continue;
                throw new IOException();
            }
            String newfilePath = destFolder + File.separator + itemName;
            File newFile = new File(newfilePath);
            File parentFile = newFile.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new IOException();
            }
            InputStream is = zf.getInputStream(item);
            FileOutputStream fos = new FileOutputStream(newfilePath);
            byte[] buffer = new byte[512];
            int readchars = 0;
            while ((readchars = is.read(buffer)) != -1) {
                fos.write(buffer, 0, readchars);
            }
            is.close();
            fos.close();
        }
        zf.close();
        return newFirstName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToZip(String path, String srcFile, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            CompressionUtilities.addFolderToZip(path, srcFile, zip, true);
        } else {
            byte[] buf = new byte[1024];
            FileInputStream in = null;
            try {
                int len;
                in = new FileInputStream(srcFile);
                zip.putNextEntry(new ZipEntry(path + File.separator + folder.getName()));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip, boolean addFolder) throws IOException {
        File folder = new File(srcFolder);
        String[] listOfFiles = folder.list();
        for (int i = 0; i < listOfFiles.length; ++i) {
            String folderPath = null;
            folderPath = path.length() < 1 ? folder.getName() : path + File.separator + folder.getName();
            String srcFile = srcFolder + File.separator + listOfFiles[i];
            CompressionUtilities.addToZip(folderPath, srcFile, zip);
        }
    }
}

