/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.imageio.ImageIO;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.files.FileUtilities;

@Description(value="Utility class for charting matrix data.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Viewer, UI, Chart")
@Label(value="Others")
@Name(value="matrixcharter")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class OmsMatrixCharter
extends JGTModel {
    @Description(value="The matrix to chart.")
    @In
    public double[][] inData;
    @Description(value="A list of data to chart, in the case the xy data ar different for each series.")
    @In
    public List<double[][]> inDataXY;
    @Description(value="The data title.")
    @In
    public String inTitle;
    @Description(value="The subtitle.")
    @In
    public String inSubTitle;
    @Description(value="The data series names.")
    @In
    public String[] inSeries;
    @Description(value="The optional data series colors. Format is rbg triplets delimited by semicolon: ex. 0,0,255;0,255,0;255,0,0. The colors have to be the same number as the series.")
    @In
    public String inColors;
    @Description(value="The axis labels (x, y1, y2, ...).")
    @In
    public String[] inLabels;
    @Description(value="The data formats (dates and numeric formatting patterns).")
    @In
    public String[] inFormats;
    @Description(value="The data types (dates or numerics like double, int).")
    @In
    public String[] inTypes;
    @Description(value="Chart type: 0 = line, 1 = histogram (default is 0).")
    @In
    public int pType = 0;
    @Description(value="Chart the data.")
    @In
    public boolean doChart;
    @Description(value="Dump the chart to disk.")
    @In
    public boolean doDump;
    @Description(value="Show the legend.")
    @In
    public boolean doLegend;
    @Description(value="Show shapes in line charts.")
    @In
    public boolean doPoints;
    @Description(value="Cumulate data.")
    @In
    public boolean doCumulate;
    @Description(value="Normalize data.")
    @In
    public boolean doNormalize;
    @Description(value="Make chart horizontal.")
    @In
    public boolean doHorizontal;
    @Description(value="Chart image width (in case of doDump=true, defaults to 800 px).")
    @In
    public int pWidth = 800;
    @Description(value="Chart image height (in case of doDump=true, defaults to 600 px).")
    @In
    public int pHeight = 600;
    @Description(value="Chart dump path (in case of doDump=true).")
    @In
    public String inChartPath;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double minInterval = 1000.0;

    @Execute
    public void chart() throws Exception {
        if (this.inData == null && this.inDataXY == null) {
            throw new ModelsIllegalargumentException("At least one of the datasets need to be valid.", this, this.pm);
        }
        if (this.doDump) {
            this.checkNull(this.inChartPath);
        }
        JFreeChart chart = null;
        chart = this.pType == 0 ? this.doLineChart() : this.doBarChart();
        if (this.inSubTitle != null) {
            TextTitle subTitle = new TextTitle(this.inSubTitle);
            chart.addSubtitle((Title)subTitle);
        }
        chart.setTextAntiAlias(true);
        if (this.doDump) {
            File chartFile = new File(this.inChartPath);
            if (!chartFile.getName().endsWith(".png")) {
                chartFile = FileUtilities.substituteExtention(chartFile, "png");
            }
            BufferedImage bufferedImage = chart.createBufferedImage(this.pWidth, this.pHeight);
            ImageIO.write((RenderedImage)bufferedImage, "png", chartFile);
        }
        if (this.doChart) {
            ChartPanel cp = new ChartPanel(chart);
            cp.setDomainZoomable(true);
            cp.setRangeZoomable(true);
            ApplicationFrame af = new ApplicationFrame("");
            af.setContentPane((Container)cp);
            af.setPreferredSize(new Dimension(this.pWidth, this.pHeight));
            af.pack();
            af.setVisible(true);
            RefineryUtilities.centerFrameOnScreen((Window)af);
        }
    }

    private XYSeriesCollection getSeriesCollection() {
        XYSeriesCollection collection = new XYSeriesCollection();
        for (int i = 0; i < this.inSeries.length; ++i) {
            int k;
            int col = i + 1;
            if (this.inDataXY != null) {
                this.inData = this.inDataXY.get(i);
                col = 1;
            }
            String seriesName = this.inSeries[i];
            XYSeries series = new XYSeries((Comparable)((Object)seriesName));
            double previous = 0.0;
            double[] x = new double[this.inData.length];
            double[] y = new double[this.inData.length];
            for (int j = 0; j < this.inData.length; ++j) {
                double value = !this.doCumulate ? this.inData[j][col] : previous + this.inData[j][col];
                x[j] = this.inData[j][0];
                y[j] = value;
                this.max = Math.max(this.max, value);
                this.min = Math.min(this.min, value);
                previous = value;
                if (j <= 1) continue;
                this.minInterval = Math.min(this.minInterval, this.inData[j - 1][0] - this.inData[j][0]);
            }
            if (this.doNormalize) {
                for (k = 0; k < y.length; ++k) {
                    y[k] = y[k] / this.max;
                }
                this.max = 1.0;
                this.min = 0.0;
            }
            for (k = 0; k < y.length; ++k) {
                series.add(x[k], y[k]);
            }
            collection.addSeries(series);
        }
        return collection;
    }

    private JFreeChart doBarChart() {
        ValueAxis domainAxis;
        XYSeriesCollection collection = this.getSeriesCollection();
        XYBarDataset xyBarDataset = new XYBarDataset((XYDataset)collection, this.minInterval);
        PlotOrientation orientation = PlotOrientation.VERTICAL;
        if (this.doHorizontal) {
            orientation = PlotOrientation.HORIZONTAL;
        }
        JFreeChart chart = ChartFactory.createHistogram((String)this.inTitle, (String)this.inLabels[0], (String)this.inLabels[1], (IntervalXYDataset)xyBarDataset, (PlotOrientation)orientation, (boolean)this.doLegend, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setForegroundAlpha(0.85f);
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        double delta = (this.max - this.min) * 0.1;
        yAxis.setRange(this.min, this.max + delta);
        yAxis.setMinorTickCount(4);
        yAxis.setMinorTickMarksVisible(true);
        if (this.inFormats != null && this.inFormats.length > 0 && this.inFormats[1].trim().length() > 0) {
            yAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(this.inFormats[1]));
        }
        if (this.inFormats != null && this.inFormats.length > 0 && this.inFormats[0].trim().length() > 0 && (domainAxis = plot.getDomainAxis()) instanceof NumberAxis) {
            NumberAxis xAxis = (NumberAxis)domainAxis;
            xAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(this.inFormats[0]));
        }
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        renderer.setShadowVisible(false);
        if (this.inColors != null) {
            String[] colorSplit = this.inColors.split(";");
            for (int i = 0; i < colorSplit.length; ++i) {
                String[] split = colorSplit[i].split(",");
                int r = (int)Double.parseDouble(split[0]);
                int g = (int)Double.parseDouble(split[1]);
                int b = (int)Double.parseDouble(split[2]);
                renderer.setSeriesPaint(i, (Paint)new Color(r, g, b));
            }
        }
        return chart;
    }

    private JFreeChart doLineChart() {
        ValueAxis domainAxis;
        XYSeriesCollection collection = this.getSeriesCollection();
        PlotOrientation orientation = PlotOrientation.VERTICAL;
        if (this.doHorizontal) {
            orientation = PlotOrientation.HORIZONTAL;
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.inTitle, (String)this.inLabels[0], (String)this.inLabels[1], (XYDataset)collection, (PlotOrientation)orientation, (boolean)this.doLegend, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer plotRenderer = plot.getRenderer();
        if (plotRenderer instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plotRenderer;
            if (this.doPoints) {
                renderer.setShapesVisible(true);
                renderer.setShapesFilled(true);
            }
            if (this.inColors != null) {
                String[] colorSplit = this.inColors.split(";");
                for (int i = 0; i < colorSplit.length; ++i) {
                    String[] split = colorSplit[i].split(",");
                    int r = (int)Double.parseDouble(split[0]);
                    int g = (int)Double.parseDouble(split[1]);
                    int b = (int)Double.parseDouble(split[2]);
                    renderer.setSeriesPaint(i, (Paint)new Color(r, g, b));
                }
            }
        }
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        double delta = (this.max - this.min) * 0.1;
        yAxis.setRange(this.min, this.max + delta);
        yAxis.setMinorTickCount(4);
        yAxis.setMinorTickMarksVisible(true);
        if (this.inFormats != null && this.inFormats.length > 1 && this.inFormats[1].trim().length() > 0) {
            yAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(this.inFormats[1]));
        }
        if (this.inFormats != null && this.inFormats.length > 0 && this.inFormats[0].trim().length() > 0 && (domainAxis = plot.getDomainAxis()) instanceof NumberAxis) {
            NumberAxis xAxis = (NumberAxis)domainAxis;
            xAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(this.inFormats[0]));
        }
        return chart;
    }
}

