/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.ui;

import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContent;
import org.geotools.map.MapContext;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.JMapFrame;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.geometry.GeometryType;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.style.ColorMap;
import org.opengis.style.Fill;

@Description(value="A simple geodata viewer.")
@Documentation(value="OmsMapsViewer.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Coverage, Raster, Viewer, UI")
@Label(value="Others")
@Name(value="mapsviewer")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class OmsMapsViewer
extends JGTModel {
    @Description(value="The rasters to visualize.")
    @In
    public GridCoverage2D[] inRasters = new GridCoverage2D[0];
    @Description(value="The raster to visualize.")
    @In
    public GridCoverage2D inRaster = null;
    @Description(value="The feature collections to visualize.")
    @In
    public SimpleFeatureCollection[] inVectors = new SimpleFeatureCollection[0];
    @Description(value="The feature collection to visualize.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The feature collections style layer.")
    @In
    public String inSld = null;
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
    private StyleBuilder sb = new StyleBuilder(this.sf, this.ff);
    private Style namedStyle;

    @Execute
    public void displayMaps() throws Exception {
        DefaultMapContext map = new DefaultMapContext();
        map.setTitle("Maps Viewer");
        RasterSymbolizer rasterSym = this.sf.createRasterSymbolizer();
        if (this.inRaster != null) {
            this.inRasters = new GridCoverage2D[]{this.inRaster};
        }
        this.addCoverages((MapContext)map, this.sb, rasterSym);
        if (this.inVector != null) {
            File sldFile;
            this.inVectors = new SimpleFeatureCollection[]{this.inVector};
            if (this.inSld != null && (sldFile = new File(this.inSld)).exists()) {
                SLDParser stylereader = new SLDParser(this.sf, sldFile);
                StyledLayerDescriptor sld = stylereader.parseSLD();
                this.namedStyle = SLD.defaultStyle((StyledLayerDescriptor)sld);
                SLDTransformer aTransformer = new SLDTransformer();
                aTransformer.setIndentation(4);
                String xml = "";
                xml = aTransformer.transform((Object)sld);
                System.out.println(xml);
            }
        }
        this.addFeatureCollections((MapContext)map);
        final JMapFrame frame = new JMapFrame((MapContent)map);
        frame.setSize(800, 600);
        frame.enableStatusBar(true);
        frame.enableTool(new JMapFrame.Tool[]{JMapFrame.Tool.ZOOM, JMapFrame.Tool.PAN, JMapFrame.Tool.RESET});
        frame.enableToolBar(true);
        frame.setVisible(true);
        frame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.setVisible(false);
            }
        });
        while (frame.isVisible()) {
            Thread.sleep(300L);
        }
    }

    private void addFeatureCollections(MapContext map) {
        for (SimpleFeatureCollection fc : this.inVectors) {
            GeometryDescriptor geometryDescriptor = ((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor();
            GeometryType type = GeometryUtilities.getGeometryType(geometryDescriptor.getType());
            switch (type) {
                case MULTIPOLYGON: 
                case POLYGON: {
                    Stroke polygonStroke = this.sf.createStroke((Expression)this.ff.literal((Object)Color.BLACK), (Expression)this.ff.literal(1));
                    org.geotools.styling.Fill polygonFill = this.sf.createFill((Expression)this.ff.literal((Object)Color.RED), (Expression)this.ff.literal(0.5));
                    Rule polygonRule = this.sf.createRule();
                    PolygonSymbolizer polygonSymbolizer = this.sf.createPolygonSymbolizer(polygonStroke, polygonFill, null);
                    polygonRule.symbolizers().add(polygonSymbolizer);
                    FeatureTypeStyle polygonFeatureTypeStyle = this.sf.createFeatureTypeStyle();
                    polygonFeatureTypeStyle.rules().add(polygonRule);
                    this.namedStyle = this.sf.createStyle();
                    this.namedStyle.featureTypeStyles().add(polygonFeatureTypeStyle);
                    this.namedStyle.setName("polygons");
                    break;
                }
                case MULTIPOINT: 
                case POINT: {
                    if (this.namedStyle != null) break;
                    Mark circleMark = this.sf.getCircleMark();
                    org.geotools.styling.Fill fill = this.sf.createFill((Expression)this.ff.literal((Object)Color.RED));
                    circleMark.setFill((Fill)fill);
                    Graphic gr = this.sf.createDefaultGraphic();
                    gr.graphicalSymbols().clear();
                    gr.graphicalSymbols().add(circleMark);
                    Literal size = this.ff.literal(6);
                    gr.setSize((Expression)size);
                    Rule pointRule = this.sf.createRule();
                    PointSymbolizer pointSymbolizer = this.sf.createPointSymbolizer(gr, null);
                    pointRule.symbolizers().add(pointSymbolizer);
                    FeatureTypeStyle pointsFeatureTypeStyle = this.sf.createFeatureTypeStyle();
                    pointsFeatureTypeStyle.rules().add(pointRule);
                    this.namedStyle = this.sf.createStyle();
                    this.namedStyle.featureTypeStyles().add(pointsFeatureTypeStyle);
                    this.namedStyle.setName("points");
                    break;
                }
                case MULTILINE: 
                case LINE: {
                    break;
                }
            }
            map.addLayer((FeatureCollection)fc, this.namedStyle);
        }
    }

    private void addCoverages(MapContext map, StyleBuilder sB, RasterSymbolizer rasterSym) {
        org.geotools.styling.ColorMap colorMap = this.sf.createColorMap();
        for (GridCoverage2D coverage : this.inRasters) {
            RenderedImage renderedImage = coverage.getRenderedImage();
            double max = Double.NEGATIVE_INFINITY;
            double min = Double.POSITIVE_INFINITY;
            RectIter iter = RectIterFactory.create((RenderedImage)renderedImage, null);
            while (true) {
                double value;
                if ((value = iter.getSampleDouble()) > max) {
                    max = value;
                }
                if (value < min) {
                    min = value;
                }
                if (!iter.nextPixelDone()) continue;
                iter.startPixels();
                if (iter.nextLineDone()) break;
            }
            Color fromColor = Color.blue;
            Color midColor = Color.green;
            Color toColor = Color.red;
            Expression fromColorExpr = sB.colorExpression(new Color(fromColor.getRed(), fromColor.getGreen(), fromColor.getBlue(), 255));
            Expression midColorExpr = sB.colorExpression(new Color(midColor.getRed(), midColor.getGreen(), midColor.getBlue(), 255));
            Expression toColorExpr = sB.colorExpression(new Color(toColor.getRed(), toColor.getGreen(), toColor.getBlue(), 255));
            Expression fromExpr = sB.literalExpression(min);
            Expression midExpr = sB.literalExpression(min + (max - min) / 2.0);
            Expression toExpr = sB.literalExpression(max);
            ColorMapEntry entry = this.sf.createColorMapEntry();
            entry.setQuantity(fromExpr);
            entry.setColor(fromColorExpr);
            colorMap.addColorMapEntry(entry);
            entry = this.sf.createColorMapEntry();
            entry.setQuantity(midExpr);
            entry.setColor(midColorExpr);
            colorMap.addColorMapEntry(entry);
            entry = this.sf.createColorMapEntry();
            entry.setQuantity(toExpr);
            entry.setColor(toColorExpr);
            colorMap.addColorMapEntry(entry);
            rasterSym.setColorMap((ColorMap)colorMap);
            Style rasterStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSym});
            map.addLayer((GridCoverage)coverage, rasterStyle);
        }
    }

    public static synchronized void displayRasterAndFeatures(final GridCoverage2D raster, final SimpleFeatureCollection ... vectors) throws Exception {
        new Thread(){

            @Override
            public void run() {
                OmsMapsViewer viewer = new OmsMapsViewer();
                if (raster != null) {
                    viewer.inRasters = new GridCoverage2D[]{raster};
                }
                if (vectors != null) {
                    viewer.inVectors = vectors;
                }
                try {
                    viewer.displayMaps();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }
}

